---
name: lead-magnet
description: "Generate compelling lead magnet concepts that build lists and convert to paid offers. Use when someone needs top-of-funnel ideas, wants to grow their email list, or asks what should I give away for free. Triggers on: lead magnet ideas for X, how do I build my list, what freebie should I create, top of funnel for X, opt-in ideas, grow my email list. Outputs 3-5 lead magnet concepts with hooks, formats, and clear bridges to the paid offer."
---

# Lead Magnet Ideation

The best lead magnets aren't about what you want to give away. They're about what your prospect desperately wants to consume—and how that consumption naturally leads them toward your paid offer.

This skill generates lead magnet concepts that actually convert.

---

## The core job

When someone asks for lead magnet ideas, the goal is to surface **multiple compelling concepts** they can choose from—each with a clear hook, format, and bridge to their paid offer.

Every business has several valid lead magnet approaches. The question is which one best matches their audience, business model, and offer.

Output format: **3-5 distinct lead magnet concepts**, each with:
- The concept (what it is, in one sentence)
- The format (quiz, PDF, calculator, challenge, template, etc.)
- The hook (why someone would want this badly enough to give their email)
- The bridge (how it naturally leads to the paid offer)
- Implementation notes (difficulty level, resources needed)

---

## Before generating: Understand the context

### Step 1: Identify the business type

Different business types have different optimal lead magnet formats:

**Info Products (courses, memberships, coaching):**
- Quizzes and assessments work exceptionally well
- Challenges (5-day, 7-day) build momentum and community
- PDF frameworks that solve one specific problem
- Video series that demonstrate teaching style
- Free chapters or modules as taste of full product

**SaaS (software, tools, apps):**
- Free tools or constrained versions of the product
- ROI calculators that quantify the value
- Templates that work with the product
- Checklists and implementation guides
- Free trials (not technically a "lead magnet" but same function)

**Services (agencies, consultants, freelancers):**
- Audits that reveal problems the service solves
- Assessments that diagnose the prospect's situation
- Case studies that prove capability
- Strategy sessions or consultations
- Templates that showcase methodology

### Step 2: Identify what they sell

Not the product. The transformation.

What does the customer's life look like AFTER? What pain disappears? What capability appears? What status changes?

The lead magnet should deliver a MICRO-VERSION of that same transformation.

### Step 3: Identify who they're targeting

- What's the prospect's current situation?
- What have they already tried?
- What do they believe about the problem?
- What would make them say "this is exactly what I needed"?

---

## The lead magnet framework

### The Specificity Principle

**Narrow beats broad. Every time.**

"5-Step Framework to Land Your First 10 Clients in 30 Days (Even If You Hate Networking)" converts dramatically better than "Marketing Guide for Freelancers."

Why? Specificity signals:
1. This was made for someone exactly like me
2. The creator deeply understands my situation
3. This isn't generic advice I could find anywhere

When generating concepts, always push toward specificity:
- Specific outcome (not "grow your business" but "add $10k MRR")
- Specific timeframe (not "eventually" but "in 30 days")
- Specific audience (not "entrepreneurs" but "B2B SaaS founders")
- Specific method (not "marketing tips" but "The LinkedIn DM Framework")

### The Bridge Principle

**The lead magnet must logically connect to the paid offer.**

If someone downloads a lead magnet about Instagram growth and you sell SEO services, there's no bridge. You've attracted people interested in the wrong thing.

The best lead magnets are "Step 1" of what you sell:
- Course on copywriting → Lead magnet: "The Headline Formula" (first skill taught in course)
- Agency doing SEO audits → Lead magnet: Free mini-audit (demonstrates what full audit reveals)
- Coach on productivity → Lead magnet: "Morning Routine Builder" (taste of coaching methodology)

The bridge should be obvious: "If you liked this free thing, the paid thing is more/deeper/complete."

### The Quick Win Principle

**Solve one specific problem completely.**

Prospects want immediate, actionable value. A lead magnet that requires weeks of study before generating results feels like homework, not a gift.

The best lead magnets deliver a quick win:
- A checklist they can complete in 10 minutes that reveals gaps
- A template they can customize in an hour for their business
- An assessment that gives them a score and action items immediately
- A calculator that shows them their specific numbers right now

Quick wins create reciprocity. When someone thinks "I couldn't have created this myself," they're primed to value your paid offer.

### The Value Equation

Apply Hormozi's value equation to lead magnet concepts:

**Value = (Dream Outcome × Perceived Likelihood) / (Time Delay × Effort)**

Maximize:
- **Dream Outcome:** What's the transformation this lead magnet promises?
- **Perceived Likelihood:** Why will THIS work when other things haven't?

Minimize:
- **Time Delay:** How fast do they see results? (Immediate beats weeks)
- **Effort:** How easy is it to consume and implement? (5-minute checklist beats 50-page guide)

---

## The format selection framework

### When to use each format:

**Quizzes/Assessments**
Best for: Personalization, segmentation, transformation-focused offers
Examples: "What's Your Marketing Personality?", "Find Your Ideal Client Avatar"
Why it works: People love learning about themselves; provides segmentation data
Difficulty: Medium (needs quiz tool, logic branching)

**PDF Guides/Frameworks**
Best for: Establishing authority, comprehensive solutions, complex topics
Examples: "The Ultimate Guide to X", "7-Step Framework for Y"
Why it works: Perceived high value, easy to create, works across all business types
Difficulty: Low (just need content and design)

**Checklists/Templates**
Best for: Quick wins, immediate utility, showcasing methodology
Examples: "Launch Day Checklist", "Content Calendar Template"
Why it works: Immediate actionability, low friction to consume
Difficulty: Low

**Calculators/Tools**
Best for: SaaS, financial services, ROI-focused offers
Examples: "ROI Calculator", "Pricing Calculator", "Savings Estimator"
Why it works: Personalized output, demonstrates tangible value
Difficulty: Medium-High (needs development)

**Challenges (5-day, 7-day, etc.)**
Best for: Community building, transformation offers, coaching
Examples: "5-Day List Building Challenge", "7-Day Productivity Sprint"
Why it works: Creates engagement, builds habit, demonstrates results
Difficulty: Medium (needs email sequence, possibly community)

**Video Series/Mini-Courses**
Best for: Demonstrating teaching style, complex topics, high-ticket offers
Examples: "3-Part Video Training", "Free Masterclass"
Why it works: Builds relationship, showcases expertise deeply
Difficulty: Medium (needs video production)

**Free Audits/Assessments**
Best for: Services, agencies, consultants
Examples: "Free Website Audit", "Marketing Assessment"
Why it works: Reveals problems you solve, demonstrates expertise
Difficulty: Medium (needs time investment per lead)

**Swipe Files/Resource Lists**
Best for: Creative industries, marketing, copywriting
Examples: "50 High-Converting Headlines", "The Ultimate Tool Stack"
Why it works: Massive perceived value, immediately useful
Difficulty: Low

---

## The hook generators

Every lead magnet needs a hook—the reason someone would want it badly enough to give their email.

### Hook Type 1: The Shortcut
"Get the [outcome] without [usual pain/time/effort]"
> "The 5-Minute Morning Routine That Replaced My 2-Hour Gym Sessions"

### Hook Type 2: The Secret
"The [hidden thing] that [impressive result]"
> "The Pricing Secret That Doubled My Agency's Revenue"

### Hook Type 3: The System
"The [named method] for [specific outcome]"
> "The PASTOR Framework: Write Sales Pages in 30 Minutes"

### Hook Type 4: The Specific Number
"[Number] [things] to [outcome]"
> "7 Email Subject Lines That Get 40%+ Open Rates"

### Hook Type 5: The Assessment
"Discover your [type/score/level]"
> "What's Your Entrepreneur Personality Type? Take the 2-Minute Quiz"

### Hook Type 6: The Transformation
"How to go from [painful current state] to [desired outcome]"
> "From Stuck at $5k/month to Consistent $20k Months: The Roadmap"

### Hook Type 7: The Case Study
"How [specific person/company] achieved [specific result]"
> "How Sarah Built a 10,000-Person Email List in 90 Days (And You Can Too)"

---

## Output format

When generating lead magnet concepts, deliver this:

### Lead Magnet Options for [Product/Offer]

**Concept 1: [Name]**
- The concept: [One sentence description]
- Format: [Quiz/PDF/Calculator/Challenge/etc.]
- The hook: "[The headline/promise]"
- The bridge: [How this leads to the paid offer]
- Implementation: [Difficulty + what's needed]

**Concept 2: [Name]**
- The concept: [One sentence description]
- Format: [Quiz/PDF/Calculator/Challenge/etc.]
- The hook: "[The headline/promise]"
- The bridge: [How this leads to the paid offer]
- Implementation: [Difficulty + what's needed]

[Continue for 3-5 total concepts]

**Recommended starting point:** [Which concept to test first and why]

---

## Example: Lead magnets for a copywriting course

### Context
- Product: $997 copywriting course for freelancers
- Transformation: Go from struggling writer to $10k+/month copywriter
- Audience: Aspiring or early-stage freelance copywriters
- Business type: Info product

### Lead Magnet Options

**Concept 1: The Headline Swipe File**
- The concept: Collection of 100+ proven headlines organized by type with analysis of why each works
- Format: PDF swipe file
- The hook: "100 Proven Headlines That Generated Millions (Steal Them)"
- The bridge: Headlines are the first skill taught in the course; demonstrates the "why behind what works" teaching style
- Implementation: Low difficulty; compile and design

**Concept 2: The Copywriter Income Quiz**
- The concept: 10-question assessment that diagnoses what's holding them back from higher income
- Format: Interactive quiz
- The hook: "Why Aren't You Making $10k/Month as a Copywriter? Take the 2-Minute Quiz"
- The bridge: Quiz results reveal specific gaps the course addresses; segmentation enables personalized follow-up
- Implementation: Medium difficulty; needs quiz tool (Typeform, ScoreApp)

**Concept 3: The First Client Framework**
- The concept: Step-by-step PDF showing exactly how to land the first (or next) $1,000 client
- Format: PDF framework
- The hook: "The 5-Step Framework to Land Your First $1,000 Client This Week"
- The bridge: Getting clients is a key module; this is the "quick start" version that proves the methodology
- Implementation: Low difficulty; write and design

**Concept 4: The 5-Day Copy Challenge**
- The concept: Daily email challenge where they write one piece of copy each day with feedback
- Format: Email challenge
- The hook: "5 Days to Better Copy: A Free Challenge for Aspiring Copywriters"
- The bridge: Challenge demonstrates teaching style, builds relationship, ends with course offer
- Implementation: Medium difficulty; needs 5 emails + daily prompts

**Concept 5: The Pricing Calculator**
- The concept: Tool that helps them calculate what to charge based on project type, experience, and market
- Format: Interactive calculator/spreadsheet
- The hook: "Stop Undercharging: The Copywriter Pricing Calculator"
- The bridge: Pricing is a major pain point; calculator demonstrates expertise on business side of copywriting
- Implementation: Medium difficulty; needs spreadsheet or simple tool

**Recommended starting point:** Concept 1 (Headline Swipe File) for fastest implementation with high perceived value, or Concept 2 (Income Quiz) if segmentation and personalized follow-up is a priority.

---

## How this skill gets invoked

This skill activates when:
- User asks "what lead magnet should I create for X"
- User asks "how do I build my email list"
- User asks for "top of funnel ideas" or "freebie ideas"
- User asks "what should I give away for free"
- User needs to grow their audience before launching
- Landing page skill needs a lead magnet offer to convert to
- Email sequence skill needs a lead magnet to deliver

When another skill needs a lead magnet, this skill can provide the concept that informs downstream work.

---

## What this skill is NOT

This skill generates lead magnet CONCEPTS. It does NOT:
- Write the actual lead magnet content (that's separate work)
- Build the landing page (that's landing-page skill)
- Write the email sequence (that's email-sequence skill)
- Design the visual assets (that's design work)

The output is strategic direction on WHAT to create, not the creation itself.

---

## The test

Before delivering concepts, verify each one:

1. **Is it specific?** Vague lead magnets (like "Marketing Tips") fail. Specific ones convert.

2. **Does it solve one problem completely?** Not a teaser—a genuine quick win.

3. **Is the bridge obvious?** Can you see how consuming this leads to wanting the paid offer?

4. **Would the target audience actually want this?** Not "should want"—ACTUALLY want, right now.

5. **Is it feasible to create?** Match implementation difficulty to available resources.

---

## References

For deeper frameworks, see the `references/` folder:
- `format-examples.md` — Best-in-class examples by format type
- `info-product-magnets.md` — Russell Brunson, Amy Porterfield, and info product approaches
- `saas-magnets.md` — HubSpot, Ahrefs, and SaaS-specific patterns
- `services-magnets.md` — Agency and consulting lead magnet strategies
- `psychology.md` — The psychology behind why lead magnets convert
