# Lead Magnet Format Examples

Best-in-class examples organized by format type.

---

## Quizzes & Assessments

### What They Are
Interactive experiences that ask questions and provide personalized results.

### Why They Convert (15-25% typical)
- People love learning about themselves
- Personalized results feel valuable
- Curiosity drives completion
- Enables segmentation for follow-up

### Best-in-Class Examples

**Ryan Levesque's "Quiz Funnel"**
- Diagnoses what's holding entrepreneurs back
- Segments into "buckets" with tailored follow-up
- Results reveal specific problem → product solves that problem

**Sally Hogshead's "How To Fascinate"**
- Personality assessment for personal branding
- Detailed report on your "fascination advantage"
- Results lead to books, courses, certification

**HubSpot's Website Grader**
- Enter URL, get instant website analysis
- Scores across multiple dimensions
- Problems revealed → HubSpot solutions offered

### When to Use
- When personalization adds value
- When segmentation improves follow-up
- When diagnosis precedes prescription
- For transformation-focused offers

### Implementation
**Tools:** Typeform, ScoreApp, Bucket.io, Interact
**Effort:** Medium (logic, questions, results pages)
**Time to create:** 1-2 weeks

---

## PDF Guides & Frameworks

### What They Are
Downloadable documents that teach, explain, or provide frameworks.

### Why They Convert (2-8% typical)
- High perceived value
- Easy to create
- Demonstrates expertise
- Shareable/referenceable

### Best-in-Class Examples

**Marie Forleo's "3 Toxic Lies That Keep You Overwhelmed"**
- Specific problem addressed
- Contrarian angle (what you believe is wrong)
- Emotionally charged topic

**HubSpot's State of Marketing Report**
- Original research and data
- Industry authority positioning
- Annual refresh creates recurring lead gen

**Amy Porterfield's Launch Checklist**
- Immediately actionable
- Specific use case (launching)
- Comprehensive but scannable

### When to Use
- Establishing thought leadership
- Complex topics needing explanation
- When comprehensive > interactive
- Resource-constrained situations

### Implementation
**Tools:** Canva, Google Docs, Adobe InDesign
**Effort:** Low to Medium (writing + design)
**Time to create:** Days to weeks

---

## Checklists & Templates

### What They Are
Ready-to-use documents that provide structure for specific tasks.

### Why They Convert (5-15% typical)
- Immediate utility
- Low friction to consume
- Demonstrates methodology
- Creates repeated usage

### Best-in-Class Examples

**Notion's Template Gallery**
- Thousands of templates for every use case
- Shows product flexibility
- Community-created content scales endlessly

**HubSpot's Sales Plan Template**
- Fills a specific need (planning)
- Showcases sales methodology
- Leads naturally to CRM conversation

**OptinMonster's "785% Conversion" Content Upgrades**
- Highly specific to blog post topics
- Perfect match = perfect conversion
- Quick to implement

### When to Use
- When immediate action matters
- For specific, repeatable tasks
- When methodology demonstration needed
- As content upgrades for existing content

### Implementation
**Tools:** Google Docs, Notion, Canva
**Effort:** Low
**Time to create:** Hours to days

---

## Calculators & Tools

### What They Are
Interactive tools that process inputs and provide personalized outputs.

### Why They Convert (10-20% typical)
- Personalized results
- Immediate utility
- Demonstrates product thinking
- Captures valuable data

### Best-in-Class Examples

**IBM's ROI Calculators**
- Quantifies value in prospect's context
- Supports business case building
- Multiple calculators for different use cases

**Ahrefs' Free Webmaster Tools**
- Constrained version of paid product
- Genuine utility at free tier
- Natural upgrade path

**CartHook's Conversion Calculator**
- Shows revenue impact of conversion improvements
- Prospects see their own potential
- Creates urgency around missed opportunity

### When to Use
- When value is quantifiable
- For SaaS or financial services
- When personalization matters
- To demonstrate product capability

### Implementation
**Tools:** Spreadsheets, Calconic, custom development
**Effort:** Medium to High
**Time to create:** Weeks

---

## Challenges (5-Day, 7-Day, etc.)

### What They Are
Multi-day structured experiences with daily content and actions.

### Why They Convert (varies widely)
- Creates transformation through action
- Daily touchpoints build relationship
- Community element adds accountability
- Demonstrates teaching/coaching style

### Best-in-Class Examples

**Russell Brunson's "One Funnel Away Challenge"**
- 30 days of intensive training
- Multiple experts contribute
- Community and accountability
- Transformation → product adoption

**Brendon Burchard's "5-Day High Performance" Challenges**
- Daily video + action
- Community discussion
- Personal coaching taste
- Ends with program offer

### When to Use
- For transformation-focused offers
- When community adds value
- To demonstrate coaching style
- Building momentum toward launch

### Implementation
**Tools:** Email platform, community platform, video hosting
**Effort:** High
**Time to create:** Weeks to months

---

## Video Series & Webinars

### What They Are
Video content delivered live or recorded, teaching specific topics.

### Why They Convert (varies widely)
- Demonstrates teaching quality
- Builds relationship through presence
- Extended engagement
- Natural pitch opportunity

### Best-in-Class Examples

**Amy Porterfield's Webinars**
- Live element creates urgency
- 60-90 minute deep dives
- Teaching + story + offer structure
- High conversion to signature courses

**Amazing's 4-Part Video Series**
- Sequential learning builds
- Countdown timers create urgency
- Each video leads to next
- Final video includes offer

### When to Use
- High-ticket offers
- When teaching quality matters
- Building relationship before ask
- Complex topics needing demonstration

### Implementation
**Tools:** Zoom, Loom, Webinar platforms
**Effort:** Medium to High
**Time to create:** Weeks

---

## Free Audits & Assessments

### What They Are
Analysis of the prospect's current situation, delivered as a report.

### Why They Convert (high intent, lower volume)
- Uses their actual data
- Reveals specific problems
- Demonstrates expertise directly
- Creates natural sales conversation

### Best-in-Class Examples

**Marketing Agency Website Audits**
- SEO, performance, security analysis
- Specific issues identified
- Competitor comparison included
- Recommendations prioritized

**Law Firm Case Evaluations**
- Preliminary viability assessment
- Deadline/statute information
- Next steps clearly outlined
- Automatic qualification

### When to Use
- Services businesses
- When diagnosis precedes service
- For high-value prospects
- To demonstrate capability

### Implementation
**Tools:** Analysis tools, report templates
**Effort:** High (per lead)
**Time to create:** Hours per audit

---

## Swipe Files & Resource Collections

### What They Are
Curated collections of examples, templates, or resources.

### Why They Convert (5-15% typical)
- Massive perceived value
- Immediately useful
- Saves hours of research
- Demonstrates taste/expertise

### Best-in-Class Examples

**Copyblogger's "Magnetic Headlines" Swipe File**
- 100+ proven headlines
- Organized by type
- Analysis of why each works

**Pat Flynn's Resource Guides**
- Curated tool recommendations
- Experience-based selections
- Regularly updated

### When to Use
- Creative industries
- When curation adds value
- Teaching through example
- Building comprehensive resources

### Implementation
**Tools:** Google Docs, Notion, PDF
**Effort:** Low to Medium
**Time to create:** Days to weeks

---

## Format Selection Matrix

| Format | Conversion | Effort | Best For |
|--------|------------|--------|----------|
| Quiz/Assessment | High | Medium | Segmentation, personalization |
| PDF Guide | Medium | Low-Medium | Authority, education |
| Checklist/Template | Medium | Low | Quick wins, methodology |
| Calculator/Tool | High | High | Quantifiable value |
| Challenge | Varies | High | Transformation, community |
| Video Series | Varies | Medium-High | Relationship, teaching |
| Free Audit | High (low vol) | High | Services, diagnosis |
| Swipe File | Medium | Low | Curation, examples |

---

## Matching Format to Business Type

**Info Products:** Quizzes, Challenges, Video Series, PDF Guides
**SaaS:** Calculators, Free Tools, Templates, Checklists
**Services:** Audits, Assessments, Case Studies, Consultations
**All Types:** Checklists, Templates, Swipe Files work universally

---

## Testing Your Format Choice

1. **Does the format match how your audience consumes content?** (Some prefer video, some prefer reading)
2. **Does the format demonstrate what makes you unique?** (Teaching style, methodology, expertise)
3. **Does the format naturally lead to your offer?** (The bridge should be obvious)
4. **Can you execute this format well?** (Bad video is worse than good PDF)
5. **Does the effort match the potential return?** (High-effort for low-value offer = mismatch)
