# Info Product Lead Magnet Strategies

Best-in-class examples from the information product and coaching industry.

---

## Russell Brunson (ClickFunnels)

### The Free Book Funnel
Brunson pioneered the "free + shipping" book offer as a lead magnet. His books (DotCom Secrets, Expert Secrets, Traffic Secrets) are offered "free" with the customer paying only shipping.

**Why it works:**
- High perceived value (physical book vs. PDF)
- Micro-commitment (paying shipping crosses psychological threshold)
- Extended engagement (books take hours to read, building relationship)
- Upsell opportunity (order form bump, one-click upsells)

**The bridge:** Books teach methodology → Software (ClickFunnels) implements methodology

### The Challenge Funnel
The "One Funnel Away Challenge" is a 30-day challenge with daily training from Brunson and team.

**Why it works:**
- Creates transformation through action
- Daily touchpoints build relationship
- Community element adds accountability
- Demonstrates coaching/teaching style

**The bridge:** Challenge creates first funnel → ClickFunnels needed to build more

### Key Brunson Principles
1. "Value Ladder" — Lead magnet is the first rung, each step increases commitment
2. "Hook, Story, Offer" — Every lead magnet needs all three elements
3. "Attractive Character" — Lead magnet should introduce your personality/story

---

## Amy Porterfield (Online Marketing Expert)

### The Checklist Approach
Porterfield's "Must-Have Lead Magnet Launch Checklist" is meta—a lead magnet about creating lead magnets.

**Why it works:**
- Immediately actionable (checklist format)
- Highly specific (launch checklist, not general marketing)
- Solves one problem completely
- Low friction to consume

**The bridge:** Checklist helps create lead magnet → Course teaches full online business system

### The Webinar Model
Porterfield heavily uses webinars as lead magnets, converting viewers to her signature courses.

**Why it works:**
- Demonstrates teaching quality
- Creates urgency (live event)
- Extended engagement (60-90 minutes)
- Natural pitch opportunity at end

**Key Porterfield Principles:**
1. Specificity over comprehensiveness
2. "I will always go first" — prove concepts before teaching
3. Meet audience where they are, not where you want them to be

---

## Pat Flynn (Smart Passive Income)

### The Resource Guide
Flynn's lead magnets are often comprehensive resource guides—curated tools, templates, and recommendations.

**Why it works:**
- Massive perceived value (saves hours of research)
- Immediately useful
- Demonstrates expertise through curation
- Creates reciprocity through generosity

**The bridge:** Free resources → Paid courses on implementing strategies

### The Case Study Approach
Flynn shares detailed income reports and case study breakdowns as lead magnets.

**Why it works:**
- Social proof through transparency
- Actionable because specific
- Builds trust through vulnerability
- Creates "if he can do it, I can too" feeling

---

## Ryan Levesque (ASK Method)

### The Quiz Funnel
Levesque built his entire business around the quiz as lead magnet. His "bucket" quiz segments prospects into distinct categories.

**Why it works:**
- Personalization (results feel custom)
- Segmentation (enables targeted follow-up)
- Curiosity (people love learning about themselves)
- Data collection (understand your audience)

**The mechanism:**
1. Ask diagnostic questions
2. Segment into 3-5 "buckets"
3. Deliver customized results + recommendations
4. Follow up with bucket-specific messaging

**The bridge:** Quiz identifies problem → Product/service solves that specific problem

### Key Levesque Principles:
1. "ASK, don't tell" — Diagnosis before prescription
2. Micro-commitments build engagement
3. The right message to the right person at the right time

---

## Marie Forleo (B-School)

### The Problem-Focused Ebook
Forleo's "3 Toxic Lies That Keep You Overwhelmed & Underearning" targets a specific emotional pain point.

**Why it works:**
- Emotionally charged topic
- Specific problem (not generic advice)
- Promise is read in an hour, life changes forever
- Contrarian angle (what you believe is wrong)

**The bridge:** Ebook reveals mindset blocks → B-School provides full business training

### The Free Training Model
Forleo's "Start The Right Business" free training series.

**Why it works:**
- Multi-part series creates multiple touchpoints
- Video format builds relationship
- Sequential learning builds momentum
- Natural lead-in to paid program

---

## Tony Robbins (Personal Development)

### The Free Coaching Session
Robbins offers free "Results Coaching" strategy sessions.

**Why it works:**
- Highest-intent lead magnet (requires scheduling commitment)
- Personalized attention creates reciprocity
- Immediate value through actual coaching
- Direct qualification (coach assesses fit)

**The bridge:** Free session → Paid coaching program or event tickets

### The Assessment Model
Robbins uses various life assessments to identify where people need help.

**Why it works:**
- Self-discovery is compelling
- Results reveal gaps programs address
- Personalized report feels valuable
- Enables targeted follow-up

---

## Common Patterns in Info Product Lead Magnets

### Format Preferences:
1. **Quizzes** — High engagement, enables segmentation
2. **Challenges** — Creates transformation, builds community
3. **Video series** — Demonstrates teaching style, builds relationship
4. **PDF frameworks** — Quick wins, easy to create
5. **Free + shipping books** — High perceived value, micro-commitment

### What Works:
- Specificity (narrow problem > broad topic)
- Quick wins (immediate results)
- Personality (introduce the attractive character)
- Transformation preview (taste of what full program delivers)

### The Bridge Pattern:
Info product lead magnets almost always follow this bridge:
**Lead magnet delivers micro-transformation → Paid product delivers full transformation**

The lead magnet proves the methodology works. The paid product is "more of what worked."

---

## Implementation Notes

**Easiest to create:** PDF checklists, frameworks, swipe files
**Highest converting:** Quizzes, challenges, free strategy sessions
**Best for relationship building:** Video series, challenges, free coaching

**Tech requirements by format:**
- PDFs: Design tool (Canva), email platform
- Quizzes: Quiz tool (Typeform, ScoreApp, Bucket.io)
- Challenges: Email platform, possibly community platform
- Video series: Video hosting, email platform
- Webinars: Webinar platform, email platform
