---
name: lead-qualification
description: Use when evaluating ICP fit, buying intent, and routing priority for new leads.
---

# Lead Qualification Skill

## When to Use
- New inbound/outbound leads need scoring before SDR outreach.
- Marketing > Sales handoff requires consistent acceptance criteria.
- You must prioritize high-intent signals for limited SDR capacity.
- RevOps wants transparent scoring logic tied to pipeline stages.

## Framework
1. **FITS Model** – Firmographics, Intent, Timing, Solution Match as core dimensions.
2. **Scoring Steps** – normalize data, apply weights, set thresholds (80+, 60–79, 40–59, <40), and capture explainability notes.
3. **Question Toolkit** – pain, authority, budget, timeline prompts to validate scoring inputs.
4. **Routing Logic** – map scores to AE handoff, SDR follow-up, nurture, or recycle.
5. **Handoff Checklist** – verify CRM data, attach notes/enrichment, include recommended CTA, start AE SLA timer.

## Templates
- Fit scoring sheet (CSV) with weight columns and notes.
- Intent signal decoder (G2 topics → pains) for faster scoring.
- Playbooks for inbound vs outbound vs PQL models.
- Handoff checklist doc for SDRs.

## Tips
- Review weights quarterly with RevOps to match evolving ICP.
- Keep explainability notes so AEs trust automated scores.
- Pair scoring with QA sampling to catch bad data feeds early.
- Share top intent triggers weekly so marketing can reinforce them.

---
