# Outreach Strategy Guide

This document provides proven outreach templates, messaging strategies, and multi-channel cadence recommendations for engaging qualified leads.

## Table of Contents

- [Outreach Principles](#outreach-principles)
- [Channel Selection Guide](#channel-selection-guide)
- [Message Templates by Tier](#message-templates-by-tier)
- [Personalization Framework](#personalization-framework)
- [Multi-Touch Cadences](#multi-touch-cadences)
- [Email Best Practices](#email-best-practices)
- [LinkedIn Strategies](#linkedin-strategies)
- [Phone/Video Outreach](#phonevideo-outreach)

---

## Outreach Principles

### The 3 Cs of Effective Outreach

1. **Context** - Show you understand their business and challenges
2. **Credibility** - Demonstrate expertise and social proof
3. **Clarity** - Make the value proposition and next step obvious

### What Makes Outreach Work

**Good outreach**:
- ✅ Personalized to the recipient and company
- ✅ Addresses a specific pain point or opportunity
- ✅ Provides value before asking for anything
- ✅ Has clear, low-friction CTA
- ✅ Respects their time (< 150 words for cold email)

**Bad outreach**:
- ❌ Generic, template-obvious messaging
- ❌ Focuses on your product features
- ❌ No research or personalization
- ❌ Multiple CTAs or unclear next steps
- ❌ Long-winded explanations

### Research-Based Personalization

**Always include 2-3 of these personalization elements**:

| Element | Example | Source |
|---------|---------|--------|
| **Recent company news** | "Congrats on the Series B!" | Crunchbase, news search |
| **Hiring signals** | "Saw you're hiring API engineers..." | LinkedIn jobs |
| **Product launches** | "Just launched on Product Hunt..." | Product Hunt, blog |
| **Thought leadership** | "Loved your post on API design..." | LinkedIn, blog |
| **Mutual connections** | "Jane Doe suggested I reach out..." | LinkedIn |
| **Technology stack** | "Noticed you're using AWS..." | Job posts, BuiltWith |
| **Pain point mention** | "Saw your G2 review about..." | Reviews, forums |

---

## Channel Selection Guide

### When to Use Each Channel

| Channel | Best For | Response Rate | Speed to Response |
|---------|----------|---------------|-------------------|
| **Email** | First touch, detailed value prop | 5-15% | 2-5 days |
| **LinkedIn** | Warm connection, peer-to-peer | 20-40% | 1-3 days |
| **Phone** | High-value accounts, established rapport | 2-5% | Immediate |
| **Video (Loom)** | Differentiation, complex value props | 15-30% | 1-2 days |
| **Social engagement** | Building familiarity over time | N/A | Ongoing |

### Multi-Channel Sequencing

**A-Tier Leads** (immediate, aggressive):
1. LinkedIn connection request
2. Email (day 2, if LinkedIn accepted)
3. LinkedIn message (day 5)
4. Email #2 (day 8)
5. Phone call (day 12)
6. Video message (day 15)
7. LinkedIn comment on their content (ongoing)

**B-Tier Leads** (measured, educational):
1. Email #1 (valuable content)
2. LinkedIn connection (day 3)
3. Email #2 (case study)
4. LinkedIn message (day 10)
5. Email #3 (invitation to webinar)

**C-Tier Leads** (passive nurture):
1. Email #1 (educational content)
2. Monthly newsletter
3. LinkedIn engagement (likes, comments)
4. Quarterly re-engagement email

---

## Message Templates by Tier

### A-Tier Templates

**Template A1: Recent Funding Hook**

```
Subject: Congrats on the Series B, [First Name]

Hi [First Name],

Congrats on the $[X]M Series B! Saw the announcement on TechCrunch.

As you scale [Company]'s engineering team, you'll likely face [specific challenge related to your solution].

We help companies like [Similar Company] solve this by [brief value prop in 10 words].

[Similar Company] saw [specific metric: 40% faster deployments, 60% fewer API errors, etc.] within 60 days.

Worth a 15-min conversation to see if there's a fit?

Best,
[Your Name]

P.S. - Loved your post on [recent content they published]. [Specific insight].
```

**Template A2: Hiring Signal Hook**

```
Subject: Re: [Job Title] role at [Company]

Hi [First Name],

Noticed you're hiring for a [Job Title]. That role usually signals [insight about what they're trying to solve].

Most companies at your stage struggle with [pain point]. We help [job function] teams solve this with [solution approach].

Quick example: [Company in same vertical] reduced [pain point metric] by [%] using our platform.

Open to a brief call to share how they did it?

[Your Name]

---
[Signature with social proof: "Trusted by [Customer Logos]"]
```

**Template A3: Thought Leadership Hook**

```
Subject: Your [topic] post resonated

[First Name],

Your LinkedIn post on [topic] really resonated - especially the point about [specific insight].

At [Your Company], we see this challenge constantly with [customer segment].

We actually solved [related pain point] for [Similar Company] by [approach]. They went from [before state] to [after state] in [timeframe].

Happy to share the playbook if it's relevant to what you're building at [Company].

Best,
[Your Name]
```

### B-Tier Templates

**Template B1: Problem-Solution Focus**

```
Subject: Solving [pain point] for [company type] companies

Hi [First Name],

Working with [industry] companies like [Similar Company 1] and [Similar Company 2], I've noticed a common pattern:

As teams scale past [size/milestone], [specific pain point] becomes a major bottleneck.

We built [Product] specifically to solve this. Here's how it works:
- [Benefit 1 in 5 words]
- [Benefit 2 in 5 words]
- [Benefit 3 in 5 words]

Would a 15-minute overview be valuable? Here's a [link to 2-min demo video] to see if it's worth your time.

Best,
[Your Name]
```

**Template B2: Case Study Lead**

```
Subject: How [Similar Company] achieved [impressive metric]

[First Name],

[Similar Company] (also in [industry]) was struggling with [pain point] as they scaled from [X] to [Y] employees.

Using [Your Solution], they:
• [Specific result 1]
• [Specific result 2]
• [ROI metric]

I put together a 2-page case study on exactly how they did it. Want me to send it over?

If it's relevant, we can explore how [Company] could see similar results.

Best,
[Your Name]

[Case Study Link]
```

**Template B3: Educational Value First**

```
Subject: [Industry] API best practices guide

Hi [First Name],

Saw that [Company] is in the [space] - we work with a lot of [industry] companies on [related topic].

Put together a guide on [specific topic: "API Testing at Scale", "DevOps Security Patterns", etc.] based on interviews with [X] [industry] engineering leaders.

Thought it might be valuable for your team. [Link to guide]

No strings attached - just sharing what we've learned working with [Similar Company 1], [Similar Company 2], etc.

Happy to chat if you find it useful and want to discuss how we could help [Company].

Best,
[Your Name]
```

### C-Tier Templates

**Template C1: Soft Introduction**

```
Subject: Quick intro - [Your Company] + [Their Company]

[First Name],

We help [customer segment] companies solve [pain point category].

Not sure if this is a priority for [Company] right now, but thought I'd introduce ourselves.

Happy to send over some resources on [topic] if it's relevant:
- [Resource 1]
- [Resource 2]
- [Case Study]

Let me know if you'd like me to share any of these.

Best,
[Your Name]
```

**Template C2: Value-Add Content**

```
Subject: [Industry] benchmarking data

Hi [First Name],

We recently published benchmark data on [metric] across [X] [industry] companies:

[Interesting stat 1]
[Interesting stat 2]
[Interesting stat 3]

Full report here: [Link]

Thought it might be interesting context for your work at [Company].

Best,
[Your Name]
```

---

## Personalization Framework

### The 5-Point Personalization Checklist

Before sending any outreach, verify you have:

1. ✅ **Company-specific research** - Mention something unique about their business
2. ✅ **Individual research** - Reference their role, background, or content
3. ✅ **Relevant timing** - Tie to a recent event or signal
4. ✅ **Specific value** - Explain why this matters to them, not just to you
5. ✅ **Social proof** - Include customer similar to them

### Personalization by Data Available

#### High Data Quality (LinkedIn + Crunchbase + ZoomInfo)

Personalize on:
- Recent funding round and growth plans
- Specific technologies in their stack
- Recent hire profiles (titles from LinkedIn)
- Leadership team backgrounds
- Recent company posts or initiatives

**Example**:
> "Congrats on bringing on Jane Smith as VP Engineering - her background at [Previous Company] suggests you're investing heavily in API infrastructure. That's actually why I'm reaching out..."

#### Medium Data Quality (LinkedIn only)

Personalize on:
- Company size and growth
- Industry vertical
- Recent company posts
- Job openings (if available)
- Their LinkedIn activity/posts

**Example**:
> "Saw [Company] just crossed 150 employees - that's the inflection point where most [industry] companies start experiencing [pain point]..."

#### Low Data Quality (Website only)

Personalize on:
- What they sell (from website)
- Customer types they serve
- Industry pain points (general)
- Company stage (startup, scale-up, enterprise)

**Example**:
> "Companies in the [industry] space typically face [pain point] as they scale. Wondering if this resonates with what you're seeing at [Company]?"

---

## Multi-Touch Cadences

### A-Tier: 7-Touch Aggressive Sequence (15 days)

| Day | Channel | Message Type | Goal |
|-----|---------|--------------|------|
| 1 | LinkedIn | Connection request with note | Get accepted |
| 2 | Email | Personalized value prop | Book meeting |
| 5 | LinkedIn DM | Different angle, add value | Re-engage |
| 8 | Email | Case study / social proof | Build credibility |
| 12 | Phone | Leave voicemail with value | Create urgency |
| 15 | Video (Loom) | Personalized video message | Differentiate |
| 18 | Email | "Break-up" email | Last attempt |

**Response expected**: 25-40% by touch 7

### B-Tier: 5-Touch Educational Sequence (21 days)

| Day | Channel | Message Type | Goal |
|-----|---------|--------------|------|
| 1 | Email | Valuable content/guide | Provide value |
| 4 | LinkedIn | Connection with note | Build relationship |
| 10 | Email | Case study | Show proof |
| 15 | LinkedIn DM | Soft ask for call | Low-pressure CTA |
| 21 | Email | Webinar invite | Group setting |

**Response expected**: 15-25% by touch 5

### C-Tier: 3-Touch Nurture Sequence (30 days)

| Day | Channel | Message Type | Goal |
|-----|---------|--------------|------|
| 1 | Email | Educational content | Build awareness |
| 15 | LinkedIn | Engage with their content | Stay visible |
| 30 | Email | Quarterly check-in | Re-engage |

**Response expected**: 5-10%

**Then**: Move to passive nurture (monthly newsletter, LinkedIn engagement)

---

## Email Best Practices

### Subject Line Principles

**High-performing patterns**:
- Question format: "Struggling with [pain point]?"
- Curiosity: "How [Company] achieved [metric]"
- Congratulations: "Congrats on [achievement]"
- Direct value: "[Industry] benchmarking data"
- Personal: "Re: [Recent post/article]"

**Avoid**:
- ❌ All caps or excessive punctuation
- ❌ Obvious sales language ("Free trial", "Limited time")
- ❌ Vague or generic ("Quick question", "Following up")
- ❌ Company-centric ("Introducing [Product]")

### Email Body Structure

```
[Personalized opening - show research]
↓
[Identify pain point or opportunity]
↓
[Brief value prop - 10 words or less]
↓
[Social proof - specific metric from similar company]
↓
[Clear, single CTA]
↓
[Signature with credibility indicators]
```

**Length**: 50-100 words ideal, 150 max

### CTA Best Practices

**Strong CTAs**:
- ✅ "Worth a 15-minute call?"
- ✅ "Open to a brief conversation?"
- ✅ "Should I send over the case study?"
- ✅ "Want me to share how [Company] did it?"

**Weak CTAs**:
- ❌ "Let me know your thoughts"
- ❌ "Do you have time to chat?"
- ❌ "Would love to connect"
- ❌ Multiple CTAs in one email

### A/B Testing Framework

**Test these variables**:
1. Subject line (personal vs. value-driven)
2. Email length (short vs. medium)
3. CTA type (question vs. statement)
4. Social proof (metric vs. logo)
5. Personalization depth (minimal vs. extensive)

**Sample size**: Minimum 50 sends per variant

---

## LinkedIn Strategies

### Connection Request Messages

**Pattern**: Research + Commonality + Light Ask

**Template**:
```
Hi [First Name], saw you're leading [function] at [Company]. We work with a lot of [industry] companies on [topic]. Would value connecting to share insights from [Similar Company 1/2]. -[Your Name]
```

**Length**: 200 characters max (LinkedIn limit: 300)

**Acceptance rate**: 30-50% with personalization vs. 15-20% without

### LinkedIn DM After Connection

**Wait**: 2-3 days after acceptance

**Template**:
```
Thanks for connecting, [First Name]!

Quick question: is [pain point] something [Company] is actively working to solve?

We've helped [Similar Company] reduce [metric] by [%] using [approach]. Happy to share the playbook if relevant.

Either way, following your content on [topic] - good stuff.

-[Your Name]
```

### Content Engagement Strategy

**Engage with their content BEFORE outreach**:
1. Like their last 2-3 posts
2. Leave thoughtful comment on 1 post (not generic "Great post!")
3. Share their content with your audience (if valuable)

**Then**: Mention it in outreach
> "P.S. - Loved your recent post on [topic]. The point about [specific insight] really resonated."

**Result**: 2-3x higher response rates

### LinkedIn Video Messages

**When to use**: After 2-3 non-responses, for high-value accounts

**Structure** (30-45 seconds):
1. "Hi [Name], [Your Name] from [Company]"
2. "Noticed [personalized observation]"
3. "We help [similar companies] solve [pain point]"
4. "Worth a quick call? Click the link to book time"

**Tools**: LinkedIn Video Message feature, Loom, Vidyard

---

## Phone/Video Outreach

### When to Use Phone

**Good situations**:
- High-value accounts (>$50K ACV potential)
- After 2-3 email touches with no response
- Executive-level contacts (prefer phone)
- Following up on inbound interest
- Urgent, time-sensitive opportunity

**Avoid**:
- Cold calling C-level without research
- Calling after email opt-out
- During known busy times (Monday AM, Friday PM)

### Voicemail Script

**Structure** (20-30 seconds):
```
Hi [First Name], this is [Your Name] from [Company].

Quick call about [specific pain point/opportunity] - we recently helped [Similar Company] achieve [specific metric].

Thought it might be relevant for [Their Company].

Call me back at [number] or book time here: [calendar link].

Thanks!
```

**Key**: Leave value, not mystery

### Phone Conversation Structure

**Opening** (10 seconds):
> "Hi [Name], it's [Your Name] from [Company]. Did I catch you at a bad time?"

**Value statement** (15 seconds):
> "Quick call - we help [customer segment] solve [pain point]. Recently worked with [Similar Company] to achieve [metric]. Thought there might be some overlap with what you're doing at [Company]."

**Permission** (5 seconds):
> "Worth 3 minutes to see if there's a fit?"

**Discovery** (if yes):
- "Tell me about how you currently handle [process]"
- "What's working well? What's not?"
- "What would better look like?"

---

## Advanced Techniques

### The "Break-Up" Email

After 6-7 touches with no response, send this:

```
Subject: [Their Company] + [Your Company]

[First Name],

I've reached out a few times about [pain point] without hearing back.

I'm guessing it's either:
a) Not a priority right now
b) You're already solving it another way
c) I'm reaching the wrong person

If it's (c), would you mind pointing me to the right person?

If it's (a) or (b), totally understand - I'll stop bugging you. :)

Either way, following [Company]'s growth - excited to see where you go.

Best,
[Your Name]
```

**Response rate**: 10-30% (often get honest feedback)

### Trigger-Based Outreach

**Set up Google Alerts for**:
- Company name + "funding"
- Company name + "acquired"
- Company name + "launched"
- Key contact names

**React within 24 hours** of trigger event:

```
Subject: Congrats on [event]!

Saw the news about [event] - congrats!

This probably means [implication for their business].

We help companies at this stage solve [related pain point]. [Similar Company] used our platform during their own [similar event] and saw [metric].

Worth a conversation?
```

**Response rate**: 30-50% (timing + relevance)

### Video Personalization

**Use Loom/Vidyard for**:
- Executive-level outreach (VP+)
- High-value accounts ($100K+ potential)
- After multiple non-responses
- Complex value propositions

**Structure** (60-90 seconds):
1. Screencast their website/LinkedIn profile
2. Point out specific observations
3. Share screen of your product solving their pain
4. CTA to book time

**Response rate**: 20-40% vs. 5-10% for email

### Mutual Connection Leveraging

**When you have mutual LinkedIn connections**:

1. Ask for warm intro (best option)
2. Mention mutual connection in outreach (if appropriate)
3. Engage with mutual connection's content that includes your target

**Template with mutual connection**:
```
Hi [First Name],

Noticed we're both connected to [Mutual Connection]. I actually learned about [Their Company] through [their] mention of your work on [topic].

[Rest of personalized message]
```

**Response rate increase**: 2-3x

---

## Measuring Outreach Effectiveness

### Key Metrics by Channel

| Channel | Open Rate | Response Rate | Meeting Booked |
|---------|-----------|---------------|----------------|
| Email (cold) | 20-35% | 5-15% | 1-3% |
| Email (warm) | 40-60% | 20-40% | 5-10% |
| LinkedIn DM | N/A | 20-40% | 3-7% |
| Phone | N/A | 2-5% | 0.5-2% |
| Video | 30-50% | 15-30% | 3-8% |

### A/B Testing Recommendations

**Test frequency**: Every 50-100 sends

**Variables to test**:
1. Subject lines (personal vs. value)
2. Email length (50 vs. 100 words)
3. CTA style (question vs. calendar link)
4. Personalization depth (minimal vs. extensive)
5. Sending time (AM vs. PM)

**Track**:
- Open rates
- Response rates
- Meeting booking rates
- Show-up rates
- Pipeline generated

---

## Quick Reference: Messaging by Persona

### CEO/Founder

**Focus**: Business outcomes, strategic value, ROI

**Angle**: "Help you grow faster / reduce risk / enter new markets"

**Example**:
> "Most CEOs at your stage struggle with [strategic challenge]. We help you solve it by [approach], so you can [business outcome]. [Similar Company CEO] used our platform to [achieve X], which helped them [strategic win]."

### CTO/VP Engineering

**Focus**: Technical credibility, scalability, developer experience

**Angle**: "Help your team ship faster / reduce incidents / improve reliability"

**Example**:
> "Engineering teams at [size] companies typically hit [technical bottleneck]. We solve it with [technical approach]. [Similar Company] reduced [metric] by [%], giving their team [X hours/week] back."

### VP Sales/Revenue

**Focus**: Revenue impact, sales productivity, win rates

**Angle**: "Help you close more deals / shorten sales cycles / increase ACV"

**Example**:
> "Sales teams in [vertical] struggle with [sales challenge]. We help reps [specific improvement], resulting in [metric improvement]. [Similar Company] increased win rates by [%] within [timeframe]."

### VP Marketing

**Focus**: Pipeline generation, conversion rates, attribution

**Angle**: "Help you generate more qualified pipeline / improve conversion / prove ROI"

**Example**:
> "Marketing teams at [stage] companies need to [goal]. We help you achieve it by [approach]. [Similar Company] increased MQLs by [%] and improved SQL conversion by [%]."

---

**For detailed ICP criteria and qualification methodology, see [REFERENCE.md](REFERENCE.md)**

**For skill usage and workflows, see [SKILL.md](SKILL.md)**
