---
name: leadership
description: Executive leadership expertise for decision-making, change management, crisis management, stakeholder management, team building, and organizational leadership. Use when leading teams, managing change, navigating crises, or developing leadership skills.
---

# Leadership Expert

Comprehensive leadership frameworks for decision-making, change management, and organizational effectiveness.

## Executive Decision-Making

### Decision-Making Frameworks

```
OODA LOOP (Fast Decisions):
Observe → Orient → Decide → Act

DECIDE FRAMEWORK (Complex Decisions):
D - Define the problem
E - Establish criteria
C - Consider alternatives
I - Identify best alternative
D - Develop action plan
E - Evaluate and monitor

WRAP FRAMEWORK (Avoiding Bias):
W - Widen your options
R - Reality-test assumptions
A - Attain distance before deciding
P - Prepare to be wrong
```

### Decision Quality Checklist

| Factor           | Questions to Ask                   |
| ---------------- | ---------------------------------- |
| **Frame**        | Are we solving the right problem?  |
| **Alternatives** | Have we considered enough options? |
| **Information**  | Do we have reliable data?          |
| **Values**       | Are we clear on what matters?      |
| **Reasoning**    | Is our logic sound?                |
| **Commitment**   | Will people execute?               |

### Delegation Matrix

| Importance | Urgency | Decision By            |
| ---------- | ------- | ---------------------- |
| High       | High    | Executive (fast)       |
| High       | Low     | Executive (thoughtful) |
| Low        | High    | Delegate with check-in |
| Low        | Low     | Delegate fully         |

## Change Management

### Kotter's 8-Step Model

```
1. Create Urgency - Compelling reasons, threats/opportunities
2. Build Guiding Coalition - Influential cross-functional team
3. Form Strategic Vision - Clear future state and strategy
4. Communicate Vision - Repeat across channels, model behaviors
5. Enable Action - Remove barriers, encourage risk-taking
6. Generate Short-term Wins - Plan victories, build momentum
7. Sustain Acceleration - Hire change agents, new projects
8. Institute Change - Anchor in culture, ensure continuity
```

### ADKAR Model (Individual Change)

| Element           | Definition          | Key Actions                      |
| ----------------- | ------------------- | -------------------------------- |
| **Awareness**     | Understanding why   | Communicate business drivers     |
| **Desire**        | Want to participate | Address WIIFM, reduce resistance |
| **Knowledge**     | How to change       | Training, education              |
| **Ability**       | Skills to execute   | Practice, coaching               |
| **Reinforcement** | Sustain the change  | Recognition, measurement         |

### Change Resistance Management

```
SOURCES OF RESISTANCE:
- Fear of unknown
- Loss of control
- Surprise / timing
- Concerns about competence
- Past change failures
- Threat to status
- Peer pressure
- Mistrust of leadership

RESPONSE STRATEGIES:
| Type | Approach |
|------|----------|
| Information deficit | Education, communication |
| Skill deficit | Training, coaching |
| Incentive deficit | Align rewards |
| Resource deficit | Provide support |
| Values conflict | Dialogue, involvement |
| Politics | Negotiation, coalition |
```

## Crisis Management

### Crisis Response Framework

```
PRE-CRISIS: Risk ID, crisis team, templates, exercises
RESPONSE (Hour 1-4): Activate team, assess, secure safety, communicate
RESPONSE (Hour 4-24): Detailed assessment, stakeholder/media comms
RESPONSE (Day 2-7): Root cause, remediation, ongoing comms
POST-CRISIS: After-action review, improvements, reputation repair
```

### Crisis Communication

```
COMMUNICATION PRINCIPLES:
- Acknowledge quickly
- Show empathy
- Take responsibility (where appropriate)
- Explain actions being taken
- Commit to updates
- Be honest about unknowns

STAKEHOLDER PRIORITIES:
1. Affected individuals (safety)
2. Employees
3. Regulators
4. Media
5. Investors
6. Customers
7. Partners
8. General public

MESSAGE FRAMEWORK:
1. What happened (facts known)
2. What we're doing (actions)
3. What it means for stakeholders
4. What to expect next
```

### Business Continuity Planning

| Element                      | Description                      |
| ---------------------------- | -------------------------------- |
| **Risk Assessment**          | Identify potential disruptions   |
| **Business Impact Analysis** | Critical processes, RTOs, RPOs   |
| **Recovery Strategies**      | Alternate facilities, IT, people |
| **Plan Development**         | Documented procedures            |
| **Testing & Exercises**      | Regular drills, tabletops        |
| **Maintenance**              | Annual updates, post-incident    |

## Stakeholder Management

### Stakeholder Analysis Matrix

```
STAKEHOLDER MAPPING:

         Power/Influence
         High            Low
Interest
High     MANAGE CLOSELY  KEEP INFORMED
         (Board, major   (Employees,
         investors)      community)

Low      KEEP SATISFIED  MONITOR
         (Regulators,    (Low priority
         lenders)        groups)
```

### Stakeholder Engagement Plan

| Stakeholder | Interest | Influence | Strategy         | Frequency |
| ----------- | -------- | --------- | ---------------- | --------- |
| Board       | High     | High      | Partner          | Monthly   |
| Investors   | High     | High      | Inform & consult | Quarterly |
| Employees   | High     | Medium    | Engage           | Weekly    |
| Customers   | High     | Medium    | Listen & respond | Ongoing   |
| Regulators  | Medium   | High      | Comply & inform  | As needed |
| Media       | Variable | High      | Proactive comms  | As needed |

### Influence Without Authority

```
RECIPROCITY: Give first - help others, share resources, build credit
SOCIAL PROOF: Reference peers/competitors, share success stories
AUTHORITY: Demonstrate competence, use data and evidence
LIKING: Find common ground, show genuine interest
SCARCITY: Create urgency with limited opportunity/time
COMMITMENT: Start small, get incremental yes, build agreements
```

## Board Relations

### Board Communication Best Practices

```
BOARD MEETING PREPARATION:
- Pre-read materials 1 week ahead
- Executive summary on page 1
- Clear recommendation/ask
- Supporting data in appendix
- Anticipate questions

BOARD PRESENTATION STRUCTURE:
1. Context (2 min)
2. Key issue/opportunity (3 min)
3. Options considered (5 min)
4. Recommendation (3 min)
5. Discussion (remaining time)

BOARD REPORTING CADENCE:
| Topic | Frequency |
|-------|-----------|
| Financial results | Monthly/Quarterly |
| Strategic initiatives | Quarterly |
| Risk dashboard | Quarterly |
| Talent/succession | Semi-annually |
| Strategy refresh | Annually |
| Competitive landscape | Annually |
```

### Governance Best Practices

| Practice                   | Description                     |
| -------------------------- | ------------------------------- |
| **Independent Chair**      | Separate from CEO for oversight |
| **Executive Sessions**     | Independent director meetings   |
| **Board Evaluation**       | Annual self-assessment          |
| **Succession Planning**    | CEO and board renewal           |
| **Risk Oversight**         | Dedicated committee or process  |
| **Shareholder Engagement** | Investor dialogue program       |

## Executive Communication

### Communication Principles

```
EXECUTIVE PRESENCE:
- Clarity: Simple, direct messages
- Confidence: Conviction without arrogance
- Credibility: Expertise and authenticity
- Connection: Empathy and engagement
- Composure: Calm under pressure

MESSAGE DEVELOPMENT:
What? → So what? → Now what?
(Facts)  (Impact)  (Action)
```

### Town Hall / All-Hands Framework

```
STRUCTURE:
1. Opening (5 min)
   - Connect personally
   - Set context and agenda

2. Business Update (15 min)
   - Performance highlights
   - Key wins and learnings
   - Challenges and plans

3. Strategic Focus (10 min)
   - Priority initiatives
   - Progress and next steps
   - Resource allocation

4. Recognition (5 min)
   - Celebrate successes
   - Acknowledge teams

5. Q&A (20 min)
   - Prepared questions
   - Open forum
   - Honest responses

6. Close (5 min)
   - Summarize key points
   - Call to action
   - Express appreciation
```

### Difficult Conversations Framework

```
PREPARE:
- Clarify your objective
- Gather facts
- Anticipate reactions
- Plan key messages

CONDUCT:
1. State purpose directly
2. Share facts, not judgments
3. Listen for understanding
4. Acknowledge emotions
5. Explore solutions together
6. Agree on next steps

FOLLOW UP:
- Document agreements
- Monitor progress
- Provide support
- Address issues promptly
```

## Leadership Development

### Leadership Competency Model

| Competency             | Behaviors                               |
| ---------------------- | --------------------------------------- |
| **Vision**             | Sets direction, inspires others         |
| **Strategic Thinking** | Systems perspective, anticipates trends |
| **Driving Results**    | Accountability, execution focus         |
| **Leading People**     | Develops talent, builds teams           |
| **Collaboration**      | Influence, partnerships                 |
| **Innovation**         | Curiosity, courage to experiment        |
| **Integrity**          | Ethics, transparency, trust             |
| **Resilience**         | Adaptability, learning from setbacks    |

### 70-20-10 Development Model

| Source            | % of Development | Examples                                     |
| ----------------- | ---------------- | -------------------------------------------- |
| **Experience**    | 70%              | Stretch assignments, job rotations, projects |
| **Relationships** | 20%              | Mentoring, coaching, feedback, networking    |
| **Education**     | 10%              | Training, courses, reading, conferences      |

### Executive Coaching Approach

```
GROW MODEL:
Goal - Specific objective, timeline, success criteria
Reality - Current situation, obstacles, resources
Options - Brainstorm possibilities, evaluate pros/cons
Will - Action steps, accountability, commitment
```

## Organizational Culture Shaping

### Culture Change Levers

| Lever                             | Impact      |
| --------------------------------- | ----------- |
| **What leaders pay attention to** | Highest     |
| **How leaders react to crises**   | High        |
| **How resources are allocated**   | High        |
| **Role modeling and teaching**    | Medium-High |
| **Who gets rewarded/promoted**    | High        |
| **Who gets hired/fired**          | High        |
| **Organizational design**         | Medium      |
| **Systems and processes**         | Medium      |
| **Physical space**                | Low-Medium  |
| **Stories and symbols**           | Medium      |

### Values Activation

```
1. DEFINE - Specific language, observable behaviors
2. COMMUNICATE - Stories, visual reinforcement, leader modeling
3. INTEGRATE - Hiring, performance, recognition, decisions
4. HOLD ACCOUNTABLE - Consequences for violations, celebrate exemplars
```

## See Also

- [Fortune 50 HR/Talent](../fortune50-hr-talent/SKILL.md)
- [Fortune 50 Business Strategy](../fortune50-business-strategy/SKILL.md)
- [Fortune 50 Risk Management](../fortune50-risk-management/SKILL.md)
