# MVP Types: The Complete Guide

A comprehensive guide to different types of Minimum Viable Products, when to use each one, and how to build them.

## What Makes a Good MVP?

**Three Requirements:**
1. **Minimum:** Smallest possible to test hypothesis
2. **Viable:** Actually delivers core value to customers
3. **Product:** Customers can interact with it (even if manual)

**Remember:** The goal of an MVP is **learning**, not launching a product.

---

## Type 1: Customer Interview MVP

**What it is:** Have conversations with potential customers before building anything.

**Cost:** Free (just your time)
**Time to build:** 0 hours
**Time to learn:** 1-2 weeks

### When to Use:
- Very beginning - before building anything
- Testing problem hypotheses
- Understanding customer needs
- Validating market exists

### How to Build:
1. Identify 20-50 people in target customer segment
2. Reach out and request 30-minute conversations
3. Ask about their problems, not your solution
4. Document responses systematically
5. Look for patterns

### What to Measure:
- Do 80%+ mention the same problem?
- How severe is the pain? (1-10 scale)
- What are they using today?
- Would they pay to solve this problem?

### Example:
**Hypothesis:** Freelancers struggle with invoicing clients

**Customer Interview MVP:**
- Talk to 30 freelancers
- Ask: "What's the hardest part about getting paid?"
- Ask: "How do you currently invoice clients?"
- Ask: "What would make invoicing easier?"

**Learn:** Do they actually have this problem? Is it painful enough to pay for?

### Pros:
- Zero cost
- Fastest way to validate problem
- Deep qualitative insights
- Builds early customer relationships

### Cons:
- Doesn't test if solution works
- What people say ≠ what they do
- Can't validate willingness to pay

---

## Type 2: Landing Page MVP

**What it is:** Single webpage describing your product with call-to-action (email signup, pre-order, etc.)

**Cost:** $0-500 (page builder + ads)
**Time to build:** 1-2 days
**Time to learn:** 1 week

### When to Use:
- Testing demand before building
- Validating value proposition resonates
- Building email list of interested users
- Testing different positioning/messaging

### How to Build:

**Minimum Version:**
1. Single page with:
   - Clear headline (the problem you solve)
   - 3-5 key benefits
   - Call-to-action (email signup)
   - Social proof (if available)
2. Set up email collection (MailChimp, ConvertKit)
3. Drive traffic (ads, social media, communities)

**Tools:**
- Carrd, Webflow, or even Google Doc
- MailChimp for email collection
- Google Analytics for tracking

### What to Measure:
- Conversion rate (visitor → email signup)
- Traffic sources that convert best
- Time on page
- Exit points
- Which messaging resonates (A/B test)

**Benchmarks:**
- <1% conversion: Weak value prop or wrong audience
- 1-5% conversion: Decent interest
- 5-15% conversion: Strong interest
- >15% conversion: Very strong interest

### Example:

**Dropbox Landing Page MVP (2007):**
- Simple page with video demo
- Email signup for early access
- No actual product yet
- 75,000 signups in one day
- Validated demand before building

**Your Version:**
- Headline: "Get paid faster with one-click invoicing"
- Subhead: "Freelancers: Stop chasing late payments"
- 3 benefits: Fast invoicing, automated reminders, easy tracking
- CTA: "Join the waitlist"
- Drive 1,000 visitors via ads
- 5% signup rate = 50 interested people

### Pros:
- Very cheap and fast
- Tests demand signal
- Builds email list
- Easy to A/B test messaging

### Cons:
- Doesn't test actual product usage
- Email signups ≠ paying customers
- Can't validate retention

---

## Type 3: Explainer Video MVP

**What it is:** Video demonstrating your product (even if it doesn't exist yet)

**Cost:** $0-1,000
**Time to build:** 1-3 days
**Time to learn:** 1 week

### When to Use:
- Product is too complex to explain with text
- You need to show how it works without building it
- Testing if concept resonates
- Building viral interest

### How to Build:

**Simple Version:**
1. Write script explaining the problem and solution
2. Create mockup screenshots or animations
3. Record screen + voiceover (Loom, ScreenFlow)
4. Post on landing page + social media
5. Track views and signups

**Dropbox Example:**
- 3-minute video showing how it would work
- Simple screen recordings with narration
- Demonstrated value without building product
- Video went viral, 75,000 signups

### What to Measure:
- Video completion rate
- Signups after watching
- Social shares
- Comments/feedback

### Example:

**B2B SaaS Tool:**
1. Create Figma mockups of interface
2. Record 2-minute walkthrough with Loom
3. Script: "Here's the problem... Here's how it works... Here's the result"
4. Post on LinkedIn + landing page
5. Measure: views, completion rate, demo requests

### Pros:
- Shows product without building it
- Can go viral
- Great for complex products
- Builds excitement

### Cons:
- Doesn't test actual usage
- Production quality matters more
- Can over-promise if not careful

---

## Type 4: Concierge MVP

**What it is:** Manually deliver your service to customers while you learn what to build.

**Cost:** Your time (lots of it)
**Time to build:** 0 hours
**Time to learn:** 2-4 weeks

### When to Use:
- Complex service with many variables
- You need to understand customer workflow deeply
- Before building automation
- Testing willingness to pay

### How to Build:
1. Find 5-10 customers willing to pay
2. Deliver service 100% manually
3. Use spreadsheets, email, manual processes
4. Document every step you take
5. Note what could be automated vs must be human

### What to Measure:
- Are customers willing to pay?
- What tasks take most time?
- Which steps add most value?
- What should be automated first?
- Do customers come back?

### Example:

**Food on the Table (Meal Planning Service):**
- Founder manually created meal plans for each customer
- Visited customers' homes to understand their needs
- Went to grocery stores to check prices
- Created custom weekly plans by hand
- Charged $10/month
- Did this for months before building software
- Learned exactly what to automate

**Your Version - AI Content Tool:**
1. Find 10 businesses willing to pay $500/month
2. Manually write content for them (no AI yet)
3. Learn: What types of content? What quality? How much revision?
4. Document your workflow
5. After 10 customers, you know exactly what to build

### Pros:
- Deepest customer understanding
- Tests willingness to pay immediately
- No development needed
- Revenue from day 1

### Cons:
- Doesn't scale (that's the point)
- Very time-intensive
- Can only serve a few customers
- May burn you out

---

## Type 5: Wizard of Oz MVP

**What it is:** Customers think they're using an automated product, but you're doing everything manually behind the scenes.

**Cost:** 1-2 weeks development for facade
**Time to learn:** 2-4 weeks

### When to Use:
- Testing if customers value the output (not how it's made)
- Before building expensive automation/AI
- Validating the experience and value prop
- Testing willingness to pay at scale

### How to Build:
1. Build simple frontend (form/interface)
2. Customers submit requests via form
3. You receive requests via email/Slack
4. You manually create/deliver results
5. Auto-send results to customer (looks automated)
6. Customer has no idea it's manual

### What to Measure:
- Do customers use it?
- Do they come back?
- Will they pay?
- What results do they want?
- How fast do results need to be?

### Example:

**Zappos (Shoes):**
- Posted shoe photos on website
- When someone ordered, Nick Swinmurn went to retail stores
- Bought shoes at retail price
- Shipped to customer
- Lost money on every sale
- Proved people would buy shoes online
- Only then built inventory and logistics

**Your Version - Logo Design Service:**
1. Build simple form: "Get a logo in 24 hours - $99"
2. Customer submits brief
3. You manually design logos (or hire designer)
4. Auto-email results (looks automated)
5. Learn: Do they pay? Do they request revisions? What styles work?

### Pros:
- Tests full experience
- Validates willingness to pay
- Looks real to customers
- Learn before building automation

### Cons:
- Requires some development
- Can't scale (will exhaust you)
- Must deliver on promises
- Ethical if you're honest about process

---

## Type 6: Piecemeal MVP

**What it is:** Stitch together existing tools/services to deliver value without building anything custom.

**Cost:** $0-500/month for tools
**Time to build:** 1-5 days
**Time to learn:** 2-4 weeks

### When to Use:
- Validating business model before building technology
- Testing if value prop resonates
- When existing tools can deliver 80% of value
- Bootstrap startups with no funding

### How to Build:
1. Map your workflow
2. Find existing tools for each step
3. Connect them with Zapier/integrations
4. Use manual steps where needed
5. Deliver value to customers

### What to Measure:
- Does the business model work?
- Will customers pay?
- What's the bottleneck?
- What must be custom vs can stay third-party?

### Example:

**Groupon V1:**
- WordPress blog for posting deals
- AppleScript to generate PDFs
- Apple Mail to send to subscribers
- Manual deal curation
- No custom software
- Validated model before building platform

**Your Version - Freelancer Marketplace:**
- Google Form for freelancer signups
- Airtable database of freelancers
- Webflow site displaying profiles
- Calendly for client meeting booking
- Stripe payment links for transactions
- Manual matching and quality control

**Tools Stack:**
- Frontend: Webflow, Carrd, WordPress
- Forms: Typeform, Google Forms
- Database: Airtable, Google Sheets
- Payments: Stripe, PayPal
- Email: MailChimp, ConvertKit
- Automation: Zapier, Make
- Scheduling: Calendly

### Pros:
- Very fast to build
- Cheap (just tool costs)
- Validates business model
- Can serve real customers

### Cons:
- Doesn't scale long-term
- Tool costs add up
- Clunky user experience
- Limited by tool capabilities

---

## Type 7: Single-Feature MVP

**What it is:** Build only ONE core feature. Nothing else.

**Cost:** 1-4 weeks development
**Time to learn:** 2-4 weeks

### When to Use:
- After validating problem with cheaper MVPs
- Testing if your solution actually works
- Validating retention and engagement
- Before building full product

### How to Build:
1. Identify THE core feature that delivers value
2. Remove every other feature
3. Build only that one feature
4. Make it work well (not perfect)
5. Get it to 10-50 users
6. Measure if they use it repeatedly

### What to Measure:
- Activation rate (% who complete first use)
- Retention (day 1, 7, 30)
- Engagement (frequency of use)
- Willingness to pay
- Feature requests (what's missing)

### Example:

**Twitter V1:**
- ONLY feature: Post 140-character status update
- No photos, no videos, no hashtags, no @mentions
- Just text status updates
- That's it
- Validated core value: "What are you doing right now?"
- Added features later based on usage

**Instagram V1:**
- ONLY feature: Apply filter to photo and share
- No stories, no reels, no DMs, no explore
- Just filter + share
- Validated core value: Make photos look good easily

**Your Version - Task Management:**
- ONLY feature: Create tasks and mark them done
- No projects, no tags, no assignments, no due dates
- Just tasks and checkboxes
- Test: Do people use it daily?

### Pros:
- Forces focus on core value
- Faster to build than full product
- Easier to measure what matters
- Less code to maintain

### Cons:
- Requires actual development
- Users will request features
- May feel too limited
- Competitive products have more features

---

## Type 8: Smoke Test MVP

**What it is:** Pretend to sell something that doesn't exist yet to gauge interest.

**Cost:** $0-500
**Time to build:** 1-2 days
**Time to learn:** 1 week

### When to Use:
- Testing willingness to pay before building
- Validating pricing
- Testing market demand
- When stakes are high (expensive to build)

### How to Build:
1. Create landing page with "Buy Now" button
2. When clicked, show "Coming soon! Join waitlist"
3. Or: Accept pre-orders with refund policy
4. Drive traffic
5. Measure click-through rate to purchase

### What to Measure:
- Click-through rate to buy button
- Abandoned cart rate
- Pre-order conversion rate
- Price sensitivity (test different prices)

### Example:

**Dropbox:**
- "Buy Now" button before product existed
- Measured click-through rate
- Validated pricing
- Built waitlist

**Your Version - Premium Course:**
- Create sales page for $497 course
- Full description, curriculum, testimonials (from beta)
- "Enroll now" button
- When clicked: "Next cohort starts March 1. Join waitlist?"
- Test: Do people try to buy?

### Ethical Considerations:
- Be transparent (show "coming soon")
- Or offer refunds immediately
- Don't charge without delivering
- Build trust, don't break it

### Pros:
- Tests willingness to pay
- Validates pricing
- Builds waitlist
- Cheapest way to test demand

### Cons:
- Ethically gray if not transparent
- Doesn't test product quality
- May frustrate potential customers
- Can't measure retention

---

## Type 9: Pre-Order MVP

**What it is:** Sell your product before building it (with clear delivery timeline).

**Cost:** Landing page + payment processing
**Time to build:** 2-3 days
**Time to learn:** 2-4 weeks

### When to Use:
- Funding initial development
- Validating demand and pricing
- Getting customer commitment
- Building with customers (not for them)

### How to Build:
1. Create detailed product description
2. Set clear delivery timeline (be realistic)
3. Offer early-bird discount
4. Accept pre-orders via Stripe/Gumroad
5. Build product based on pre-orders

### What to Measure:
- Pre-order conversion rate
- Total revenue vs. development cost
- Customer feedback during development
- Retention after delivery

### Example:

**Pebble Watch:**
- Kickstarter campaign before building
- $10M in pre-orders
- Validated demand at scale
- Used funding to build product
- Involved customers in development

**Your Version - SaaS Product:**
- "Launch special: $49/year (regular $99)"
- "Product launches June 1"
- Accept pre-orders
- Build based on commitments
- Deliver to pre-order customers first

### Pros:
- Validates willingness to pay
- Funds development
- Creates accountability
- Builds initial user base

### Cons:
- Must deliver on promises
- Pressure to ship on time
- Can't pivot easily
- Reputation risk if you fail

---

## Type 10: Prototype MVP

**What it is:** Non-functional mockup or prototype that looks real but doesn't work.

**Cost:** 2-5 days design work
**Time to learn:** 1-2 weeks

### When to Use:
- Testing user experience before coding
- Validating interface design
- Getting feedback on workflow
- Pitching to investors/partners

### How to Build:
1. Design mockups in Figma/Sketch
2. Create clickable prototype (InVision, Figma)
3. Show to target users
4. Watch them try to use it
5. Document confusion and delight

### What to Measure:
- Can users complete key tasks?
- Where do they get confused?
- What do they try to click that doesn't exist?
- Do they understand the value prop?

### Example:

**Mobile App Prototype:**
1. Design 5-10 key screens in Figma
2. Link screens to simulate flow
3. Give to 10 users: "Try to [complete task]"
4. Watch them (don't help)
5. Note: Where do they get stuck?

### Pros:
- Fast to create
- Easy to iterate
- Gets visual feedback
- Cheaper than building

### Cons:
- Doesn't test if it actually works
- Doesn't validate willingness to pay
- Can over-design before validating
- Feedback may not match real usage

---

## Choosing the Right MVP Type

### Decision Framework:

**Question 1: Have you validated the problem exists?**
- No → Start with Customer Interviews
- Yes → Continue to Q2

**Question 2: Have you validated demand?**
- No → Landing Page or Smoke Test
- Yes → Continue to Q3

**Question 3: Can you deliver service manually?**
- Yes → Concierge or Wizard of Oz MVP
- No → Continue to Q4

**Question 4: Can you use existing tools?**
- Yes → Piecemeal MVP
- No → Single-Feature MVP

### By Stage:

**Idea Stage:**
- Customer Interviews
- Landing Page

**Problem Validated:**
- Explainer Video
- Smoke Test
- Pre-Order

**Solution Testing:**
- Concierge
- Wizard of Oz
- Piecemeal

**Building Product:**
- Single-Feature MVP
- Prototype

---

## MVP Anti-Patterns (What to Avoid)

### Anti-Pattern 1: The "MVP" with 20 Features
Not an MVP. That's a V1 product.

### Anti-Pattern 2: The Perfect MVP
If you're not embarrassed, you waited too late.

### Anti-Pattern 3: The Fake MVP
Building something you think customers want without validating.

### Anti-Pattern 4: The Stealth MVP
Building in secret, not showing anyone.

### Anti-Pattern 5: The Pivot-Before-Launch MVP
Changing direction before getting customer feedback.

### Anti-Pattern 6: The Opinion MVP
Testing with friends/family who won't give honest feedback.

---

## MVP Success Checklist

Before launching your MVP:

- [ ] Hypothesis clearly stated
- [ ] Success metrics defined
- [ ] Chosen cheapest MVP type that tests hypothesis
- [ ] Timeline is 1-2 weeks max
- [ ] Will reach real target customers (not friends/family)
- [ ] Analytics/tracking set up
- [ ] Decided when to evaluate results
- [ ] Defined pivot vs persevere criteria
- [ ] Removed every non-essential feature
- [ ] Am slightly embarrassed by how simple it is

If you checked all boxes, ship it!

---

## Summary

**The MVP Ladder (Cheapest → Most Expensive):**

1. Customer Interviews (Free)
2. Landing Page ($0-500)
3. Explainer Video ($0-1,000)
4. Smoke Test ($0-500)
5. Concierge (Your time)
6. Wizard of Oz (1-2 weeks dev)
7. Piecemeal (Tool costs)
8. Pre-Order (Page + payment)
9. Prototype (Design time)
10. Single-Feature (1-4 weeks dev)

**Always start at the cheapest level that can answer your question.**

**Remember:** The goal is learning, not launching. Build the minimum necessary to test your hypothesis, nothing more.