---
name: lean-startup
description: Provides startup advice using Eric Ries' Lean Startup methodology focusing on Build-Measure-Learn cycles, validated learning, and rapid experimentation. Use when advising on MVPs, product iterations, pivot decisions, growth metrics, or when user mentions Lean Startup, Eric Ries, validated learning, or rapid experimentation.
---

# Lean Startup Method

This skill provides startup advice based on Eric Ries' Lean Startup methodology, emphasizing rapid experimentation, validated learning, and iterative product development.

## Core Philosophy

**"The only way to win is to learn faster than anyone else."** - Eric Ries

The Lean Startup is a scientific approach to creating and managing startups that gets desired products into customers' hands faster. It's about testing your vision continuously, adapting and adjusting before it's too late.

## The Build-Measure-Learn Loop

The fundamental activity of a startup is to turn **ideas** into **products**, measure how customers respond, and then learn whether to **pivot or persevere**. All successful startup processes should be geared to accelerate this feedback loop.

```
   IDEAS
     ↓
   BUILD → PRODUCT
     ↓
  MEASURE → DATA
     ↓
   LEARN → IDEAS (repeat)
```

### How the Loop Works:

1. **IDEAS (Learn):** Start with hypotheses about your business
2. **BUILD:** Create minimum viable product (MVP) to test hypotheses
3. **MEASURE:** Collect data on how customers actually behave
4. **LEARN:** Validate or invalidate your hypotheses
5. **Decide:** Pivot (change course) or Persevere (stay the course)
6. **Repeat:** Continue the cycle faster and faster

**The Goal:** Minimize total time through the loop (cycle time).

## Five Principles of Lean Startup

### 1. Entrepreneurs Are Everywhere
You don't need a garage or venture capital to be a startup. A startup is a human institution designed to create new products/services under conditions of extreme uncertainty.

### 2. Entrepreneurship Is Management
A startup is an institution, not just a product. It requires management specifically geared to its context of extreme uncertainty.

### 3. Validated Learning
Startups exist to learn how to build a sustainable business. This learning can be validated scientifically by running frequent experiments.

### 4. Build-Measure-Learn
The fundamental activity is turning ideas into products, measuring customer response, and learning whether to pivot or persevere. Minimize total time through the loop.

### 5. Innovation Accounting
Hold innovators accountable by focusing on the boring stuff: how to measure progress, set milestones, and prioritize work. This requires new accounting designed for startups.

## Validated Learning

**Validated learning** is the process of demonstrating empirically that your team has discovered valuable truths about the startup's present and future business prospects.

### Not Validated Learning:
- "We shipped features on time"
- "We executed our plan perfectly"
- "We built what we said we'd build"
- "Customers said they liked it"

### Validated Learning:
- "We proved customers will pay for feature X"
- "We discovered customers don't care about feature Y"
- "We learned customer segment A converts 5x better than B"
- "We validated our pricing hypothesis"

### How to Validate:
1. **State a hypothesis:** "If we add feature X, conversion will increase 10%"
2. **Design an experiment:** A/B test with and without feature X
3. **Define success metrics:** Measure actual conversion rate
4. **Run the experiment:** Collect real data
5. **Learn:** Did the hypothesis prove true? Why or why not?
6. **Decide:** Build more, pivot, or kill the feature

**Key Question:** What did you learn that you couldn't have learned more cheaply/quickly?

## Minimum Viable Product (MVP)

The MVP is the version of a new product which allows a team to collect the maximum amount of validated learning about customers with the least effort.

### What an MVP Is:
- **Minimum:** Smallest thing you can build to test a hypothesis
- **Viable:** Enough to get meaningful learning
- **Product:** Something customers can interact with

### What an MVP Is NOT:
- A beta version with fewer features
- A prototype that doesn't reach real customers
- An excuse for poor quality
- A half-baked product

### Types of MVPs:

#### 1. Concierge MVP
Manually deliver your service to customers while you learn what to build.

**Example:** Food on the Table started with founder manually creating meal plans for individual customers before building software.

**When to use:** Complex service where you need to understand customer workflow deeply.

#### 2. Wizard of Oz MVP
Customers think they're using a fully automated product, but you're doing the work manually behind the scenes.

**Example:** Zappos started by posting shoe photos online, then buying from retail stores when orders came in.

**When to use:** You need to validate demand before building expensive automation.

#### 3. Landing Page MVP
Single page describing your product with email signup or pre-order button.

**Example:** Dropbox famous video demo that led to 75,000 signups overnight.

**When to use:** Testing initial interest before building anything.

#### 4. Single-Feature MVP
Build only the core feature that delivers the primary value proposition.

**Example:** Twitter started as just status updates, nothing else.

**When to use:** You have multiple feature ideas but need to validate core value first.

#### 5. Piecemeal MVP
Stitch together existing tools/services to deliver your value prop without building custom software.

**Example:** Groupon started using WordPress + AppleScript + email.

**When to use:** You want to validate the business model before investing in technology.

### MVP Development Process:

1. **Identify riskiest assumption** (usually: will customers want this?)
2. **Design minimum experiment** to test that assumption
3. **Define success criteria** before building
4. **Build only what's needed** to run the experiment
5. **Get it in front of real customers** ASAP
6. **Measure actual behavior** (not opinions)
7. **Learn and iterate** or pivot

**Remember:** If you're not embarrassed by your first version, you launched too late.

## Innovation Accounting

Traditional accounting doesn't work for startups because:
- Revenue is often zero or too low to be meaningful
- Traditional metrics measure execution, not learning
- They don't help you make pivot/persevere decisions

### The Three Steps of Innovation Accounting:

#### Step 1: Establish the Baseline
Use an MVP to collect real data on where you are today.

**Metrics to establish:**
- Current conversion rates
- Customer acquisition cost (CAC)
- Activation rate
- Retention rate
- Referral rate
- Revenue per customer

#### Step 2: Tune the Engine
Make small improvements and see if metrics move in the right direction.

**What to measure:**
- Did the change improve the metric?
- By how much?
- Was it statistically significant?
- What did we learn?

#### Step 3: Pivot or Persevere
If you can't improve metrics enough to achieve business goals, it's time to pivot.

**Decision criteria:**
- Are we making sufficient progress?
- Is the rate of improvement fast enough?
- Can we reach our goals with current trajectory?

## Actionable Metrics vs. Vanity Metrics

### Vanity Metrics (Avoid):
- **Total registered users:** Doesn't show if they're active or paying
- **Total page views:** Doesn't indicate engagement quality
- **Number of downloads:** Doesn't show retention
- **Social media followers:** Doesn't correlate to business value

**Why they're dangerous:** They make you feel good but don't help you make decisions.

### Actionable Metrics (Use):
- **Active users (DAU/MAU):** Who's actually using the product?
- **Cohort retention:** Do users come back over time?
- **Customer lifetime value (LTV):** How much is a customer worth?
- **Customer acquisition cost (CAC):** What does it cost to acquire a customer?
- **Viral coefficient:** How many new users does each user bring?
- **Revenue growth rate:** How fast are you growing?

**Why they're useful:** They help you make concrete decisions and understand cause-and-effect.

### Making Metrics Actionable:

**Bad:** "Traffic increased 20% this month"
- Why did it increase?
- Which traffic sources?
- Did those visitors convert?
- Can we repeat this?

**Good:** "Changed headline on landing page, which increased conversion from 2% to 3.5% (statistically significant, p<0.05), resulting in 50% more trial signups"
- Clear cause and effect
- Measurable result
- Repeatable action

## The Pivot

A **pivot** is a structured course correction designed to test a new fundamental hypothesis about the product, strategy, or engine of growth.

### When to Pivot:

**Signs it's time:**
- Decreasing effectiveness of product experiments
- Metrics aren't improving despite multiple iterations
- Customer feedback consistently points in different direction
- You're running out of ideas to test current hypothesis
- The market or technology has fundamentally shifted

**Don't pivot if:**
- You haven't given current approach enough time/iterations
- You're pivoting based on gut feeling vs. data
- You're pivoting to avoid hard work
- One customer said they want something different

### Types of Pivots:

#### 1. Zoom-In Pivot
What was previously a single feature becomes the whole product.

**Example:** Flickr started as a multiplayer game; photo-sharing feature became the product.

#### 2. Zoom-Out Pivot
What was the whole product becomes a single feature of a larger product.

**Example:** YouTube started as a dating site with video profiles.

#### 3. Customer Segment Pivot
Product solves a real problem but for a different customer than originally anticipated.

**Example:** Groupon pivoted from activism platform to local deals.

#### 4. Customer Need Pivot
Target customer has a different problem than you originally anticipated.

**Example:** Potbelly Sandwich started as an antique store that sold sandwiches; realized customers wanted sandwiches, not antiques.

#### 5. Platform Pivot
Change from application to platform or vice versa.

**Example:** Shopify started as online store for snowboards, became e-commerce platform.

#### 6. Business Architecture Pivot
Switch between high margin/low volume (complex sales) and low margin/high volume (volume operations).

**Example:** Moving from enterprise B2B to self-service B2C.

#### 7. Value Capture Pivot
Change how you monetize or capture value.

**Example:** Switching from freemium to paid-only, or advertising to subscription.

#### 8. Engine of Growth Pivot
Change growth strategy between viral, sticky, or paid growth engines.

**Example:** Moving from paid acquisition to viral growth mechanics.

#### 9. Channel Pivot
Change the mechanism by which you deliver your product to customers.

**Example:** Moving from enterprise sales team to self-service online.

#### 10. Technology Pivot
Achieve the same solution using completely different technology.

**Example:** Rewriting from scratch with new technology stack to improve performance.

### Pivot Process:

1. **Recognize:** Data shows current approach isn't working
2. **Analyze:** Review all validated learning to date
3. **Brainstorm:** Generate pivot hypotheses
4. **Choose:** Pick the most promising pivot based on data
5. **Plan:** Design MVP to test new hypothesis
6. **Execute:** Run through Build-Measure-Learn loop
7. **Evaluate:** Did the pivot improve metrics?

**Remember:** Pivots are normal and expected. Most successful startups pivot at least once.

## Three Engines of Growth

Every startup should focus on ONE engine of growth:

### 1. Sticky Engine of Growth
**Focus:** Retention - keep customers coming back

**Key Metrics:**
- Retention rate (% of customers who stay)
- Churn rate (% of customers who leave)
- Customer lifetime (how long average customer stays)

**Growth Rule:** Acquisition rate > Churn rate

**Examples:** SaaS products, subscription services, social networks

**Optimization:**
- Improve onboarding
- Add features that increase engagement
- Build habits
- Reduce churn

### 2. Viral Engine of Growth
**Focus:** Referral - customers bring new customers

**Key Metrics:**
- Viral coefficient (how many new customers does each customer bring?)
- Viral cycle time (how long for one cycle of referral?)

**Growth Rule:** Viral coefficient > 1.0

**Examples:** Social networks, communication tools, marketplaces

**Optimization:**
- Make sharing core to product experience
- Incentivize referrals
- Reduce friction in invite process
- Speed up viral cycle time

### 3. Paid Engine of Growth
**Focus:** Acquisition - pay to acquire customers

**Key Metrics:**
- Customer acquisition cost (CAC)
- Lifetime value (LTV)
- LTV:CAC ratio

**Growth Rule:** LTV > CAC (ideally LTV > 3x CAC)

**Examples:** Most B2B products, e-commerce

**Optimization:**
- Increase LTV (upsell, reduce churn, raise prices)
- Decrease CAC (improve conversion, optimize channels)
- Improve monetization

**Warning:** Don't try to optimize multiple engines simultaneously. Pick one and master it.

## The Five Whys

A technique for getting to the root cause of problems by asking "why?" five times.

### How to Use:

**Problem:** Website went down

1. **Why did website go down?** Server ran out of memory
2. **Why did it run out of memory?** Memory leak in new feature
3. **Why was there a memory leak?** Code wasn't properly tested
4. **Why wasn't it tested?** No automated tests for that component
5. **Why are there no automated tests?** Team doesn't have time to write tests

**Root cause:** Need to invest in testing infrastructure

**Solution:** Allocate time for building automated tests

### Rules for Five Whys:

1. **Be tolerant of all mistakes the first time**
2. **Never allow the same mistake twice**
3. **Start small** - use for small problems first
4. **Appoint a Five Whys master** to facilitate
5. **Everyone affected by problem must be in the room**
6. **Make proportional investments** - small problems = small fixes

## Lean Startup in Practice

### Week-by-Week Framework:

#### Week 1: Hypothesis Definition
- Write down your riskiest assumptions
- Prioritize which to test first
- Design minimum experiment
- Define success metrics

#### Week 2-3: Build MVP
- Build simplest version that tests hypothesis
- Remember: embarrassingly simple is perfect
- Focus on learning, not polish

#### Week 4: Measure
- Get MVP in front of real customers
- Collect actual usage data
- Track defined metrics
- Document customer feedback

#### Week 5: Learn
- Analyze results
- What did you validate?
- What did you invalidate?
- What surprises emerged?

#### Week 6: Pivot or Persevere Decision
- Are metrics improving?
- Did hypothesis prove true?
- If yes: Persevere and tune the engine
- If no: Pivot to new hypothesis

#### Repeat: Faster and faster cycles

## Common Lean Startup Mistakes

### Mistake 1: Building Too Much
**Problem:** Building full product before testing hypotheses.
**Fix:** Start with simplest possible MVP. If you're not embarrassed, you waited too late.

### Mistake 2: Analysis Paralysis
**Problem:** Spending months planning instead of testing.
**Fix:** Get out of the building. Real customer data beats planning.

### Mistake 3: Vanity Metrics
**Problem:** Measuring things that don't help make decisions.
**Fix:** Focus on actionable metrics that show cause and effect.

### Mistake 4: Ignoring the Data
**Problem:** Continuing with plan despite data showing it's not working.
**Fix:** Be honest about what data is telling you. Pivot when needed.

### Mistake 5: Pivoting Too Fast
**Problem:** Changing direction before giving approach enough iterations.
**Fix:** Give each hypothesis multiple experiments before pivoting.

### Mistake 6: Multiple Engines of Growth
**Problem:** Trying to optimize viral AND paid growth simultaneously.
**Fix:** Pick one engine and master it before moving to another.

### Mistake 7: No Clear Hypotheses
**Problem:** Building without clear assumptions to test.
**Fix:** Write explicit hypotheses before every experiment.

## Advice Framework

When providing Lean Startup advice:

### 1. Understand Current State
**Questions to ask:**
- What stage are you at?
- What have you built so far?
- What have you learned from customers?
- What are you measuring?
- What's your current Build-Measure-Learn cycle time?

### 2. Identify the Problem
**Common issues:**
- Building too much before testing
- Not measuring the right things
- Stuck in analysis paralysis
- Pivoting too fast or too slow
- Focusing on vanity metrics

### 3. Apply Lean Principles
**Guide them toward:**
- Smaller MVPs
- Faster cycles
- Actionable metrics
- Validated learning
- Pivot or persevere decisions

### 4. Provide Specific Actions
**Format:**
- **This week:** [specific MVP to build]
- **Measure:** [specific metrics to track]
- **Learn:** [what question will you answer?]
- **Next week:** [decision criteria for pivot/persevere]

### 5. Focus on Speed
**Emphasize:**
- Minimize time through Build-Measure-Learn loop
- Ship embarrassingly simple MVPs
- Learn faster than competition
- Don't optimize too early

## Example Advice Session

**Founder:** "We're building an AI tool for content creators. We've been developing for 6 months and plan to launch in 3 more months with all features ready."

**Lean Startup Response:**

**Assessment:**
You're in the "building too much before testing" trap. 9 months of building without customer validation is extremely risky.

**Key Questions:**
- Have you talked to 50+ content creators about their problems?
- Have any creators paid you or committed to pay?
- What's your riskiest assumption?
- Can you test that assumption this week instead of in 3 months?

**Recommended Actions:**

**This Week:**
1. **STOP building** new features
2. **Create simplest MVP:** One core feature only
3. **Get 10 content creators** to use it (even if manual/ugly)
4. **Measure:** Do they come back day 2? Day 7?

**Metrics to Track:**
- Signup to activation rate
- Day 1, 7, 30 retention
- Customer willingness to pay
- Core feature usage frequency

**Learn:**
- Do creators have the problem you're solving?
- Is your solution actually valuable to them?
- What's the minimum feature set they need?
- What will they pay?

**Decision Point (Week 2):**
- **If retention >40%:** Persevere - keep building this approach
- **If retention <20%:** Pivot - different problem or different customer
- **If willingness to pay low:** Pivot monetization or value prop

**Key Insight:**
You'll learn more in 2 weeks with a simple MVP than in 9 months of building in isolation. Speed up your learning loop.

## Resources

- **Book:** "The Lean Startup" by Eric Ries
- **Book:** "Running Lean" by Ash Maurya
- **Framework:** Lean Canvas (1-page business plan)
- **Blog:** startup-marketing.com
- **Principle:** Build-Measure-Learn
- **Mantra:** "Move fast and break things" → "Move fast and learn things"

## Key Takeaways

1. **Progress is learning**, not building features
2. **Speed is more important than perfection**
3. **Data beats opinions**
4. **Small batches** enable faster learning
5. **Actionable metrics** drive decisions
6. **Pivot is normal**, not failure
7. **MVP is about learning**, not launching
8. **Focus on one engine** of growth
9. **Validate before scaling**
10. **Minimize cycle time** through Build-Measure-Learn loop

---

*"The lesson of the MVP is that any additional work beyond what was required to start learning is waste, no matter how important it might have seemed at the time."* - Eric Ries