---
name: learner-communications
description: Creates learner-facing communications including enrollment emails, reminders, and announcements. Use when writing course emails, announcements, reminders, welcome messages, or when user mentions "learner email," "course announcement," "enrollment message," "reminder," or "completion notification."
---

# Learner Communications

Templates and guidelines for effective learner-facing communications.

## Communication Types

| Type | When to Send | Purpose |
|------|--------------|---------|
| Enrollment | Upon registration | Welcome, set expectations |
| Pre-course | 1-3 days before | Prepare, build anticipation |
| Reminder | Day of/before deadline | Prompt action |
| During course | As needed | Support, encourage |
| Completion | Upon finishing | Congratulate, next steps |
| Follow-up | 30-60 days after | Reinforce, measure transfer |

## Email Templates

### Enrollment Confirmation

```markdown
**Subject:** Welcome to [Course Name] - You're Enrolled!

Hi [First Name],

You're enrolled in **[Course Name]**!

**What you'll learn:**
- [Key outcome 1]
- [Key outcome 2]
- [Key outcome 3]

**Details:**
- **Start date:** [Date]
- **Duration:** [X hours/minutes]
- **Deadline:** [Date]
- **Format:** [Self-paced / Live sessions / Blended]

**Before you begin:**
[Any pre-work or preparation needed]

**Access your course:**
[BUTTON: Start Learning] or [Link to LMS]

Questions? Contact [support email/link].

[Signature]
```

### Pre-Course Reminder

```markdown
**Subject:** [Course Name] Starts [Tomorrow/Monday] - Are You Ready?

Hi [First Name],

Your training begins [tomorrow/on DATE]!

**Quick prep:**
- [ ] [Pre-work item 1, if any]
- [ ] [Pre-work item 2, if any]
- [ ] Block [X minutes/hours] on your calendar

**What to expect:**
[Brief description of first module or session]

**Access your course:**
[Link to LMS]

See you [tomorrow/DATE]!

[Signature]
```

### Deadline Reminder

```markdown
**Subject:** [X Days] Left to Complete [Course Name]

Hi [First Name],

Just a friendly reminder: **[Course Name]** is due on **[Date]**.

**Your progress:** [X]% complete
**Time remaining:** Approximately [X minutes/hours]

[BUTTON: Continue Learning]

Need more time? Contact [manager/admin] to request an extension.

[Signature]
```

### Mid-Course Encouragement

```markdown
**Subject:** Great Progress on [Course Name]!

Hi [First Name],

You're [X]% through [Course Name] - nice work!

**What's next:**
[Brief preview of upcoming content]

**Tip:** [Helpful suggestion related to the training]

Keep going - you've got this!

[BUTTON: Continue Learning]

[Signature]
```

### Completion Congratulations

```markdown
**Subject:** Congratulations! You've Completed [Course Name]

Hi [First Name],

You did it! You've successfully completed **[Course Name]**.

**Your results:**
- **Score:** [X]%
- **Time spent:** [X hours/minutes]
- **Completed on:** [Date]

**What you learned:**
- [Key skill 1]
- [Key skill 2]
- [Key skill 3]

**What's next:**
- [Apply skill in specific situation]
- [Recommended follow-up course, if any]
- [Resources for continued learning]

[BUTTON: Download Certificate] (if applicable)

Thank you for your dedication to learning!

[Signature]
```

### Follow-Up Survey Request

```markdown
**Subject:** Quick Question About [Course Name]

Hi [First Name],

It's been [30/60] days since you completed [Course Name].

We'd love to hear how it's going!

**Quick survey (2 minutes):**
[Link to survey]

Your feedback helps us improve training for your colleagues.

Thank you!

[Signature]
```

## Announcement Templates

### New Course Available

```markdown
**Subject:** New Training Available: [Course Name]

Hi [Team/All],

A new training is now available: **[Course Name]**

**Who should take it:**
[Target audience description]

**What you'll learn:**
- [Outcome 1]
- [Outcome 2]
- [Outcome 3]

**Details:**
- **Duration:** [X hours/minutes]
- **Deadline:** [Date, if mandatory]
- **Required/Optional:** [Specify]

[BUTTON: Enroll Now]

Questions? Reply to this email or contact [support].

[Signature]
```

### Mandatory Training Notice

```markdown
**Subject:** Required: Complete [Course Name] by [Date]

Hi [First Name],

You are required to complete **[Course Name]** by **[Date]**.

**Why this matters:**
[Brief explanation of importance/compliance requirement]

**Details:**
- **Duration:** [X minutes]
- **Deadline:** [Date] - No extensions
- **Tracking:** Completion is reported to [HR/Manager/Compliance]

[BUTTON: Start Training Now]

If you've already completed this training, please disregard this message.

Questions? Contact [support].

[Signature]
```

### Training Update/Change

```markdown
**Subject:** Update: Changes to [Course Name]

Hi [First Name],

We've updated **[Course Name]** with new content.

**What's changed:**
- [Change 1]
- [Change 2]

**What you need to do:**
[If re-take required: "Please complete the updated training by [Date]."]
[If informational: "No action needed - this is for your awareness."]

[BUTTON: View Updated Training]

[Signature]
```

## Writing Guidelines

### Subject Lines

**Do:**
- Keep under 50 characters
- Front-load important info
- Use action words
- Include course name
- Add urgency when appropriate

**Examples:**
- ✓ "Complete Safety Training by Friday"
- ✓ "You're Enrolled: Leadership Essentials"
- ✗ "Important information regarding your upcoming training enrollment"

### Body Content

**Do:**
- Lead with the most important information
- Use short paragraphs (2-3 sentences)
- Include clear calls-to-action
- Personalize with first name
- Make deadlines prominent

**Don't:**
- Bury the action item
- Use jargon without explanation
- Make it too long (aim for <200 words)
- Forget mobile readers

### Tone

| Situation | Tone |
|-----------|------|
| Welcome/Enrollment | Warm, encouraging |
| Reminder | Friendly, clear |
| Deadline warning | Urgent but respectful |
| Completion | Celebratory |
| Mandatory | Professional, firm but not threatening |

## Communication Schedule Template

```markdown
## Course: [Name]
## Audience: [Description]
## Duration: [Enrollment to completion]

| Day | Communication | Channel | Owner |
|-----|---------------|---------|-------|
| Day 0 | Enrollment confirmation | Email | LMS auto |
| Day -1 | Pre-course reminder | Email | L&D |
| Day 3 | Progress check | Email | LMS auto |
| Day 7 | Deadline reminder (if needed) | Email | L&D |
| Day X | Completion congratulations | Email | LMS auto |
| Day X+30 | Follow-up survey | Email | L&D |
```

## Accessibility in Communications

- Use descriptive link text: "Start Training" not "Click here"
- Don't rely on color alone for meaning
- Keep formatting simple for screen readers
- Provide text alternatives for any images
- Test emails in plain text mode

## File Output

Save to: `course-template/03-implementation/learner-communications/`

Naming:
- `email-enrollment-confirmation.md`
- `email-reminder-deadline.md`
- `email-completion.md`
- `announcement-new-course.md`
