---
name: learning-capture
description: Extract and consolidate key learnings, insights, and actionable takeaways from the current conversation session. Use when the user wants to capture, summarize, or document what was learned during the chat, create study materials from discussions, or save important discoveries and decisions for future reference. Triggers include requests like "capture learnings," "summarize what we discussed," "create notes from this conversation," "what did I learn today," or "document our key findings."
---

# Learning Capture

## Overview

Extract, organize, and document key learnings from the current conversation. Transform chat discussions into structured, actionable knowledge artifacts for future reference.

## Core Workflow

### 1. Analyze Conversation Context

Review the current conversation to identify:
- **Core concepts** discussed and explained
- **Key insights** discovered or realized
- **Decisions made** and their rationale
- **Action items** established
- **Resources** shared (links, tools, techniques)
- **Problems solved** and solutions applied
- **Questions answered** with their key takeaways

### 2. Determine Learning Type

Categorize the learnings to structure output appropriately:

**Technical/Skills Learning** - Code, tools, techniques, how-tos
- Structure: Problem → Solution → Implementation → Key concepts
- Format: Code examples, command references, step-by-step processes

**Conceptual Learning** - Ideas, theories, mental models, frameworks
- Structure: Concept → Explanation → Applications → Connections
- Format: Clear definitions, analogies, relationship maps

**Decision Documentation** - Choices made, options evaluated, next steps
- Structure: Context → Options considered → Decision → Rationale → Next steps
- Format: Pros/cons, trade-offs, action items

**Discovery/Research** - Information gathered, sources found, synthesis
- Structure: Question → Findings → Sources → Implications → Follow-ups
- Format: Organized research notes with citations

**Problem-Solving Session** - Debugging, troubleshooting, optimization
- Structure: Problem → Diagnosis → Solution → Prevention → Lessons learned
- Format: Issue description, resolution steps, best practices

### 3. Extract Key Elements

For each identified learning, capture:
- **The core insight** (1-2 sentences)
- **Supporting context** (why it matters, when to apply)
- **Actionable takeaway** (what to do with this knowledge)
- **Related concepts** (connections to other learnings)
- **Examples/evidence** from the conversation

### 4. Structure Output

Create a document that uses this default structure (adapt as needed):

```markdown
# Learnings: [Topic/Date]

## Summary
[2-3 sentence overview of what was covered and main discoveries]

## Key Insights
[Most important takeaways - the "headlines"]

## Detailed Learnings

### [Category/Topic 1]
**What I learned:** [Core concept]
**Why it matters:** [Context and significance]
**How to apply:** [Actionable steps or use cases]
**Related:** [Connections to other concepts]

### [Category/Topic 2]
...

## Action Items
- [ ] [Specific next step with context]
- [ ] [Another action item]

## Resources Referenced
- [Tool/Link name]: [URL or description]
- [Reference material]: [Where to find it]

## Questions for Further Exploration
- [Open question or area to investigate]

## Quick Reference
[Condensed cheat sheet of key commands, formulas, or facts]
```

### 5. Format Selection

Choose the appropriate output format based on user needs:

**Markdown document** (.md) - Default for most learnings
- Use for: General knowledge capture, study notes, reference material
- Benefits: Portable, readable, easy to edit and version control

**Word document** (.docx) - Professional documentation
- Use for: Formal reports, sharing with non-technical audiences
- Benefits: Professional formatting, easy to share/print

**Structured notes** - Inline summary
- Use for: Quick recaps, when user wants immediate text response
- Benefits: Fast, conversational, no file needed

**Checklist/action plan** - Task-focused format
- Use for: Implementation-focused sessions, when next steps are primary
- Benefits: Clear actionability, trackable progress

## Quality Guidelines

**Be concise but complete**
- Capture essence without excessive detail
- Include enough context to be useful standalone
- Assume reader has less context than current conversation

**Make it actionable**
- Focus on what the user can do with this knowledge
- Include specific examples and use cases
- Provide next steps or practice suggestions

**Organize for retrieval**
- Use clear headings and categories
- Prioritize most important learnings first
- Include a summary for quick scanning

**Preserve context**
- Note why something was discussed
- Include relevant constraints or conditions
- Link related concepts together

**Maintain accuracy**
- Ensure technical details are correct
- Clarify assumptions or uncertainties
- Distinguish facts from opinions/recommendations

## Examples

**Example 1: Technical Learning Session**
```
User: "Capture what we learned about using pandas for data analysis"

Output: Create markdown document with:
- Summary of pandas basics covered
- Key functions and their use cases (with code examples)
- Common patterns discovered during discussion
- Gotchas and best practices identified
- Next learning steps
```

**Example 2: Problem-Solving Session**
```
User: "Document how we solved that API authentication issue"

Output: Create markdown document with:
- Problem description and initial symptoms
- Debugging steps taken
- Root cause identified
- Solution implemented (with code)
- Prevention strategies for future
- Lessons learned
```

**Example 3: Conceptual Discussion**
```
User: "Summarize our discussion about design patterns"

Output: Create markdown document with:
- Design patterns covered (Factory, Observer, etc.)
- When to use each pattern
- Trade-offs and considerations
- Examples from our discussion
- Related patterns and resources
```

**Example 4: Research/Discovery Session**
```
User: "Capture key findings from our research on GraphQL"

Output: Create markdown document with:
- Research questions we explored
- Key findings and sources
- Comparison with REST (discussed)
- Use cases where GraphQL excels
- Implementation considerations
- Resources for deeper learning
```

## Advanced Features

### Cross-Reference Previous Learnings

When user has Google Drive access, search for related past learning captures to:
- Identify connections and build on previous knowledge
- Avoid duplication while noting evolution
- Create learning progressions and themes

### Multi-Session Synthesis

When user requests consolidation across multiple sessions:
- Identify common themes and patterns
- Track knowledge evolution over time
- Create comprehensive study guides or documentation
- Build personal knowledge bases

### Customized Formats

Adapt to user preferences:
- Study flashcards for memorization
- Mind maps for visual learners
- Comparison tables for decision frameworks
- Code snippet libraries for developers
- Cheat sheets for quick reference

## Default Behavior

When user says "capture learnings" or similar without specifics:

1. Analyze the entire current conversation
2. Identify 3-5 most significant learnings
3. Create a markdown document with structured summary
4. Include action items if any were discussed
5. Provide the document for user review

Always confirm the output format and structure before generating if ambiguous.
