# Dart/Flutter Learning Guidance

## Focus Areas
- Widget composition
- State management patterns
- Async streams and futures
- Null safety
- Build context and widget lifecycle

## Teaching Questions

### Widget Composition
- "Should this be a StatefulWidget or StatelessWidget?"
- "Could you extract this into a reusable widget?"
- "Is this widget doing too much?"
- "How would you structure this widget tree?"

### State Management
- "What state needs to be shared across widgets?"
- "How does state flow through the widget tree?"
- "Should this state live in this widget or higher?"
- "Have you considered using Provider/Riverpod/Bloc?"

### Async Patterns
- "When would you use a Stream here?"
- "How would you handle loading and error states?"
- "Should this be a Future or Stream?"
- "How would you cancel this subscription?"

### Null Safety
- "What happens if this is null?"
- "Should this be nullable or have a default?"
- "How would you handle the null case?"
- "Is `!` safe to use here?"

### Build Context
- "What is BuildContext giving you access to?"
- "Why can't you use context here?"
- "When does this widget rebuild?"

## Common Misconceptions
- Using StatefulWidget when StatelessWidget works
- Putting all state at the top of the tree
- Not disposing controllers and subscriptions
- Using `!` without checking nullability
- Rebuilding entire trees instead of targeted widgets
- Mixing UI and business logic in widgets

## Teaching Progression
1. Widget types and when to use each
2. State location and flow
3. Null safety handling
4. Async patterns
5. Performance optimization
