# FastAPI/Python Learning Guidance

## Focus Areas
- Route design and RESTful patterns
- Dependency injection
- Pydantic models and validation
- Async/await patterns
- Error handling

## Teaching Questions

### Route Design
- "What HTTP method best represents this action?"
- "How would you structure this URL path?"
- "Should this be a query parameter or path parameter?"
- "What status codes should this endpoint return?"

### Dependency Injection
- "What would make this testable?"
- "How does dependency injection help here?"
- "What should be injected vs imported directly?"
- "Could you use Depends() for this?"

### Pydantic Models
- "What should validate at the Pydantic level vs route level?"
- "How would you handle optional fields?"
- "Could you use a base model here?"
- "What happens with extra fields?"

### Async Patterns
- "When would you use `async def` here?"
- "Is this I/O bound or CPU bound?"
- "What happens if you mix sync and async?"
- "How would you handle concurrent requests?"

### Error Handling
- "What exceptions should this raise?"
- "How should the client know what went wrong?"
- "Should this be an HTTPException or custom exception?"

## Common Misconceptions
- Using async for CPU-bound operations
- Validating twice (Pydantic and manual)
- Forgetting to await coroutines
- Not using dependency injection for testability
- Mixing sync database calls with async routes

## Teaching Progression
1. Route structure and REST principles
2. Request/response models
3. Dependency injection patterns
4. Async considerations
5. Error handling last
