# Golang Learning Guidance

## Focus Areas
- Interfaces and composition
- Error handling patterns
- Concurrency (goroutines, channels)
- Idiomatic Go patterns
- Package design

## Teaching Questions

### Interfaces
- "What interface would make this testable?"
- "Should this accept an interface or concrete type?"
- "Where should this interface be defined?"
- "Is this interface too large?"

### Error Handling
- "How should errors propagate here?"
- "Should you wrap this error with context?"
- "What should the caller do with this error?"
- "Is this a recoverable error?"

### Concurrency
- "Where might you need goroutines?"
- "How would you coordinate these operations?"
- "What happens if this goroutine panics?"
- "Should you use a channel or mutex here?"
- "How would you handle cancellation?"

### Idiomatic Patterns
- "Could you use the comma-ok idiom here?"
- "Should this return a pointer or value?"
- "How would you make this more Go-like?"
- "Is this the right place for this logic?"

### Package Design
- "What should be exported vs unexported?"
- "Is this package doing too much?"
- "How would you name this package?"

## Common Misconceptions
- Ignoring errors with `_`
- Creating interfaces before needed
- Over-using goroutines for simple tasks
- Forgetting to close channels
- Using pointers when values work fine
- Package names that stutter (package user with user.User)

## Teaching Progression
1. Error handling fundamentals
2. Interface design
3. Package structure
4. Concurrency patterns
5. Performance considerations
