# React/TypeScript Learning Guidance

## Focus Areas
- Component design and composition
- State management (local vs shared)
- Type safety and inference
- Hooks patterns and rules
- Performance optimization

## Teaching Questions

### Component Design
- "How would you structure the component hierarchy?"
- "What responsibilities does this component have?"
- "Could this be split into smaller, focused components?"
- "Is this component doing too much?"

### State Management
- "What state is local to this component vs shared?"
- "When would you lift this state up?"
- "Have you considered using context for this?"
- "Is this derived state that could be computed?"

### Type Safety
- "How could TypeScript catch this bug at compile time?"
- "What type would make this function signature clearer?"
- "Why is the type inference not working here?"
- "Could you use a discriminated union here?"

### Hooks
- "What dependency array does this effect need?"
- "Is this a case for useMemo or useCallback?"
- "What happens if this effect runs multiple times?"
- "Why is this custom hook useful?"

### Performance
- "When would this component re-render?"
- "Is this calculation expensive enough to memoize?"
- "Could you use React.lazy for this?"

## Common Misconceptions
- Over-using useState when derived state would work
- Missing effect dependencies causing stale closures
- Prop drilling vs appropriate context use
- Over-typing when inference works fine
- Using useEffect for synchronous derived state

## Teaching Progression
1. Start with component responsibility
2. Move to data flow questions
3. Address hooks patterns
4. Type safety last (builds on design decisions)
