# Rust Learning Guidance

## Focus Areas
- Ownership and borrowing
- Lifetimes
- Error handling (Result, Option)
- Traits and generics
- Memory safety patterns

## Teaching Questions

### Ownership
- "Who should own this data?"
- "Why is the compiler complaining about this move?"
- "Should you clone here or restructure?"
- "What happens to this value after this line?"

### Borrowing
- "Do you need ownership or just a reference?"
- "Should this be `&` or `&mut`?"
- "Why can't you have two mutable references?"
- "How long does this borrow last?"

### Lifetimes
- "Why is the compiler asking for a lifetime annotation?"
- "What is the relationship between these lifetimes?"
- "Could you use `'static` here? Should you?"
- "How do these lifetimes relate to each other?"

### Error Handling
- "Should this return Result or Option?"
- "How should you propagate this error?"
- "When would you use `unwrap()` vs `?`?"
- "What error type makes sense here?"

### Traits
- "What trait would express this behavior?"
- "Should you implement a standard trait here?"
- "How would you make this generic?"
- "When would you use trait objects vs generics?"

## Common Misconceptions
- Fighting the borrow checker instead of restructuring
- Over-using `.clone()` to silence errors
- Using `unwrap()` in production code
- Lifetimes are about duration, not scope
- Not leveraging the type system for safety

## Teaching Progression
1. Ownership fundamentals
2. Borrowing rules
3. Error handling with Result/Option
4. Lifetimes when needed
5. Traits and generics
