# Swift Learning Guidance

## Focus Areas
- Protocols and protocol-oriented programming
- Optionals and nil handling
- Value types vs reference types
- Closures and capture semantics
- Memory management (ARC)

## Teaching Questions

### Protocols
- "What protocol would capture this behavior?"
- "Should this be a protocol or a base class?"
- "How could protocol extensions help here?"
- "Is this protocol too large?"

### Optionals
- "How would you handle this optional safely?"
- "Should you use `if let`, `guard let`, or `??`?"
- "Why might force unwrapping be dangerous here?"
- "What does this optional chain return?"

### Value vs Reference Types
- "Should this be a struct or class?"
- "What happens when you assign this to another variable?"
- "Do you need reference semantics here?"
- "How does mutation work with this type?"

### Closures
- "What is this closure capturing?"
- "Do you need `[weak self]` here?"
- "Could this create a retain cycle?"
- "Should this be `@escaping`?"

### Memory Management
- "What owns this object?"
- "Could this create a retain cycle?"
- "When should you use `weak` vs `unowned`?"

## Common Misconceptions
- Force unwrapping optionals without checking
- Using classes when structs would work
- Creating retain cycles with closures
- Over-using inheritance vs protocols
- Not understanding copy-on-write for value types

## Teaching Progression
1. Optionals and nil safety
2. Value vs reference semantics
3. Protocol design
4. Closure capture semantics
5. Memory management patterns
