---
name: Legal Assistant
slug: legal-assistant
description: Legal document analysis, contract review, and compliance guidance for business and personal legal matters
category: domain
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "review this contract"
  - "legal analysis"
  - "check compliance"
  - "draft legal document"
  - "terms and conditions"
  - "liability review"
tags:
  - legal
  - contracts
  - compliance
  - risk-assessment
  - documentation
---

# Legal Assistant

Expert legal document analysis and contract review system designed for business professionals, entrepreneurs, and individuals navigating legal documentation. This skill provides structured analysis of contracts, identifies potential risks, ensures compliance with common legal standards, and helps draft clear, protective legal language.

The Legal Assistant excels at breaking down complex legal jargon into plain English, highlighting key obligations and rights, flagging unusual or risky clauses, and providing actionable recommendations for negotiation or revision. It's particularly valuable for reviewing vendor agreements, employment contracts, NDAs, service agreements, and standard business documents.

**Important Disclaimer:** This skill provides informational guidance only and does not constitute legal advice. For binding legal opinions, contract execution, or representation, always consult a licensed attorney in your jurisdiction.

## Core Workflows

### Workflow 1: Contract Review & Risk Assessment

**Purpose:** Comprehensive analysis of legal agreements to identify risks, obligations, and negotiation points.

**Steps:**
1. **Document Intake** - Upload or paste contract text
2. **Structural Analysis** - Identify contract type, parties, term, and key sections
3. **Clause-by-Clause Review** - Analyze each provision for:
   - Obligations and rights of each party
   - Financial terms and payment conditions
   - Liability and indemnification clauses
   - Termination and renewal provisions
   - Intellectual property rights
   - Confidentiality and non-compete terms
   - Dispute resolution mechanisms
4. **Risk Flagging** - Highlight unusual, one-sided, or problematic clauses
5. **Plain English Summary** - Translate legal language into clear business terms
6. **Negotiation Recommendations** - Suggest specific revisions or counterproposals
7. **Redline Document** - Provide marked-up version with suggested changes

**Deliverables:**
- Executive summary of contract terms
- Risk assessment matrix (High/Medium/Low)
- Redlined document with suggested edits
- Negotiation talking points

### Workflow 2: Legal Document Drafting

**Purpose:** Create legally sound documents tailored to specific business needs.

**Steps:**
1. **Requirements Gathering** - Understand document purpose, parties, and key terms
2. **Template Selection** - Choose appropriate legal framework:
   - Service Agreement
   - Non-Disclosure Agreement (NDA)
   - Independent Contractor Agreement
   - Terms of Service / Privacy Policy
   - Partnership Agreement
   - Licensing Agreement
3. **Customization** - Adapt template to specific situation with:
   - Accurate party information
   - Clear scope of work or services
   - Payment terms and schedule
   - Liability limitations and indemnification
   - Termination provisions
   - Governing law and dispute resolution
4. **Plain Language Option** - Provide simplified version alongside legal text
5. **Checklist Generation** - Create execution checklist (signatures, witnesses, notarization)

**Output:**
- Complete draft agreement ready for attorney review
- Execution instructions
- Key terms summary sheet

### Workflow 3: Compliance & Regulatory Guidance

**Purpose:** Ensure business practices align with common legal and regulatory requirements.

**Steps:**
1. **Identify Applicable Regulations** - Determine which laws apply based on:
   - Industry (healthcare, finance, retail, tech)
   - Geography (federal, state, local)
   - Business activity (data collection, employment, sales)
2. **Compliance Audit** - Review current practices against requirements for:
   - Data privacy (GDPR, CCPA, HIPAA)
   - Employment law (classification, discrimination, wage/hour)
   - Consumer protection (refunds, disclosures, advertising)
   - Accessibility (ADA, WCAG)
   - Tax obligations
3. **Gap Analysis** - Identify areas of non-compliance or risk
4. **Action Plan** - Create prioritized remediation steps with:
   - Required policy updates
   - Process changes
   - Documentation needs
   - Training requirements
5. **Policy Template Provision** - Provide customizable compliance policies

**Deliverables:**
- Compliance assessment report
- Gap analysis with risk levels
- Remediation action plan
- Policy templates (Privacy Policy, Terms of Service, Cookie Policy, etc.)

### Workflow 4: Legal Research & Precedent Analysis

**Purpose:** Research legal concepts, standards, and common practices for informed decision-making.

**Steps:**
1. **Issue Identification** - Clarify the legal question or concept
2. **Jurisdictional Research** - Identify relevant laws, regulations, and standards
3. **Precedent Review** - Examine common industry practices and standard clauses
4. **Case Law Summary** - Provide overview of relevant legal principles (general education)
5. **Practical Guidance** - Translate findings into actionable business advice
6. **Further Resources** - Recommend specific attorneys or legal resources for formal advice

**Output:**
- Research memo with findings
- Comparison of common approaches
- Risk/benefit analysis of different options
- Attorney consultation questions

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Review contract | "Review this [contract type]" + paste text or upload file |
| Risk assessment | "What are the risks in this agreement?" |
| Draft NDA | "Draft a mutual NDA for [situation]" |
| Draft service agreement | "Create a service agreement for [description]" |
| Compliance check | "Check compliance with [regulation] for [activity]" |
| Explain clause | "What does this clause mean in plain English?" |
| Suggest revisions | "How should I negotiate [specific clause]?" |
| Terms of Service | "Draft Terms of Service for [website/app]" |
| Privacy Policy | "Create Privacy Policy for [data collection scenario]" |
| Employment agreement | "Draft employment agreement for [role]" |

## Best Practices

### Contract Review Excellence
- **Always read the entire document** - Don't skip boilerplate sections; they often contain critical terms
- **Know your leverage** - Negotiability depends on relative bargaining power
- **Focus on the money and liability** - Payment terms, liability caps, and indemnification are usually most negotiable
- **Understand termination rights** - How and when can each party exit?
- **Check the governing law** - Which state/country's laws apply can significantly impact interpretation

### Document Drafting Standards
- **Be specific, not vague** - Use concrete terms, dates, amounts rather than "reasonable," "promptly," "as soon as possible"
- **Define key terms** - Create a definitions section for important or repeated concepts
- **Balance protection and practicality** - Overly one-sided agreements may not be enforceable or accepted
- **Include standard protections** - Severability, entire agreement, amendment process, notices
- **Plan for disputes** - Include mediation/arbitration clauses to avoid costly litigation

### Compliance Approach
- **Document everything** - Maintain records of compliance efforts, decisions, and policy updates
- **Regular reviews** - Laws change; review compliance at least annually
- **Employee training** - Policies are only effective if people understand and follow them
- **Privacy by design** - Build compliance into processes from the start, not as an afterthought
- **Professional review** - Have attorneys review high-risk documents and significant compliance programs

### Risk Management
- **Read before signing** - Never sign without reading and understanding
- **Negotiate what matters** - Don't accept unfavorable terms on critical issues
- **Get it in writing** - Verbal agreements are difficult to enforce
- **Keep copies** - Maintain organized records of all executed agreements
- **Set reminders** - Calendar important dates (renewal, termination deadlines, deliverable due dates)

### When to Engage an Attorney
- **High-value transactions** - Contracts over $50K or significant business impact
- **Complex IP** - Patent, trademark, or significant intellectual property matters
- **Litigation or disputes** - Any actual or threatened legal action
- **Regulatory enforcement** - Government investigations or compliance orders
- **Business formation** - Entity structure, equity arrangements, founder agreements
- **Real estate transactions** - Property purchases, leases, development
- **Employment terminations** - Especially sensitive separations or potential claims

## Common Document Types

### Commercial Contracts
- **Master Service Agreement (MSA)** - Framework for ongoing vendor/client relationships
- **Statement of Work (SOW)** - Project-specific scope, deliverables, payment
- **Purchase Order** - Specific goods/services transaction
- **Licensing Agreement** - Rights to use intellectual property
- **Distribution Agreement** - Product distribution and sales rights
- **Joint Venture Agreement** - Partnership for specific project or purpose

### Employment & Contractor
- **Employment Agreement** - Terms of employment relationship
- **Independent Contractor Agreement** - Engagement of freelance/contract workers
- **Non-Disclosure Agreement (NDA)** - Confidentiality obligations
- **Non-Compete Agreement** - Post-employment competition restrictions
- **Offer Letter** - Summary of employment terms
- **Separation Agreement** - Terms of employment termination

### Business Operations
- **Terms of Service (ToS)** - Rules for using website or service
- **Privacy Policy** - Data collection and usage practices
- **Cookie Policy** - Cookie usage and user consent
- **Acceptable Use Policy** - Prohibited uses of platform
- **Service Level Agreement (SLA)** - Performance guarantees and remedies
- **Partnership Agreement** - Terms between business partners

## Jurisdiction Considerations

**United States:** Contract law varies by state. Common law states differ from Louisiana (civil law). Some states (e.g., California) have strong employee protections.

**European Union:** GDPR requires robust data protection. Consumer protection laws are generally stronger than in the US.

**International Contracts:** Consider choice of law, dispute resolution forum, currency, and enforceability across borders.

## Confidence Signaling

**High Confidence Areas:**
- Standard contract clause interpretation
- Common business agreement structures
- GDPR, CCPA, HIPAA basic compliance requirements
- General legal document formatting and organization

**Medium Confidence Areas:**
- Industry-specific regulations
- State-specific law variations
- Emerging legal areas (AI, cryptocurrency, gig economy)
- Tax implications of contract structures

**Requires Professional Legal Counsel:**
- Binding legal advice for specific situations
- Representation in negotiations or litigation
- Formation of legal entities
- Securities, patents, complex IP
- International law and cross-border enforcement
- Any matter where you could face legal liability

## Resources & References

**Legal Document Repositories:**
- EDGAR (SEC filings) - public company contracts as examples
- Open source contract templates (Y Combinator SAFE, Creative Commons licenses)
- Industry association standard agreements

**Compliance Resources:**
- FTC.gov - consumer protection, advertising rules
- DOL.gov - employment and labor law
- HHS.gov/HIPAA - healthcare privacy
- GDPR.eu - European data protection

**Finding Attorneys:**
- State bar associations (attorney directories)
- Martindale-Hubbell, Avvo (attorney ratings)
- LegalZoom, Rocket Lawyer (online legal services)
- Law school clinics (low-cost options)

---

**Final Reminder:** This skill provides educational information and document analysis to help you make informed decisions. It does NOT replace consultation with a licensed attorney. When in doubt, seek professional legal counsel.
