---
name: lifeoptimizer
description: >-
  Solve general life challenges and optimize daily routines with structured approaches.
  Use when user needs help with time management, planning, decision-making, goal-setting,
  budgeting, or solving everyday life challenges with systematic solutions.
---

# LifeOptimizer Skill

## Overview
This skill solves general life challenges and optimizes daily routines with structured, systematic approaches to improve productivity and well-being.

## When to Use This Skill
- Weekly planning and scheduling optimization
- Financial planning and budgeting assistance
- Personal goal tracking and achievement
- Solving everyday life challenges
- Making important decisions with structured analysis
- Time management and productivity improvement
- Problem-solving for routine life tasks

## How to Use
1. User describes their life challenge or planning need
2. Analyze the situation using proven frameworks
3. Provide structured solutions and recommendations
4. Create actionable plans with clear steps
5. Suggest tracking mechanisms for progress
6. Offer optimization tips for ongoing improvement

## Optimization Frameworks

### Time Management
- Apply time-blocking techniques
- Use priority matrices (Eisenhower Matrix)
- Implement Pomodoro Technique where appropriate
- Suggest optimal scheduling based on energy levels

### Decision Making
- Use pros/cons analysis
- Apply decision trees for complex choices
- Implement weighted scoring for multiple factors
- Consider long-term consequences

### Goal Setting
- Follow SMART goal framework (Specific, Measurable, Achievable, Relevant, Time-bound)
- Break large goals into smaller milestones
- Create accountability mechanisms
- Establish progress tracking systems

### Budget Planning
- Apply 50/30/20 rule or other budgeting frameworks
- Identify spending patterns and optimization opportunities
- Create savings strategies
- Set up expense tracking systems

## Output Format
Provide solutions in this structure:
1. **Situation Analysis**: Understanding of the challenge
2. **Recommended Approach**: Structured solution framework
3. **Action Steps**: Clear, actionable steps to implement
4. **Tracking Method**: How to monitor progress
5. **Optimization Tips**: Additional suggestions for improvement