# Post Archetypes and Templates

This reference file provides ready‑to‑use structures for each post archetype.  Agents should choose the template that best matches the user’s objective and adapt the placeholders to the specific topic.

## Template 1: Experience plus actionable ops tips (medium)

**Hook**: `[What happened] made something obvious about [ops topic].`

**Story**: 3–6 lines describing the scene and your observation.  Focus on a surprise or human/operational insight.

**Takeaways (bullets)**:

1. Tip 1 – e.g. *Put the work on the wall* (visual management).
2. Tip 2 – e.g. *Make ideas frictionless* (post‑its, cadence, ownership).
3. Tip 3 – e.g. *Give someone stewardship* (avoid “everyone owns it”).

**Close**: End with a question (e.g. “How do you make tacit knowledge visible?”) or offer a resource (“DM if you want the template”).

## Template 2: Market trend (long, C‑suite)

**Hook**: `The market is moving towards [trend], but the real impact is [second‑order effect].`

**What most people think**: 2–3 lines summarising the common view.

**What breaks next**: 4–7 lines exploring concrete second‑order consequences and downstream effects.

**What to do now (bullets)**:

1. Action 1 – define owner, cadence, governance.
2. Action 2 – enablement, mentoring, stewardship.
3. Action 3 – metrics, definitions, controls.

**Close**: One question plus soft CTA (e.g. “Where does this show up most for you?” or “DM if you need the checklist”).

## Template 3: Short punch (short)

**Hook**: `If you cannot [name the owner / define the data], you cannot [scale / adopt / govern].`

**Context**: 2 lines giving background or rationale.

**Bullets** (max 3): succinct tips or warnings.

**Close**: “Where are you seeing this most?” or another single question.

## Template 4: Controlled rant (short to medium)

**Rant line**: Open with one line expressing frustration or calling out inefficiency.

**Mechanism & outcomes**: Immediately switch to how to fix the issue, summarising mechanisms and expected outcomes.

**Close**: Finish with a constructive statement or invitation to discuss further.

## Length guidance

Follow these word‑count guidelines:

- **Short posts** (80–140 words): one hook, up to three bullets, and a question or CTA.
- **Medium posts** (140–220 words): experience‑led posts with story and bullets.
- **Long posts** (220–450 words): market trend analyses with second‑order thinking and leader checklists.
