# Tone of Voice Guide

This file documents the desired voice and stylistic rules for LinkedIn posts generated by this skill.  Agents should load this file only when they need a refresher on tone and vocabulary.

## Distinctive voice

- **Observational and reflective**: start from something you saw (a post, meeting or recurring pattern) and extract a leadership lesson.
- **Pragmatic optimist**: acknowledge a problem but point to mechanisms for improvement.
- **Operator credibility**: ground your insights in real situations (retirements, café value streams, recruitment shifts) to show you’ve been in the work.
- **Calm provocation**: occasionally use “rant” energy but remain measured and constructive.

## Post mechanics

- **Tell a mini‑story then generalise** the pattern to a broader operational or leadership insight.
- Use **second‑order thinking**: explore what happens six to twelve months later, or what breaks downstream.
- Highlight **human factors** such as ownership, belonging, judgment and tacit knowledge.
- Always end with a **clear next step**: a question, practical move, or direct call‑to‑action (CTA), such as “DM if interested.”

## Language rules

### Rhythm

- Use **short paragraphs** (one to three sentences).  Avoid dense blocks of text.
- Mix **sentence lengths**: combine simple statements with longer “logic‑chain” sentences for flow.
- Include at most **one rhetorical question** per post; avoid multiple questions in a row.

### Vocabulary to reuse

Continue using these words and phrases to maintain consistency and recognition:

- ownership, belonging, visibility, value streams, tacit knowledge, judgment
- validation, context, accuracy, upskilling, mentoring, coaching
- productivity, workflows, inefficiencies, adoption, scaling growth
- “the big unknown”, “ironically”, “the result could be”, “until then”

### Edge phrases (use sparingly)

- “A rant…”
- “Another day, another meet.”
- “The big unknown is…”
- “Until then…”

## Post archetype rotation

Follow a simple two‑week cycle:

- **2 short posts** (punchy principle + checklist)
- **1 experience post** (story + operational tips)
- **1 market insight post** (long, second‑order thinking)

This cadence keeps variety without diluting your brand.

## Short vs long posts

- **Short posts (80–140 words)** are best for a single operational truth, a checklist or a sharp opinion.  They should include:
  - One line hook
  - Up to three bullets
  - A question or CTA

- **Long posts (220–450 words)** suit topics like AI, workforce shifts, governance or operating model changes.  They must include:
  - A “most people miss this” moment
  - A practical leadership checklist
  - A crisp close (question or CTA)

## Executive‑friendly CTAs

Rotate among a set of non‑needy CTAs, for example:

- “If you are tackling this in 2026, what is your biggest constraint right now: ownership, capability, or data?”
- “If useful, I can share the checklist I use in discovery. DM me.”
- “If this resonates, where does it show up most for you: CRM, PMO, service ops, or data governance?”

## Avoid

- Too many questions in a row (reads like venting rather than leadership).
- Over‑claiming numbers (e.g. “30%+”) unless framed as a directional hypothesis.
- Framing the conversation as “tools vs IT”; emphasise ownership and operating model instead.

## References for deeper study (optional)

Agents may draw on concepts from the following works when appropriate:

- Rummler, G. and Brache, A. (1995). *Improving Performance* – ownership across the “white space”.
- Kotter, J. (1996). *Leading Change* – reinforcement and adoption.
- Axelos (2019). *ITIL 4 Foundation* – service ownership and continual improvement.
- ISACA (2019). *COBIT 2019* – governance objectives and accountability.
- Kaplan, R. and Norton, D. (1996). *The Balanced Scorecard* – linking initiatives to outcomes.
- Bain RAPID decision rights framework – clear decision ownership.
- Davenport, T.H. (1993). *Process Innovation* – process, IT and operating performance.
