# User Profile for LinkedIn Content

Voice, topics, and positioning for Muhammad Umer Razzaq.

---

## Identity

| Field | Value |
|-------|-------|
| **Name** | Muhammad Umer Razzaq |
| **LinkedIn** | https://www.linkedin.com/in/mumerrazzaq |
| **Niche** | AI Automation & n8n Workflows |
| **Certification** | PIAIC Agentic AI Engineer |
| **Location** | Pakistan |

---

## Headline & Bio

**Current headline:**
```
AI Automation Engineer | n8n & Python | Building Agentic AI Systems
```

**Bio:**
```
PIAIC Certified Agentic AI Engineer

I build automation systems that run themselves using n8n, Python, and AI agents.

Currently:
- Creating workflow automations for businesses
- Building agentic AI systems with OpenAI SDK
- Learning in public about AI-driven development

Following Spec-Driven and Test-Driven Development.
Open to freelance automation projects.
```

---

## Topics to Post About

### Primary (Post frequently)
- AI projects built (StudyBuddy, voice agents, workflows)
- Automation wins (before/after metrics)
- Learning milestones (courses, certifications, skills)
- Tech explainers (n8n, Agentic AI, CrewAI)

### Secondary (Occasional)
- Career updates
- Tool comparisons
- Failures and lessons learned
- Industry observations

### Avoid
- Generic motivational content
- Political/controversial topics
- Personal life unrelated to career
- Content outside automation/AI niche

---

## Voice Characteristics

Based on 165 preference instructions analyzed:

| Trait | Description |
|-------|-------------|
| **Concise** | Always prefers shorter (asks 20x in data) |
| **Professional** | Default tone for business |
| **Honest** | Acknowledges learning journey, skill gaps |
| **Solution-oriented** | Leads with approach, not credentials |
| **Natural** | Conversational, not formal |

### Phrases that sound like user:
- "Here's the plan:"
- "What I learned:"
- "I recently built..."
- "The stack: [tools]"
- "Took [time] to set up"

### Phrases to AVOID (not user's voice):
- "I'm thrilled to announce"
- "In today's fast-paced world"
- "Excited to share"
- Excessive enthusiasm
- Corporate jargon

---

## Skills to Highlight

### Primary (Mention frequently)
- n8n workflow automation
- Python development
- AI agents (OpenAI Agents SDK)
- API integrations
- Spec-Driven Development
- Test-Driven Development

### Secondary (When relevant)
- FastAPI
- Google Workspace automation
- WhatsApp Business API
- Shopify automation

### Learning (Be honest)
- React (recently started)
- Node.js (expanding)

---

## Content Formulas

### Project announcement:
```
[What I built] + [What it does] + [Key insight] + [Link in comments]
```

### Learning post:
```
[What I learned] + [Why it matters] + [Key takeaway] + [What's next]
```

### Tech explainer:
```
[Hook question] + [Simple explanation] + [Why it matters] + [CTA]
```

---

## Engagement Style

### Commenting
- Add genuine insight
- Connect to personal experience
- Ask thoughtful questions
- No empty "Great post!" comments

### Responding to comments
- Reply within first hour when possible
- Add value in responses
- Ask follow-up questions
- Thank specific observations

---

## Hashtags Used

**Core:**
```
#n8n #Automation #AI #Python #WorkflowAutomation
```

**AI-specific:**
```
#AgenticAI #AIAgents #OpenAI #LLM
```

**Career:**
```
#BuildInPublic #LearningInPublic #TechCareers
```

Limit: 3-5 per post. Put at bottom.
