# LinkedIn Algorithm Hacks

## How the Algorithm Works

```
Post Published
    ↓
Show to ~10% of followers (test batch)
    ↓
Measure engagement (first 60-90 mins CRITICAL)
    ↓
Low engagement → Stop showing
High engagement → Show to more followers → Viral potential
```

### Engagement Signals (Ranked by Weight)

| Signal | Weight | Why |
|--------|--------|-----|
| Comments | Highest | Indicates conversation value |
| Dwell time | High | Shows content is worth reading |
| Shares/Reposts | High | Content worth spreading |
| Reactions | Medium | Quick approval signal |
| Clicks on "See more" | Medium | Hook worked |
| Profile visits | Low | Curiosity indicator |

---

## The Golden Hour

**First 60 minutes determine your post's fate.**

### Maximize First Hour:
1. Reply to EVERY comment within 5 mins
2. Ask a question to encourage comments
3. Post when YOUR audience is online
4. Have 2-3 colleagues ready to comment (not react)

### Comment Boosting Strategy:
```
- Reply with follow-up questions (extends thread)
- Ask commenters to elaborate
- Tag relevant people in your replies
- Each reply counts as new engagement
```

---

## Optimal Posting Times

### General Best Times (Adjust to YOUR timezone)
| Day | Best Times | Why |
|-----|------------|-----|
| Tuesday | 8-10 AM, 12 PM | Peak professional activity |
| Wednesday | 8-10 AM, 12 PM | Mid-week engagement high |
| Thursday | 8-10 AM, 12 PM, 5-6 PM | End of week visibility |
| Monday | 10 AM - 12 PM | After morning emails |
| Friday | 8-10 AM only | Drops off after lunch |

### Times to AVOID
- Weekends (60% less reach)
- After 6 PM (except Thursday)
- Monday before 10 AM
- Holiday periods

### Find YOUR Best Time
1. Check LinkedIn Analytics
2. When do YOUR followers comment most?
3. Consider timezone of target audience

---

## Content Format Rankings

### Reach Multipliers (vs. text-only post)
| Format | Reach Multiplier | Best For |
|--------|------------------|----------|
| Carousel/Document | 2-3x | Tutorials, lists, stories |
| Text + Image | 1.5x | Insights with visual |
| Text only | 1x (baseline) | Stories, opinions |
| Native video | 1.5x | Behind-scenes, tips |
| Polls | 2x+ | Engagement bait |
| External links | 0.5x | AVOID in post body |
| LinkedIn articles | 0.3x | Lowest reach |

---

## Reach Killers (AVOID)

### Immediate Reach Drops
| Action | Reach Impact |
|--------|--------------|
| External link in post | -50% or more |
| Editing post within 1 hour | -30% |
| More than 5 hashtags | -20% |
| Tagging 10+ people | -30% |
| "Link in bio" text | -20% |
| Asking for likes directly | Flagged as engagement bait |

### External Links Strategy
```
❌ Wrong: Put link in post body
✅ Right: "Link in first comment" + post link as comment
✅ Better: No link, valuable content only
```

---

## Hashtag Strategy

### Less is More
| # of Hashtags | Recommendation |
|---------------|----------------|
| 0 | Safe, no negative impact |
| 1-3 | Optimal for discoverability |
| 4-5 | Diminishing returns |
| 6+ | Looks spammy, hurts reach |

### Hashtag Selection
```
1 broad hashtag: #Leadership #Technology #Career
1-2 niche hashtags: #DevOps #StartupFounder #ProductManagement
```

### Where to Place
- End of post (not beginning)
- Or in first comment (cleanest look)

---

## Dwell Time Optimization

**Longer people spend reading = more reach.**

### Increase Dwell Time:
1. **Longer posts** (1200-1500 chars optimal)
2. **White space** (forces scrolling)
3. **Lists with explanations** (not just bullet points)
4. **Story format** (people read to the end)
5. **Carousel documents** (each slide = more time)

### Format for Scrolling:
```
Short sentence.

Another short sentence.

Then a slightly longer point that adds value.

Keep them scrolling.

More white space = more dwell time.
```

---

## Engagement Baiting (Ethical)

### Do This (Authentic Engagement)
```
✅ "What's your experience?"
✅ "Agree or disagree?"
✅ "What would you add?"
✅ Genuinely controversial opinions
✅ Asking for specific advice
```

### Don't Do This (Spam)
```
❌ "Like if you agree"
❌ "Comment YES if..."
❌ "Share to win"
❌ Fake polls for engagement
❌ Rage bait / negativity
```

---

## Consistency Beats Virality

### Posting Frequency
| Frequency | Expected Outcome |
|-----------|------------------|
| Daily | Fastest growth, high effort |
| 3-4x/week | Optimal balance |
| 2x/week | Sustainable minimum |
| 1x/week | Slow growth |
| Sporadic | Algorithm forgets you |

### Content Mix (per week)
```
2-3 value posts (tips, insights, tutorials)
1 story post (personal, relatable)
1 engagement post (question, poll, debate)
```

---

## Profile Optimization (Affects Post Reach)

### Complete Profile = More Reach
- Professional photo (65% more engagement)
- Compelling headline (not just job title)
- Featured section with best content
- Creator mode ON (if 500+ followers)

### Creator Mode Benefits
- "Follow" button instead of "Connect"
- Hashtags on profile
- LinkedIn Live access
- Newsletter feature
