# LinkedIn Formatting Guide

## Mobile-First Design

**70%+ of LinkedIn users are on mobile.**

### Screen Reality
- 40 characters per line visible
- First 2 lines show before "see more"
- Long paragraphs = wall of text = skip

---

## The Golden Rules

### Rule 1: Short Sentences
```
❌ "I wanted to share with you all something that I learned during my 10-year journey..."
✅ "10 years in tech taught me this:"
```

**Max 12 words per sentence.**

### Rule 2: One Idea Per Line
```
❌ "Be consistent, show up every day, provide value, and engage with others."

✅ "Be consistent.
Show up every day.
Provide value.
Engage with others."
```

### Rule 3: White Space is Your Friend
```
❌ Dense paragraph with no breaks that goes on and on making it hard to read on mobile devices and causing people to scroll past without engaging.

✅ Dense paragraph?

Nobody reads that.

White space is your friend.

One thought.

Then another.

Easy to scan.
```

### Rule 4: Front-Load Value
```
❌ "After working for many years in the industry, I've come to realize that..."
✅ "The industry's biggest lie: [value immediately]"
```

---

## Visual Hierarchy

### Use These Elements

**Arrows for flow:**
```
→ First point
→ Second point
→ Third point
```

**Bullets for lists:**
```
• Item one
• Item two
• Item three
```

**Numbers for steps:**
```
1. Do this first
2. Then do this
3. Finally, this
```

**Dashes for impact:**
```
The result?

— 10x more engagement
— 5x more followers
— 3x more opportunities
```

**Colons for reveals:**
```
The secret:

[Your insight here]
```

---

## Formatting Patterns

### The Hook + Break Pattern
```
[Compelling hook line]
[Second hook line]

[White space forces "see more" click]

[Continue your content]
```

### The List Pattern
```
[Hook]

Here's what I learned:

1. [Point one]
   [Brief explanation]

2. [Point two]
   [Brief explanation]

3. [Point three]
   [Brief explanation]

[Takeaway]

[CTA]
```

### The Story Pattern
```
[Hook - usually the ending/result]

[Setup - 1-2 short lines]

[The challenge - what went wrong]

[The turning point]

[The resolution]

[The lesson - 1 line]

[CTA]
```

### The Framework Pattern
```
[Hook introducing framework]

The [Name] Framework:

**[Step 1 Name]**
[Explanation]

**[Step 2 Name]**
[Explanation]

**[Step 3 Name]**
[Explanation]

[How to apply]

[CTA]
```

---

## Special Characters That Work

### Separators
```
---
━━━
• • •
───────
```

### Emphasis
```
**Bold text** (use sparingly)
CAPS for ONE word (not sentences)
"Quotes for key phrases"
→ Arrows for direction
```

### Emoji Usage (Optional)
```
✅ Do: 1-3 relevant emojis
✅ Do: Emoji as bullet points
❌ Don't: Emoji overload 🚀💡🔥✨⭐️🙌
❌ Don't: Emoji in every sentence
```

**Effective emoji placement:**
```
📌 Key insight:
✅ What works
❌ What doesn't
💡 Pro tip:
```

---

## Ideal Post Length

### Character Count Sweet Spots
| Type | Characters | Lines |
|------|------------|-------|
| Short & punchy | 500-800 | 8-12 |
| Standard value | 1000-1500 | 15-25 |
| Story/Thread | 1500-2000 | 25-35 |
| Maximum | 3000 | 50+ |

### Why 1200-1500 is Optimal
- Long enough for value
- Increases dwell time
- Not overwhelming
- Easy to format well

---

## Code Blocks (For Tech Content)

### Short Code (Inline)
```
Use `code` for inline snippets.
```

### Code Blocks
```
Unfortunately LinkedIn doesn't render code blocks.

Workaround:
→ Use monospace characters
→ Or share as image/carousel
→ Or link to GitHub gist in comments
```

---

## Before Publishing Checklist

- [ ] First 2 lines are compelling
- [ ] Sentences under 12 words
- [ ] Plenty of white space
- [ ] One idea per line
- [ ] Easy to scan visually
- [ ] Looks good on mobile
- [ ] Ends with clear CTA
- [ ] No wall of text anywhere
