# Hooks Library

## Hook Templates by Category

### Contrarian/Bold Takes
```
Unpopular opinion: [controversial statement]
Hot take: [bold claim]
I'm going to say what no one else will: [truth bomb]
Stop [common advice]. Here's why:
[Common belief] is a lie.
Everyone talks about [X]. Nobody talks about [Y].
```

### Story Hooks
```
I [failed/succeeded] at [X] [number] times before [outcome].
3 years ago, I was [bad situation]. Today, I [good outcome].
I almost [gave up/quit/failed] when [situation].
The worst [career moment/decision] taught me [lesson].
I went from [bad state] to [good state] in [timeframe].
My biggest mistake? [mistake]. Here's what I learned:
```

### Question Hooks
```
Why do [audience] struggle with [problem]?
What if everything you knew about [topic] was wrong?
Have you ever [relatable struggle]?
What separates [successful] from [unsuccessful]?
Why do 90% of [people] fail at [thing]?
```

### List/Number Hooks
```
[Number] things I wish I knew about [topic]
[Number] mistakes killing your [goal]
[Number] habits that changed my [life/career]
[Number] signs you're [positive/negative trait]
After [X years], here are [number] truths about [topic]
```

### Achievement/Proof Hooks
```
I [impressive achievement] in [timeframe]. Here's how:
[Number]% increase in [metric]. The secret?
From [low number] to [high number] [metric] in [time].
I've [hired/managed/mentored] [number] [people]. Here's what I learned:
```

### Curiosity Gap Hooks
```
The [topic] strategy nobody talks about:
There's a reason [successful people] do [thing]:
I found the [adjective] way to [achieve goal]:
This one [thing] changed how I [activity]:
```

### Relatable Pain Hooks
```
Tired of [common frustration]? Read this.
If you're struggling with [problem], you're not alone.
[Common situation] is exhausting. Here's what helps:
I used to [bad habit]. Then I discovered [solution].
```

---

## CTA Templates

### For Comments (Highest Engagement)
```
What's your experience with this?
Agree or disagree?
What would you add to this list?
Drop a [emoji] if you've been there.
Which one resonates most with you?
What's the biggest [topic] lesson you've learned?
Tell me your [topic] story in the comments.
```

### For Follows
```
Follow for more [topic] insights.
If this helped, follow for daily [topic] tips.
I share [content type] every [frequency]. Follow along.
```

### For Shares
```
Share this with someone who needs to hear it.
Repost if you agree.
Tag someone who [description].
```

### For Saves
```
Save this for when you need it.
Bookmark this for later.
Save → Apply → Thank me later.
```

### For DMs/Leads
```
DM me "[keyword]" for [free resource].
Comment "[word]" and I'll send you [resource].
Want the full [guide/template]? DM me.
```

### For Links (Put in First Comment)
```
Link in comments.
Full article in first comment.
Dropped the link below.
```

---

## Hook Power Words

### Emotion Triggers
```
Secret, Mistake, Truth, Surprising, Unpopular
Failed, Struggle, Finally, Never, Always
Hidden, Real, Honest, Brutal, Simple
```

### Action Words
```
Stop, Start, Avoid, Try, Discover
Learn, Build, Create, Transform, Master
```

### Credibility Words
```
Years, Clients, Companies, Interviews, Hired
Managed, Built, Scaled, Grew, Achieved
```

---

## Hooks by Audience

### For Developers/Tech
```
The code pattern that senior devs use (juniors don't)
I reviewed 500+ PRs. Here's what separates good from great:
Stop writing [bad practice]. Do this instead:
This debugging technique saved me 10 hours:
```

### For Job Seekers
```
I've reviewed [X] resumes. [Y]% make this mistake:
The interview question that trips everyone up:
I got rejected from [number] companies. Then I changed [thing]:
Your LinkedIn profile is costing you interviews. Here's why:
```

### For Entrepreneurs/Business
```
My [product/service] failed because [reason]. Lesson learned:
[X] revenue in [time]. Here's the playbook:
The pricing mistake that cost me [amount]:
I said no to [opportunity]. Best decision ever.
```

### For Leaders/Managers
```
The management advice I wish I ignored:
I've managed [number] people. Here's what actually works:
Why your best employees quit (it's not money):
The 1:1 question that transforms team performance:
```
