# LinkedIn Post Best Practices Reference

## Optimal Post Length
- **Character sweet spot:** 1,200-1,500 characters
- **Engagement drop-off:** After 2,000 characters
- **Short posts (under 500 chars):** Good for quick insights, quotes
- **Long posts (1,000+ chars):** Better for stories, tutorials, thought leadership

## Best Posting Times
- **Tuesday-Thursday:** 8-10 AM, 12 PM, 5-6 PM (local time)
- **Avoid:** Weekends and Monday mornings
- **Pro tip:** Test different times and track engagement

## Hook Formulas That Work

### Pattern 1: Surprising Statement
```
"The best code I ever wrote was code I deleted."
"I got rejected by 47 companies before landing my dream job."
```

### Pattern 2: Relatable Pain Point
```
"You spend 3 hours debugging. The issue? A missing semicolon."
"Your calendar is full but you feel unproductive. Here's why:"
```

### Pattern 3: Bold Question
```
"What if everything you know about productivity is wrong?"
"Are you building features or solving problems?"
```

### Pattern 4: Numbered Promise
```
"5 mistakes that cost me $100K in my first startup."
"3 things I wish I knew before becoming a manager."
```

### Pattern 5: Contrarian Take
```
"Unpopular opinion: Passion is overrated."
"Hot take: Your MVP is too complicated."
```

## Content Types That Perform Well

### 1. Personal Stories (Highest Engagement)
- Career transitions
- Lessons from failures
- Breakthrough moments
- Behind-the-scenes experiences

### 2. Actionable Lists
- "X ways to..."
- "X mistakes to avoid..."
- "X tools that..."
- "X lessons learned..."

### 3. Frameworks and Mental Models
- Decision-making frameworks
- Problem-solving approaches
- Career development models
- Productivity systems

### 4. Industry Insights
- Trend analysis
- Market observations
- Tool comparisons
- Best practice guides

### 5. Thought Leadership
- Contrarian perspectives
- Future predictions
- Industry commentary
- Philosophy on work

## Formatting Techniques

### Use Visual Breaks
```
Short sentence.

Blank line creates breathing room.

Another short thought.
```

### Leverage Symbols
- → Arrow for points
- ✓ Checkmark for completions
- • Bullet for lists
- — Em dash for emphasis
- " " Quotes for highlighting

### Create Scannable Structure
```
**Bold for key phrases**

→ Bullet points for lists

Numbers for sequences:
1. First point
2. Second point
3. Third point

CAPS for EMPHASIS (use sparingly)
```

## Hashtag Strategy

### The 3-5 Rule
- **2 popular hashtags** (100K+ posts) - #Marketing #AI
- **2-3 medium hashtags** (10K-100K) - #ContentStrategy #TechLeadership
- **0-1 niche hashtag** (under 10K) - #B2BSaaS #DevOpsTools

### Placement Options
1. **End of post** (recommended - doesn't break reading flow)
2. **In comments** (keeps post cleaner)
3. **Integrated in text** (use sparingly)

### Find Good Hashtags
- Check what industry leaders use
- Look at competitors' popular posts
- Use LinkedIn's hashtag suggestions
- Track which tags drive your engagement

## Call-to-Action Examples

### For Engagement
- "What's your experience with this?"
- "Agree or disagree?"
- "What would you add to this list?"
- "Have you faced this challenge?"

### For Discussion
- "What's your biggest challenge with [topic]?"
- "How do you handle this in your role?"
- "What's worked for you?"

### For Sharing
- "Tag someone who needs to see this"
- "Share if you found this helpful"
- "Pass this along to your team"

### For Connection
- "DM me if you want to discuss this further"
- "Connect if you're interested in [topic]"
- "Let's continue this conversation"

## Engagement Boosters

### Reply to Comments Quickly
- First hour is critical
- Ask follow-up questions
- Show genuine interest
- Keep conversation going

### Tag Strategically
- Mention people you quote
- Tag companies when relevant
- Don't over-tag (max 2-3)

### Post Consistently
- Find sustainable cadence (2-3x per week is good)
- Quality > Quantity
- Batch create content

### Repurpose Top Performers
- Reframe popular posts after 3-6 months
- Update with new insights
- Different angle on same topic

## Common Engagement Killers

❌ **Too corporate/salesy**
- Sounds like a press release
- Heavy product promotion
- No personal voice

❌ **Wall of text**
- No paragraph breaks
- Hard to scan
- Readers scroll past

❌ **Vague or generic**
- "Success takes hard work" (no insight)
- Motivational platitudes
- No specific value

❌ **No clear point**
- Rambling thoughts
- Multiple unrelated ideas
- Missing takeaway

❌ **Clickbait without delivery**
- Promising what you don't deliver
- Misleading hooks
- Disappointing content

## Platform Algorithm Factors

### LinkedIn Favors:
✓ Native content (not external links in post)
✓ Conversation in comments
✓ Quick engagement (first 60 minutes)
✓ Dwell time (how long people read)
✓ Shares and reshares

### LinkedIn Penalizes:
✗ External links in post body (put in comments instead)
✗ Spammy behavior
✗ Very short posts with just links
✗ Excessive tagging

## Content Calendar Ideas

### Weekly Themes
- **Monday:** Motivational/Start of week
- **Tuesday:** Tips & How-to
- **Wednesday:** Industry insights
- **Thursday:** Personal story/lessons
- **Friday:** Recap/reflection

### Monthly Themes
- Week 1: Personal development
- Week 2: Industry trends
- Week 3: Tools & resources
- Week 4: Case studies/examples

## Measuring Success

### Key Metrics
- **Engagement rate:** (Likes + Comments + Shares) / Impressions
- **Comment quality:** Depth of discussion
- **Profile views:** Are people checking you out?
- **Connection requests:** Growing your network?

### What Good Looks Like
- 3-5% engagement rate is solid
- 5-10 meaningful comments
- Several profile views
- 1-3 connection requests

### Iterate Based on Data
- Track what topics resonate
- Note which formats work
- Test different times
- Double down on what works
