# LinkedIn Post Template

Use this template as a quick reference when generating posts.

## Basic Template Structure

```markdown
[HOOK - 1-2 punchy lines that grab attention]

[Blank line]

[CONTEXT - Set up the story/insight]

[Blank line]

[VALUE/BODY - Main content with specific insights]

Use formatting:
→ Bullet points for clarity
→ Short paragraphs (1-3 lines)
→ White space for readability

[Blank line]

[KEY TAKEAWAY - What's the main point?]

[Blank line]

[CALL TO ACTION - Question or request for engagement]

[Blank line]

#Hashtag1 #Hashtag2 #Hashtag3 #Hashtag4 #Hashtag5
```

## Template Variations

### Personal Story Template

```
[Opening: The moment that changed everything]

[What happened: Brief context]

[The struggle or challenge:]
→ Problem 1
→ Problem 2
→ Problem 3

[What changed: The turning point]

[Lessons learned:]
1. First lesson
2. Second lesson
3. Third lesson

[Reflective closing statement]

[CTA: Ask readers about their experience]

#RelevantHashtags
```

### Educational/Tips Template

```
[Hook: Common mistake or surprising fact]

[Why it matters]

Here's what actually works:

**Tip 1: [Title]**
→ Explanation
→ Why it works

**Tip 2: [Title]**
→ Explanation
→ Why it works

**Tip 3: [Title]**
→ Explanation
→ Why it works

[Summary statement]

[CTA: Ask which tip they'll try first]

#RelevantHashtags
```

### Thought Leadership Template

```
[Controversial or contrarian statement]

Everyone thinks [common belief].

But here's what they're missing:

[Your perspective]

The data shows:
→ Point 1
→ Point 2
→ Point 3

This is why [industry/practice] needs to change:

[Your argument with examples]

**The future isn't [old way].**
**It's [new way].**

[CTA: Ask for agreement/disagreement]

#RelevantHashtags
```

### List/Framework Template

```
[Hook: Promise of value]

After [X years/experiences], here are the [number] [things]:

1️⃣ [First item]
[Brief explanation]

2️⃣ [Second item]
[Brief explanation]

3️⃣ [Third item]
[Brief explanation]

4️⃣ [Fourth item]
[Brief explanation]

5️⃣ [Fifth item]
[Brief explanation]

[Closing insight]

[CTA: Ask which resonated most]

#RelevantHashtags
```

### Problem-Solution Template

```
[Hook: Relatable problem]

Sound familiar?

[Describe the pain point in detail]

I used to struggle with this too.

Here's what changed everything:

**The Problem:**
[Root cause explanation]

**The Solution:**
[Your framework/approach]

**How to implement it:**
→ Step 1
→ Step 2
→ Step 3

**The result:**
[What changes/improves]

[CTA: Ask about their approach]

#RelevantHashtags
```

### Short & Punchy Template

```
[One powerful statement]

[Supporting line]

[Key insight or question]

[CTA]

#Hashtags
```

Example:
```
The best leaders I know ask more questions than they answer.

Because giving all the answers creates dependence.
Asking the right questions creates leaders.

What question has had the biggest impact on your growth?

#Leadership #Management #GrowthMindset
```

## File Metadata Template

When saving posts, use this structure:

```markdown
# LinkedIn Post: [Descriptive Title]

**Date Created:** YYYY-MM-DD
**Target Audience:** [specific audience]
**Tone:** [Professional/Casual/Inspirational/Educational]
**Length:** [word count] words
**Topic:** [main topic]

---

## Post Content

[The actual post goes here]

---

## Metadata
- **Main Topic:** [topic]
- **Key Themes:** [theme1, theme2, theme3]
- **Hashtags:** #hashtag1 #hashtag2 #hashtag3 #hashtag4 #hashtag5
- **Estimated Reading Time:** [X] seconds
- **Target Engagement:** [Comments/Shares/Discussion]

## Performance Notes
[Add notes after posting about what worked/didn't work]
```

## Character Count Guidelines

- **Hook:** 50-100 characters
- **Context/Setup:** 100-200 characters
- **Main Content:** 400-800 characters
- **Call to Action:** 50-100 characters
- **Hashtags:** 50-150 characters
- **Total Sweet Spot:** 1,200-1,500 characters

## Quick Reference: Power Words

### For Hooks
- Surprising, Unexpected, Shocking
- Mistake, Failure, Lesson
- Secret, Truth, Reality
- Stop, Avoid, Never
- Better, Best, Worst

### For Authority
- Research shows, Data proves
- In my experience, I've learned
- Studies indicate, Experts agree
- The reality is, The truth is

### For Engagement
- What's your, How do you
- Agree or disagree, Thoughts?
- Share your, Tell me about
- Have you ever, Do you

## Emoji Guide (Use Sparingly)

### Professional Context
- → (arrow for points)
- ✓ (checkmark for completed items)
- 📊 (charts/data)
- 💡 (ideas/insights)
- 🎯 (goals/targets)

### Numbered Lists
- 1️⃣ 2️⃣ 3️⃣ (for numbered points)

### Avoid in Professional Posts
- 😂 🔥 💯 (too casual for most B2B content)
- Excessive emojis (looks unprofessional)
