---
name: Literature Review
slug: literature-review
description: Academic research synthesis, paper analysis, and comprehensive literature reviews across disciplines
category: research
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "literature review"
  - "research papers"
  - "academic research"
  - "synthesize research"
  - "analyze papers"
tags:
  - academic-research
  - literature-review
  - research-synthesis
  - citation-analysis
  - scholarly-research
---

# Literature Review

Expert academic research agent that conducts comprehensive literature reviews, analyzes research papers, synthesizes findings across studies, and identifies research gaps. Specializes in systematic reviews, meta-analysis support, citation analysis, and academic writing assistance.

This skill applies rigorous academic research methodologies to gather, evaluate, synthesize, and present scholarly literature. Perfect for thesis research, grant proposals, academic writing, and evidence-based decision-making.

## Core Workflows

### Workflow 1: Comprehensive Literature Review

**Objective:** Conduct systematic review of academic literature on a specific topic

**Steps:**
1. **Define Review Scope**
   - Research question or topic
   - Inclusion/exclusion criteria
   - Time period for literature (e.g., last 10 years)
   - Disciplines and fields to include
   - Geographic scope if relevant
   - Language restrictions

2. **Search Strategy Development**
   - Identify key concepts and terms
   - Develop Boolean search strings
   - Identify synonyms and related terms
   - Plan database search strategy
   - **Databases to search:** Google Scholar, PubMed, arXiv, JSTOR, Web of Science approach

3. **Literature Search**
   - Use WebSearch with academic-focused queries
   - Search multiple databases with systematic approach
   - Forward citation search (who cited key papers)
   - Backward citation search (references in key papers)
   - Use Firecrawl to extract from academic databases
   - Track search results and sources

4. **Screening & Selection**
   - Title and abstract screening
   - Full-text review of promising papers
   - Apply inclusion/exclusion criteria consistently
   - Document reasons for exclusion
   - Aim for 20-50 core papers depending on topic breadth

5. **Quality Assessment**
   - Evaluate research methodology
   - Assess sample size and statistical power
   - Check for bias and limitations
   - Evaluate credibility of publication venue
   - Consider citation count and impact factor
   - Rate quality (high/medium/low)

6. **Data Extraction**
   - Author, year, publication, citation count
   - Research question and hypotheses
   - Methodology and study design
   - Sample characteristics
   - Key findings and results
   - Limitations acknowledged
   - Create structured extraction table

7. **Synthesis & Analysis**
   - Group papers by theme or methodology
   - Identify consistent findings across studies
   - Note contradictory findings and why
   - Identify research gaps and opportunities
   - Map evolution of research over time
   - Build narrative synthesis or meta-analysis

8. **Literature Review Report**
   - Introduction and background
   - Review methodology
   - Thematic organization of findings
   - Critical analysis and synthesis
   - Research gaps identified
   - Conclusions and future directions
   - Comprehensive bibliography

**Deliverable:** Systematic literature review with synthesis, analysis, and research gap identification

### Workflow 2: Individual Paper Analysis

**Objective:** Deep critical analysis of a single research paper

**Steps:**
1. **Bibliographic Information**
   - Authors and affiliations
   - Publication venue and year
   - Citation count and impact
   - DOI and access information

2. **Abstract & Introduction Analysis**
   - Research problem and motivation
   - Research questions or hypotheses
   - Contribution claims
   - Theoretical framework
   - Scope and boundaries

3. **Literature Review Evaluation**
   - Comprehensiveness of background
   - Key papers cited
   - Theoretical grounding
   - Positioning relative to prior work
   - Identification of research gap

4. **Methodology Assessment**
   - Research design (experimental, observational, etc.)
   - Data collection methods
   - Sample selection and size
   - Variables and measures
   - Analysis techniques
   - Methodological rigor and validity
   - Limitations and potential biases

5. **Results Analysis**
   - Main findings
   - Statistical significance and effect sizes
   - Tables and figures interpretation
   - Unexpected or null findings
   - Result quality and reliability

6. **Discussion & Conclusions**
   - Interpretation of findings
   - Theoretical implications
   - Practical implications
   - Limitations acknowledged
   - Future research directions
   - Strength of conclusions relative to evidence

7. **Critical Evaluation**
   - Strengths of the paper
   - Weaknesses and limitations
   - Validity of conclusions
   - Contribution to the field
   - Citation potential
   - Overall quality rating

**Deliverable:** Detailed paper analysis with critical evaluation and citation summary

### Workflow 3: Research Gap Identification

**Objective:** Identify opportunities for novel research contributions

**Steps:**
1. **Map Current Research Landscape**
   - What questions have been answered
   - What populations have been studied
   - What methodologies have been used
   - What contexts have been explored
   - Geographic and temporal coverage

2. **Identify Gap Types**
   - **Knowledge Gaps:** Questions not yet answered
   - **Methodological Gaps:** Better ways to study known questions
   - **Population Gaps:** Understudied groups or contexts
   - **Contextual Gaps:** Different settings or time periods
   - **Theoretical Gaps:** Unexplored frameworks or perspectives
   - **Practical Gaps:** Research-to-practice translation

3. **Evaluate Gap Significance**
   - Theoretical importance
   - Practical relevance
   - Feasibility of addressing
   - Resource requirements
   - Potential impact
   - Alignment with research trends

4. **Formulate Research Questions**
   - Specific, answerable questions
   - Aligned with identified gaps
   - Feasible with available methods
   - Novel and original
   - Significant contribution potential

5. **Justify Gap Importance**
   - Why this gap matters
   - What we'll learn by addressing it
   - How it advances the field
   - Practical applications
   - Stakeholder benefits

**Deliverable:** Research gap analysis with justified research question proposals

### Workflow 4: Citation & Impact Analysis

**Objective:** Analyze citation patterns and research impact

**Steps:**
1. **Citation Metrics Collection**
   - Total citation count
   - Citations per year
   - H-index (for authors)
   - Journal impact factor
   - Altmetric scores (social media mentions)
   - Use Google Scholar, Semantic Scholar data

2. **Citation Network Analysis**
   - Most cited papers in the area
   - Co-citation patterns (papers cited together)
   - Bibliographic coupling (papers citing same sources)
   - Identify seminal papers (highly cited, older)
   - Identify emerging papers (recent, growing citations)

3. **Author Impact Analysis**
   - Key researchers and institutions
   - Collaboration networks
   - Research trajectory over time
   - Influence and authority in field

4. **Temporal Analysis**
   - Publication volume over time
   - Citation trends over time
   - Identify hot topics and declining areas
   - Predict future research directions

5. **Research Influence Mapping**
   - Which disciplines cite this work
   - Cross-disciplinary impact
   - Geographic distribution of citations
   - Academic vs. practitioner citations

**Deliverable:** Citation analysis report with impact metrics and influence mapping

### Workflow 5: Evidence Synthesis for Decision-Making

**Objective:** Synthesize research evidence to inform practical decisions

**Steps:**
1. **Define Decision Context**
   - Decision to be made
   - Stakeholders and perspectives
   - Constraints and considerations
   - Success criteria

2. **Evidence-Based Question**
   - Translate decision into research question
   - PICO framework (Population, Intervention, Comparison, Outcome)
   - Identify relevant evidence types

3. **Rapid Evidence Assessment**
   - Focused search on decision-relevant literature
   - Prioritize recent, high-quality studies
   - Include systematic reviews and meta-analyses
   - Consider grey literature if relevant

4. **Evidence Quality Grading**
   - Randomized controlled trials (highest for interventions)
   - Observational studies
   - Case studies
   - Expert opinion (lowest)
   - Use GRADE or similar framework

5. **Synthesis & Recommendations**
   - What does research say about each option
   - Strength of evidence (strong, moderate, weak)
   - Consistency of findings
   - Applicability to context
   - Evidence gaps and uncertainties
   - Recommendations with confidence levels

**Deliverable:** Evidence-based decision brief with graded recommendations

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Full literature review | "Conduct literature review on [topic]" |
| Analyze paper | "Analyze this research paper in detail" |
| Find research gaps | "Identify research gaps in [area]" |
| Citation analysis | "Analyze citations for [paper/topic]" |
| Evidence synthesis | "Synthesize research evidence on [question]" |
| Find seminal papers | "What are the most important papers on [topic]?" |

## Academic Search Strategy

### Boolean Operators
- **AND:** Narrows search (both terms must appear)
  - Example: `machine learning AND healthcare`
- **OR:** Broadens search (either term can appear)
  - Example: `artificial intelligence OR machine learning`
- **NOT:** Excludes terms
  - Example: `machine learning NOT neural networks`

### Advanced Search Techniques
- **Quotation marks:** Exact phrase matching
  - Example: `"deep learning"`
- **Asterisk (*):** Wildcard for variations
  - Example: `comput*` finds compute, computer, computing, computational
- **Parentheses:** Group terms
  - Example: `(AI OR "artificial intelligence") AND ethics`

### Field-Specific Searches
- **Title search:** `intitle:keyword` or `allintitle:keywords`
- **Author search:** `author:"Last Name"`
- **Publication search:** `source:"Journal Name"`
- **Date range:** `after:2020 before:2025`

## Research Databases by Discipline

### General Academic
- **Google Scholar:** Broad coverage, free access
- **Semantic Scholar:** AI-powered, free, good citation analysis
- **CORE:** Open access research papers
- **BASE:** Bielefeld Academic Search Engine

### Sciences
- **PubMed/MEDLINE:** Medicine and life sciences
- **arXiv:** Physics, math, CS, preprints
- **bioRxiv:** Biology preprints
- **IEEE Xplore:** Engineering and computer science

### Social Sciences & Humanities
- **JSTOR:** Humanities and social sciences
- **SSRN:** Social sciences preprints
- **PhilPapers:** Philosophy
- **PsycINFO:** Psychology

### Business & Economics
- **EconLit:** Economics
- **Business Source Complete:** Business and management
- **SSRN:** Economics and finance working papers

## Best Practices

- **Systematic approach:** Document search strategy and selection criteria
- **Quality over quantity:** Better to deeply analyze 20 papers than skim 100
- **Track your sources:** Use citation management approach; document where you found each paper
- **Read critically:** Don't assume published = correct; evaluate methodology and conclusions
- **Note limitations:** Every study has limitations; acknowledge them
- **Avoid confirmation bias:** Actively seek contradictory findings
- **Cite properly:** Give credit; use consistent citation style (APA, MLA, Chicago)
- **Synthesize, don't summarize:** Find patterns and connections across papers
- **Identify gaps:** What's missing is often as important as what's there
- **Stay current:** Research evolves quickly; set alerts for new papers

## Paper Quality Assessment Criteria

### Methodology
- [ ] Clear research question and hypotheses
- [ ] Appropriate research design
- [ ] Adequate sample size and statistical power
- [ ] Valid and reliable measures
- [ ] Appropriate statistical analysis
- [ ] Control for confounds and bias
- [ ] Replication potential

### Reporting
- [ ] Transparent methodology description
- [ ] Complete results reporting (including null findings)
- [ ] Limitations acknowledged
- [ ] Data and materials availability
- [ ] Conflicts of interest disclosed

### Impact & Relevance
- [ ] Addresses important question
- [ ] Novel contribution
- [ ] Strong theoretical grounding
- [ ] Practical implications
- [ ] Builds on prior research appropriately

## Literature Review Structure Templates

### Narrative Review Structure
```markdown
# Literature Review: [Topic]

## 1. Introduction
- Background and context
- Review objectives and scope
- Significance of topic

## 2. Methodology
- Search strategy and databases
- Inclusion/exclusion criteria
- Selection process
- Analysis approach

## 3. Theoretical Framework
- Key concepts and definitions
- Theoretical foundations
- Conceptual model

## 4. Thematic Review
### Theme 1: [Name]
- Overview
- Key studies
- Findings synthesis
- Gaps and contradictions

### Theme 2: [Name]
[Repeat structure]

## 5. Discussion
- Overall patterns and trends
- Contradictions and debates
- Research quality assessment
- Practical implications

## 6. Research Gaps & Future Directions
- Identified gaps
- Proposed research questions
- Methodological opportunities

## 7. Conclusions
- Summary of key findings
- Contribution of this review
- Limitations

## References
```

### Systematic Review PRISMA Structure
```markdown
# Systematic Review: [Topic]

## Abstract
- Background, objectives, methods, results, conclusions

## 1. Introduction
- Rationale
- Objectives

## 2. Methods
- Protocol and registration
- Eligibility criteria (PICO)
- Information sources
- Search strategy
- Study selection process
- Data collection process
- Data items
- Risk of bias assessment
- Summary measures
- Synthesis methods

## 3. Results
- Study selection (PRISMA flow diagram)
- Study characteristics
- Risk of bias within studies
- Results of individual studies
- Synthesis of results

## 4. Discussion
- Summary of evidence
- Limitations
- Conclusions and implications

## 5. Funding

## References

## Appendices
- Full search strategies
- Excluded studies with reasons
- Data extraction forms
```

## Integration with Other Skills

- **Use with `data-analyzer`:** Quantitative synthesis and meta-analysis
- **Use with `trend-spotter`:** Identify emerging research trends
- **Use with `competitive-intelligence`:** Academic competitive landscape
- **Use with `market-research-analyst`:** Validate market assumptions with research
- **Use with `industry-expert`:** Deep domain research synthesis

## Common Pitfalls to Avoid

- **Cherry-picking:** Only citing papers that support your view
- **Plagiarism:** Copying text without proper citation or paraphrasing
- **Outdated sources:** Relying on old research when newer studies exist
- **Overreliance on abstracts:** Reading only abstracts without full papers
- **Ignoring null results:** Publication bias means negative results are underreported
- **Uncritical acceptance:** Published doesn't mean correct or applicable
- **Narrow search:** Missing relevant papers due to limited search terms
- **No quality filter:** Treating all published research as equally valid
- **Poor organization:** Summarizing papers sequentially vs. thematically
- **Lack of synthesis:** Listing findings without connecting themes

## Citation Management Tips

- **Consistent format:** Choose APA, MLA, Chicago, etc. and stick to it
- **Complete information:** Capture all bibliographic details immediately
- **DOI inclusion:** Include DOI when available for permanent links
- **Access dates:** Note when you accessed online sources
- **Page numbers:** Capture page numbers for direct quotes
- **Organize by theme:** Group papers by topic for easier synthesis
- **Note-taking:** Summarize key points for each paper as you read
- **Track versions:** Preprints vs. published versions may differ
