---
name: localization-i18n
description: |
  多言語ドキュメントと国際化の専門スキル。i18n/l10nベストプラクティス、翻訳準備ライティング、多言語構造設計、グローバルコンテンツ品質保証を提供。

  Anchors:
  • The Culture Map (Erin Meyer) / 適用: 文化適応戦略 / 目的: 地域特化ローカライゼーション
  • Everybody Writes (Ann Handley) / 適用: 翻訳可能コンテンツ作成 / 目的: 明確で翻訳しやすい原文

  Trigger:
  Use when designing multilingual documentation, preparing content for translation, implementing i18n frameworks, or validating localization quality.
allowed-tools:
  - Read
  - Write
  - Edit
  - Bash
  - Glob
  - Grep
---

# Localization & i18n

## 概要

多言語対応ドキュメントの設計・翻訳準備スキル。国際化（i18n）と地域化（l10n）のベストプラクティスを提供し、計画から品質保証まで段階的に支援する。

## ワークフロー

### Phase 1: 戦略計画

**目的**: ローカライゼーション戦略を策定

**アクション**:

1. 対象言語・地域の優先順位を決定
2. 文化的配慮事項を特定
3. リソース計画とタイムラインを作成

**Task**: `agents/plan-strategy.md` を参照

### Phase 2: コンテンツ準備

**目的**: 翻訳に適した原文を作成

**アクション**:

1. 翻訳しやすい文章に書き換え
2. 用語集を作成
3. プレースホルダーを設計

**Task**: `agents/prepare-content.md` を参照

### Phase 3: 実装

**目的**: i18nフレームワークを実装

**アクション**:

1. i18n設定ファイルを作成
2. 言語リソースファイルを生成
3. コードにi18n対応を実装

**Task**: `agents/implement-i18n.md` を参照

### Phase 4: 品質検証

**目的**: ローカライゼーション品質を検証

**アクション**:

1. 翻訳品質を評価
2. 文化的適合性を確認
3. 技術的な問題を検出

**Task**: `agents/validate-quality.md` を参照

## Task仕様（ナビゲーション）

| Task             | 起動タイミング | 入力             | 出力                   |
| ---------------- | -------------- | ---------------- | ---------------------- |
| plan-strategy    | Phase 1開始時  | プロジェクト要件 | 戦略計画書             |
| prepare-content  | Phase 2開始時  | 戦略計画書       | 翻訳準備済みコンテンツ |
| implement-i18n   | Phase 3開始時  | コンテンツ       | i18n実装コード         |
| validate-quality | Phase 4開始時  | 実装コード       | 品質レポート           |

**詳細仕様**: 各Taskの詳細は `agents/` ディレクトリを参照

## ベストプラクティス

### すべきこと

| 推奨事項                     | 理由                     |
| ---------------------------- | ------------------------ |
| 名前付きプレースホルダー使用 | 翻訳者にコンテキスト提供 |
| 用語集を作成・維持           | 一貫性確保               |
| 段階的に実装                 | 各ステップで検証可能     |
| 文化的配慮を事前調査         | 地域適合性を確保         |

### 避けるべきこと

| 禁止事項                 | 問題点               |
| ------------------------ | -------------------- |
| 文化依存表現（慣用句等） | 翻訳困難・誤解を招く |
| 番号のみプレースホルダー | コンテキスト不明     |
| 翻訳者への情報不足       | 品質低下             |
| 一度に全体をi18n化       | 問題特定困難         |

## リソース参照

### scripts/（決定論的処理）

| スクリプト                    | 用途               |
| ----------------------------- | ------------------ |
| `check-translation-ready.mjs` | 翻訳準備度チェック |
| `log_usage.mjs`               | 使用記録           |

### references/（詳細知識）

| リソース       | パス                                                                               | 読込条件         |
| -------------- | ---------------------------------------------------------------------------------- | ---------------- |
| 基礎知識       | [references/basics.md](references/basics.md)                                       | 初回使用時       |
| 翻訳準備ガイド | [references/translation-ready-writing.md](references/translation-ready-writing.md) | コンテンツ準備時 |

### assets/（テンプレート）

| アセット                       | 用途                       |
| ------------------------------ | -------------------------- |
| `multilingual-doc-template.md` | 多言語ドキュメント構造雛形 |
| `i18n-config.json`             | i18n設定テンプレート       |
| `messages.json`                | 言語リソースファイル例     |

## 変更履歴

| Version | Date       | Changes                            |
| ------- | ---------- | ---------------------------------- |
| 2.1.0   | 2026-01-02 | 18-skills.md仕様に完全準拠で再構築 |
| 2.0.0   | 2025-12-31 | 構造改善                           |
