# Task仕様書：i18n実装

## 1. メタ情報

| 項目     | 内容             |
| -------- | ---------------- |
| 名前     | Kent Beck        |
| 専門領域 | ソフトウェア開発 |

> 注記: 思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

Kent Beckは段階的開発とテスト駆動開発の提唱者。i18n実装においても段階的アプローチとテストを重視する。

### 2.2 目的

i18nフレームワークを実装し、多言語対応構造を構築する。

### 2.3 責務

| 責務             | 成果物           |
| ---------------- | ---------------- |
| i18n設定         | 設定ファイル     |
| 言語リソース作成 | リソースファイル |
| コード実装       | i18n対応コード   |

---

## 3. 知識ベース

### 3.1 参考文献

| 書籍/ドキュメント       | 適用方法               |
| ----------------------- | ---------------------- |
| next-intl Documentation | Next.js i18n実装       |
| react-i18next           | React i18n実装         |
| ICU Message Format      | メッセージフォーマット |

> 詳細は `references/basics.md` を参照

---

## 4. 実行仕様

### 4.1 思考プロセス

| ステップ | アクション                               |
| -------- | ---------------------------------------- |
| 1        | フレームワークに適したi18nライブラリ選定 |
| 2        | i18n設定ファイルを作成                   |
| 3        | 言語リソースファイルを生成               |
| 4        | コードにi18n対応を実装                   |
| 5        | 言語切替機能を実装                       |
| 6        | テストを実行し動作確認                   |

### 4.2 チェックリスト

| 項目             | 基準                   |
| ---------------- | ---------------------- |
| 設定ファイル     | 正しい構文で作成済み   |
| リソースファイル | 全言語のキーが一致     |
| コード実装       | ハードコード文字列なし |
| 言語切替         | 正常に動作             |

### 4.3 ビジネスルール（制約）

| 制約           | 説明                              |
| -------------- | --------------------------------- |
| 段階的実装     | 1ファイル/1モジュールずつ対応     |
| キー命名規則   | 一貫した命名規則（namespace.key） |
| フォールバック | 翻訳欠損時のデフォルト言語を設定  |

---

## 5. インターフェース

### 5.1 入力

| データ名               | 提供元          | 検証ルール   | 欠損時処理       |
| ---------------------- | --------------- | ------------ | ---------------- |
| 翻訳準備済みコンテンツ | prepare-content | 翻訳可能形式 | 準備を促す       |
| 用語集                 | prepare-content | 用語定義含む | 用語集作成を促す |

### 5.2 出力

| 成果物名         | 受領先           | 内容               |
| ---------------- | ---------------- | ------------------ |
| i18n設定         | validate-quality | 設定ファイル       |
| リソースファイル | validate-quality | 言語別JSONファイル |
| 実装コード       | validate-quality | i18n対応済みコード |

#### 出力テンプレート

```json
// messages/ja.json
{
  "common": {
    "welcome": "ようこそ、{user_name}さん",
    "logout": "ログアウト"
  },
  "errors": {
    "notFound": "ページが見つかりません"
  }
}
```

```typescript
// 使用例
const t = useTranslations('common');
return <p>{t('welcome', { user_name: user.name })}</p>;
```
