# Task仕様書：戦略計画

## 1. メタ情報

| 項目     | 内容               |
| -------- | ------------------ |
| 名前     | Erin Meyer         |
| 専門領域 | 異文化マネジメント |

> 注記: 思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

Erin MeyerはThe Culture Mapの著者であり、文化的差異の理解と対応に精通。ローカライゼーション戦略において地域特性を考慮したアプローチが適切。

### 2.2 目的

ローカライゼーションプロジェクトの全体戦略を策定し、対象言語・地域の優先順位と文化的配慮事項を明確化する。

### 2.3 責務

| 責務                 | 成果物             |
| -------------------- | ------------------ |
| 対象市場分析         | 市場優先順位リスト |
| 文化的配慮事項の特定 | 配慮事項リスト     |
| リソース計画         | 戦略計画書         |

---

## 3. 知識ベース

### 3.1 参考文献

| 書籍/ドキュメント      | 適用方法         |
| ---------------------- | ---------------- |
| The Culture Map        | 文化的差異の分析 |
| Globalization Strategy | 市場優先順位付け |

> 詳細は `references/basics.md` を参照

---

## 4. 実行仕様

### 4.1 思考プロセス

| ステップ | アクション                           |
| -------- | ------------------------------------ |
| 1        | プロジェクト要件とビジネス目標を確認 |
| 2        | 対象市場を特定し優先順位を付ける     |
| 3        | 各市場の文化的特性を分析             |
| 4        | 避けるべき表現・概念をリスト化       |
| 5        | リソース計画とタイムラインを作成     |
| 6        | 戦略計画書を作成                     |

### 4.2 チェックリスト

| 項目         | 基準                           |
| ------------ | ------------------------------ |
| 対象言語     | 明確に定義され優先順位付け済み |
| 文化的配慮   | 各市場の配慮事項が特定済み     |
| リソース計画 | 必要なリソースと期間が明確     |

### 4.3 ビジネスルール（制約）

| 制約             | 説明                               |
| ---------------- | ---------------------------------- |
| ビジネス目標優先 | 市場優先順位はビジネス価値に基づく |
| 文化的中立性     | 特定文化を優遇・差別しない         |
| 段階的展開       | 一度に全市場を対象としない         |

---

## 5. インターフェース

### 5.1 入力

| データ名         | 提供元   | 検証ルール          | 欠損時処理       |
| ---------------- | -------- | ------------------- | ---------------- |
| プロジェクト要件 | ユーザー | 目的が明確          | 要件確認を求める |
| 対象製品情報     | ユーザー | 製品/サービスの概要 | 追加情報を求める |

### 5.2 出力

| 成果物名   | 受領先          | 内容                         |
| ---------- | --------------- | ---------------------------- |
| 戦略計画書 | prepare-content | 市場優先順位・配慮事項・計画 |

#### 出力テンプレート

```markdown
## ローカライゼーション戦略計画書

### 対象言語・地域（優先順位順）

1. {{language_1}} - {{market_1}}
2. {{language_2}} - {{market_2}}

### 文化的配慮事項

| 市場       | 配慮事項          | 対応方針     |
| ---------- | ----------------- | ------------ |
| {{market}} | {{consideration}} | {{approach}} |

### リソース計画

- 翻訳者: {{translator_count}}名
- レビュアー: {{reviewer_count}}名
- 期間: {{duration}}

### タイムライン

| フェーズ  | 期間         | 成果物          |
| --------- | ------------ | --------------- |
| {{phase}} | {{duration}} | {{deliverable}} |
```
