# 翻訳準備ライティングガイド

## 概要

このガイドは、翻訳者が効率的かつ正確に翻訳できる
原文を作成するためのベストプラクティスを提供します。

## 翻訳しやすい文章の原則

### 1. 明確性（Clarity）

**1文1アイデア**:

```markdown
❌ 複雑:
「ファイルを選択して開くボタンをクリックすると、
エディタが起動してファイルの内容が表示され、
編集が可能になります。」

✅ 分割:
「1. ファイルを選択します。2. [開く]ボタンをクリックします。3. エディタが起動します。4. ファイルの内容が表示されます。5. 編集を開始できます。」
```

### 2. 一貫性（Consistency）

**用語の統一**:

```markdown
❌ 不統一:
「設定を開く」「設定画面を表示」「コンフィグを開く」

✅ 統一:
すべて「設定を開く」に統一
```

### 3. 簡潔性（Brevity）

**不要な語を削除**:

```markdown
❌ 冗長:
「実際にファイルを保存する操作を行うためには」

✅ 簡潔:
「ファイルを保存するには」
```

## 避けるべきパターン

### 文化依存表現

| 避ける             | 理由          | 改善                |
| ------------------ | ------------- | ------------------- |
| 「一石二鳥」       | 日本語固有    | 「2つの効果がある」 |
| 「青写真」         | 文化的背景    | 「計画」「設計図」  |
| 「右から左へ流す」 | RTL言語で混乱 | 「無視する」        |

### 暗黙の文脈

```markdown
❌ 暗黙:
「例の件について」「あれを確認して」

✅ 明示:
「先週のミーティングで議論した認証機能について」
「ログファイルのエラーを確認して」
```

### 複合語と略語

```markdown
❌ 略語:
「PWAを有効化」「CI/CDパイプライン」

✅ 初出時は展開:
「プログレッシブウェブアプリ（PWA）を有効化」
「継続的インテグレーション/継続的デリバリー（CI/CD）パイプライン」
```

## プレースホルダーの使い方

### 変数の配置

```yaml
# ❌ 連結による構築
greeting: "こんにちは、"
greeting_suffix: "さん"
# 使用: greeting + name + greeting_suffix

# ✅ プレースホルダー
greeting: "こんにちは、{user_name}さん"
```

### 名前付きプレースホルダー

```yaml
# ❌ 番号のみ
message: "{0}が{1}を{2}しました"

# ✅ 名前付き
message: "{user}が{file}を{action}しました"
```

### コンテキスト提供

```yaml
# ✅ 翻訳者向けコメント付き
file_count:
  value: "{count}個のファイル"
  context: "ファイル選択ダイアログで使用。countは0以上の整数"
  max_length: 30
```

## 複数形の処理

### 言語別複数形ルール

| 言語       | 複数形カテゴリ                   |
| ---------- | -------------------------------- |
| 英語       | one, other                       |
| 日本語     | other（区別なし）                |
| ロシア語   | one, few, many, other            |
| アラビア語 | zero, one, two, few, many, other |

### ICU MessageFormat

```
{count, plural,
  =0 {ファイルがありません}
  =1 {1個のファイル}
  other {{count}個のファイル}
}
```

## 技術文書での注意点

### コードブロック

````markdown
✅ コードは翻訳しない:

```javascript
// This comment should be translated
// このコメントは翻訳される
const value = calculate();
```
````

❌ コード内の文字列も対象:

```javascript
console.log("Error occurred"); // 翻訳対象
```

````

### UI要素の参照

```markdown
❌ 直接参照:
「Save」ボタンをクリック

✅ ローカライズ可能:
[保存]ボタンをクリック
（翻訳時に各言語のUI表記に合わせる）
````

## 品質チェック項目

### 文構造

- [ ] 1文は40文字（または20語）以内
- [ ] 能動態を使用
- [ ] 主語が明確
- [ ] 修飾語が適切な位置

### 用語

- [ ] 用語集に従っている
- [ ] 略語は初出時に展開
- [ ] 専門用語には説明がある

### フォーマット

- [ ] 日付・時刻は変数化
- [ ] 数値フォーマットは変数化
- [ ] 通貨は適切に処理

### 文化的配慮

- [ ] 慣用句を使用していない
- [ ] 文化依存の例がない
- [ ] 画像内テキストがない（または別管理）

## 翻訳者への情報提供

### コンテキストシート

```markdown
## コンテキスト情報

### ドキュメント概要

- 目的: ユーザーガイド
- 対象: 一般ユーザー
- トーン: フレンドリー、丁寧

### 特記事項

- 「設定」と「環境設定」は区別して翻訳
- ボタン名は[]で囲む
- コードブロック内のコメントのみ翻訳

### 用語集参照

- 用語集: /docs/glossary.yaml
- スタイルガイド: /docs/style-guide.md
```

## ツールとリソース

### 推奨ツール

| カテゴリ | ツール例          | 用途         |
| -------- | ----------------- | ------------ |
| CAT      | memoQ, SDL Trados | 翻訳支援     |
| TMS      | Crowdin, Lokalise | 翻訳管理     |
| QA       | Xbench, Verifika  | 品質チェック |
| 用語管理 | MultiTerm         | 用語集管理   |

### i18nライブラリ

| 言語/FW    | ライブラリ    | 特徴      |
| ---------- | ------------- | --------- |
| JavaScript | i18next       | 多機能    |
| React      | react-i18next | React統合 |
| Vue        | vue-i18n      | Vue統合   |
| Python     | gettext       | 標準      |
| Ruby       | i18n gem      | Rails標準 |
