---
name: lp-analysis
description: LPをTOMYスタイル基準で分析し、成約率を最大4.3倍に改善する具体的な施策を提案。3つの黄金ルールに基づく最適化。
---

# LP分析・最適化スキル

LPをTOMYメルマガスタイル基準で分析し、成約率を最大化する改善策を提案。

## When to Use This Skill

以下の場合にこのスキルを使用：
- 「LPを分析して」「LPの改善点を教えて」
- 「成約率を上げたい」「コンバージョン改善」
- 「TOMYスタイルで最適化」
- 「セールスレターを改善」

## 成約率を最大化する3つの黄金ルール

### ルール1: 数値は「期間+端数+倍率」の3点セット

**Before（一般的LP）**:
- 「売上1000万円達成」

**After（TOMYスタイル）**:
- 「たった3ヶ月で売上127.8万円達成（従来の4.26倍）」

**効果**: 信憑性2.1倍向上、成約率1.8倍

### ルール2: 緊急性は「日時+理由+損失」の3点セット

**Before（一般的LP）**:
- 「期間限定」

**After（TOMYスタイル）**:
- 「今日23:59で公開終了（理由:サーバー負荷のため先着50名限定）」
- 「1日遅れるごとに機会損失87.3万円」

**効果**: 即決率4.7倍向上

### ルール3: 感情は「恐怖→希望」のサイクルを最低5回

**Before（一般的LP）**:
- 感情振幅1.2回/LP

**After（TOMYスタイル）**:
- 感情振幅5.3回/LP
- 恐怖を極限まで描写 → 希望を具体的に描写

**効果**: 感情移入3.2倍向上、成約率2.7倍

## 分析指標

### 文章構造の比較

| 指標 | TOMYスタイル基準 | 一般的LP平均 |
|-----|----------------|-------------|
| 短文比率 | 48.2% | 28.3% |
| 1文1行徹底 | 91.3% | 34.7% |
| 疑問文比率 | 22.1% | 8.4% |
| 段落間空白行 | 96.8% | 45.2% |

### 心理トリガーの使用頻度

| トリガー | TOMYスタイル基準 | 一般的LP平均 |
|---------|----------------|-------------|
| 損失回避(恐怖) | 8.7回/LP | 2.1回/LP |
| 緊急性 | 6.8回/LP | 0.9回/LP |
| 希少性 | 4.3回/LP | 0.4回/LP |
| 対比 | 7.9回/LP | 1.6回/LP |

## 改善ロードマップ

### フェーズ1: 緊急改善（1週間）
1. 数値の端数記載（2時間）→ 信憑性2.1倍
2. 緊急性の設定（3時間）→ 即決率4.7倍
3. Before→After事例を1つ追加（5時間）→ 信頼性1.8倍

**予想効果**: 成約率1.5-2.0倍

### フェーズ2: 構造改善（1ヶ月）
1. 恐怖→希望のサイクル設計
2. 短文化とリズム最適化
3. 心理トリガーの追加

**予想効果**: 成約率2.5-3.5倍

### フェーズ3: 完全統合（3ヶ月）
1. ストーリーテリングの深化
2. 証拠の徹底
3. 感情振幅の極大化
4. A/Bテストの実施

**予想効果**: 成約率4.0-6.0倍

## カテゴリ別改善策

### AI活用型LP
- 恐怖訴求の追加（AI未活用の機会損失）
- 期間の明示
- 感情的ストーリー追加

### 高額商品販売型LP
- 中規模の成功事例を3-5個追加
- Before→Afterストーリー
- 緊急性の設定

### メソッド・法則型LP
- 短期成果の強調
- 具体的な数値事例
- 緊急性の理由

## 分析出力形式

```
【LP分析結果】

■ TOMYスタイル適合度: XX/100点

■ 主な強み:
1. ...
2. ...

■ 主な改善点:
1. ...（具体的な修正案付き）
2. ...

■ 今すぐ実施すべき3つの改善:
1. ...（所要時間: X時間）
2. ...
3. ...

■ 予想効果: 成約率X.X倍向上
```

## 参照ナレッジ

- `ローンチ動画/総合結果分析/06_最終総括レポート.md`
- その他LP分析ファイル
