# 懒猫微服部署助手 (lzc-deploy)

一个专业的 Claude Skill，帮助开发者快速部署应用到懒猫微服（Lazycat Microservice）平台。

## 功能特性

- **配置文件生成**: 交互式生成 `lzc-manifest.yml` 和 `lzc-build.yml`
- **Docker 迁移**: 将现有 Docker/Docker-Compose 应用迁移到懒猫微服
- **部署指导**: 提供完整的部署流程和命令序列
- **配置优化**: 根据最佳实践优化现有配置
- **商店发布**: 指导应用商店上架流程

## 文档结构

```
lzc-deploy/
├── SKILL.md                      # 主技能文件（快速开始、工作流程）
└── references/                   # 详细参考文档
    ├── manifest-spec.md          # Manifest 完整规范
    ├── build-spec.md             # Build 配置规范
    ├── route-patterns.md         # 路由配置深度指南
    ├── docker-migration.md       # Docker 迁移详细指南
    ├── deploy-params.md          # 部署参数配置
    ├── store-publishing.md       # 商店发布流程
    └── examples.md               # 完整配置示例集
```

## 安装方法

### 方法 1: 符号链接（推荐）

```bash
# 创建符号链接到 Claude 用户技能目录
ln -s "$(pwd)/lzc-deploy" ~/.claude/skills/user/lzc-deploy

# 验证安装
ls -l ~/.claude/skills/user/lzc-deploy
```

### 方法 2: 复制文件

```bash
# 复制整个目录到 Claude 用户技能目录
cp -r lzc-deploy ~/.claude/skills/user/

# 验证安装
ls -l ~/.claude/skills/user/lzc-deploy
```

## 使用示例

安装后，在 Claude Code 中可以这样使用：

### 示例 1: 部署新的 Vue 项目

```
用户: 我想将我的 Vue 3 项目部署到懒猫微服

Claude: [调用 lzc-deploy skill]
        引导收集项目信息 →
        生成配置文件 →
        提供部署命令 →
        指导测试验证
```

### 示例 2: Docker 应用迁移

```
用户: 帮我把这个 docker-compose.yml 转换为懒猫微服配置

Claude: [调用 lzc-deploy skill]
        分析 docker-compose.yml →
        转换为 lzc-manifest.yml →
        说明需要调整的地方 →
        提供部署指导
```

### 示例 3: 配置优化

```
用户: 如何优化我的懒猫应用配置？

Claude: [调用 lzc-deploy skill]
        读取现有配置 →
        分析潜在问题 →
        提供优化建议 →
        生成改进配置
```

### 示例 4: 商店发布

```
用户: 我想把应用发布到懒猫应用商店

Claude: [调用 lzc-deploy skill]
        检查上架条件 →
        提供准备清单 →
        指导提交流程 →
        说明审核标准
```

## 文档内容概览

### SKILL.md (主文件)
- 快速开始指南
- 核心工作流程
- 配置生成向导
- 部署命令序列
- 最佳实践清单
- 常见问题解答

### references/manifest-spec.md (800+ 行)
- 完整的字段规范
- Application/Services 配置详解
- 路由、健康检查、本地化配置
- 多个完整示例

### references/build-spec.md (550+ 行)
- 构建脚本编写
- Devshell 开发环境
- 依赖管理
- 自定义镜像
- Compose override

### references/route-patterns.md (600+ 行)
- file:// / exec:// / http:// 三种路由
- APP Proxy 高级用法
- 路由优先级规则
- 常见路由模式
- 故障排查指南

### references/docker-migration.md (750+ 行)
- 单容器应用迁移
- Docker Compose 迁移
- 参数映射对照表
- 存储路径转换
- 完整迁移案例（GitLab、WordPress 等）

### references/deploy-params.md (550+ 行)
- 部署参数配置规范
- 参数类型详解
- Manifest 模板渲染
- 内置模板函数
- 5 个完整实战示例

### references/store-publishing.md (650+ 行)
- 开发者注册流程
- 上架前准备清单
- 多语言配置要求
- 镜像推送流程
- 审核标准详解
- 常见被拒原因及解决方案

### references/examples.md (650+ 行)
- 7 种应用类型的完整示例
- 纯静态前端（Vue/React）
- Node.js / Python / Go 应用
- 前后端分离应用
- 多服务应用（带数据库）
- VitePress 文档站点

## 统计数据

- **文件总数**: 8 个
- **总行数**: 6,077 行
- **总大小**: 约 122KB
- **示例数量**: 30+ 个完整配置示例
- **最佳实践**: 40+ 条实战经验

## 维护说明

此 skill 基于懒猫微服官方文档创建，包含以下源文档的整合：

- manifest 规范文档
- build 规范文档
- 路由配置文档
- Docker 迁移文档
- 部署参数文档
- 商店发布文档
- 各类示例教程

当官方文档更新时，请同步更新对应的 references 文件。

## 更新日志

### v1.0.0 (2026-01-05)
- 初始版本发布
- 完成 P0/P1/P2 所有功能
- 包含 8 个完整文档
- 超过 6000 行详细内容

## 许可证

本 skill 基于懒猫微服官方文档创建，仅供学习和开发使用。

## 相关链接

- [懒猫微服官方文档](https://developer.lazycat.cloud)
- [懒猫微服开发者中心](https://developer.lazycat.cloud/dev-center)
- [应用商店](https://lazycat.cloud/store)
