#!/bin/bash

# 懒猫微服部署助手 Skill 安装脚本
# 使用方法: ./install.sh

set -e

SKILL_NAME="lzc-deploy"
SKILL_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
TARGET_DIR="$HOME/.claude/skills/user/$SKILL_NAME"

echo "========================================"
echo "  懒猫微服部署助手 Skill 安装"
echo "========================================"
echo ""
echo "技能名称: $SKILL_NAME"
echo "源目录: $SKILL_DIR"
echo "目标目录: $TARGET_DIR"
echo ""

# 检查 Claude 技能目录是否存在
if [ ! -d "$HOME/.claude/skills/user" ]; then
    echo "错误: Claude 用户技能目录不存在"
    echo "请确保已安装 Claude Code"
    exit 1
fi

# 检查是否已安装
if [ -e "$TARGET_DIR" ]; then
    echo "警告: 检测到已安装的 $SKILL_NAME skill"
    echo ""
    read -p "是否覆盖安装？(y/N): " -n 1 -r
    echo ""
    if [[ ! $REPLY =~ ^[Yy]$ ]]; then
        echo "取消安装"
        exit 0
    fi

    # 删除已存在的链接或目录
    rm -rf "$TARGET_DIR"
    echo "已删除旧版本"
fi

# 创建符号链接
echo "正在创建符号链接..."
ln -s "$SKILL_DIR" "$TARGET_DIR"

# 验证安装
if [ -L "$TARGET_DIR" ] && [ -e "$TARGET_DIR" ]; then
    echo ""
    echo "✅ 安装成功！"
    echo ""
    echo "📁 文件列表:"
    ls -lh "$TARGET_DIR"
    echo ""
    echo "📚 参考文档:"
    ls -lh "$TARGET_DIR/references"
    echo ""
    echo "🚀 使用方法:"
    echo "   在 Claude Code 中直接询问懒猫微服部署相关问题，"
    echo "   AI 助手会自动调用此 skill 提供帮助。"
    echo ""
    echo "📖 详细说明请查看 README.md"
else
    echo ""
    echo "❌ 安装失败"
    echo "请检查权限或手动安装"
    exit 1
fi
