# 部署参数配置指南

## 概述

`lzc-deploy-params.yml` 允许开发者定义用户在安装应用时需要填写的自定义参数，这些参数可以在 `lzc-manifest.yml` 中通过模板变量引用，实现应用配置的动态化。

**适用场景**:
- 允许用户自定义管理员账号密码
- 配置可选的外部服务地址
- 动态设置端口号
- 自定义应用行为

**系统要求**:
- lzc-cli >= 1.3.7
- lzc-os >= 1.3.8

## 目录

- [配置文件规范](#配置文件规范)
- [参数类型详解](#参数类型详解)
- [Manifest 模板渲染](#manifest-模板渲染)
- [实战示例](#实战示例)
- [调试技巧](#调试技巧)

---

## 配置文件规范

### 文件结构

**lzc-deploy-params.yml**:

```yaml
# 部署参数列表
params:
  - id: admin_username
    type: string
    name: "管理员用户名"
    description: "用于登录管理后台的用户名"
    default_value: "admin"
    optional: false

  - id: admin_password
    type: string
    name: "管理员密码"
    description: "用于登录管理后台的密码"
    optional: false

# 国际化配置（可选）
locales:
  en:
    params:
      admin_username:
        name: "Admin Username"
        description: "Username for admin login"
      admin_password:
        name: "Admin Password"
        description: "Password for admin login"
```

### DeployParams 字段

| 字段名 | 类型 | 描述 |
|--------|------|------|
| `params` | []DeployParam | 部署参数列表 |
| `locales` | map | 国际化配置 |

### DeployParam 字段

| 字段名 | 类型 | 描述 |
|--------|------|------|
| `id` | string | 参数唯一标识（用于在 manifest 中引用） |
| `type` | string | 参数类型（`bool`, `string`, `lzc_uid`） |
| `name` | string | 参数显示名称 |
| `description` | string | 参数详细说明 |
| `optional` | bool | 是否可选（为 true 时用户可不填） |
| `default_value` | string | 默认值 |
| `hidden` | bool | 是否隐藏（隐藏的参数依然生效但不在界面显示） |

---

## 参数类型详解

### 1. string 类型

用于文本输入。

```yaml
params:
  - id: app_title
    type: string
    name: "应用标题"
    description: "显示在页面顶部的标题"
    default_value: "My Application"
    optional: true
```

**使用场景**:
- 用户名、密码
- API 地址
- 自定义文本

### 2. bool 类型

用于布尔值选择（是/否）。

```yaml
params:
  - id: enable_ssl
    type: bool
    name: "启用 SSL"
    description: "是否启用 HTTPS 加密连接"
    default_value: "true"
    optional: true
```

**使用场景**:
- 功能开关
- 特性启用/禁用

### 3. lzc_uid 类型

用于选择懒猫微服用户。

```yaml
params:
  - id: admin_user
    type: lzc_uid
    name: "管理员"
    description: "选择一个用户作为应用管理员"
    optional: false
```

**使用场景**:
- 指定应用管理员
- 设置文件所有者
- 权限分配

---

## Manifest 模板渲染

### 渲染流程

1. 用户安装应用时，系统读取 `lzc-deploy-params.yml`
2. 显示参数填写界面，收集用户输入
3. 使用 Go `text/template` 渲染 `lzc-manifest.yml`
4. 将最终 manifest 保存到 `/lzcapp/run/manifest.yml`

### 模板语法

基于 [Go text/template](https://pkg.go.dev/text/template) 和 [Sprig 函数库](https://masterminds.github.io/sprig/)。

### 模板参数

| 参数 | 简写 | 描述 |
|------|------|------|
| `.UserParams` | `.U` | 用户填写的部署参数 |
| `.SysParams` | `.S` | 系统参数 |

#### .UserParams (.U)

用户在 `lzc-deploy-params.yml` 中定义的参数。

```yaml
# lzc-deploy-params.yml
params:
  - id: admin_username
    type: string
  - id: listen.port
    type: string
```

**在 manifest 中引用**:
```yaml
# lzc-manifest.yml
environment:
  - ADMIN_USER={{ .U.admin_username }}
  - PORT={{ index .U "listen.port" }}  # 带点号的 ID 需要用 index
```

#### .SysParams (.S)

系统提供的参数。

| 字段 | 描述 | 示例 |
|------|------|------|
| `.S.BoxName` | 微服名称 | `"my-lazycat"` |
| `.S.BoxDomain` | 微服域名 | `"mybox.heiyu.space"` |
| `.S.OSVersion` | 系统版本 | `"v1.4.0"` |
| `.S.AppDomain` | 应用域名 | `"myapp.mybox.heiyu.space"` |
| `.S.IsMultiInstance` | 是否多实例 | `true` / `false` |
| `.S.DeployUID` | 部署用户 ID（多实例） | `"1001"` |
| `.S.DeployID` | 实例 ID | `"abc123"` |

**示例**:
```yaml
environment:
  - APP_URL=https://{{ .S.AppDomain }}
  - BOX_NAME={{ .S.BoxName }}
```

### 内置模板函数

#### 1. Sprig 函数

支持所有 [Sprig 函数](https://masterminds.github.io/sprig/)（除 env 相关）。

常用函数:
- `upper` - 转大写
- `lower` - 转小写
- `substr` - 截取字符串
- `default` - 设置默认值
- `trim` - 去除空格

#### 2. stable_secret 函数

生成稳定的随机密码。

**语法**: `{{ stable_secret "seed" }}`

**特性**:
- 同样的 seed，不同应用结果不同
- 同样的 seed，同样应用在同一微服上结果始终相同
- 同样的 seed，不同微服结果不同

**示例**:
```yaml
environment:
  - MYSQL_ROOT_PASSWORD={{ stable_secret "mysql_root" }}
  - REDIS_PASSWORD={{ stable_secret "redis_pass" | substr 0 16 }}  # 限制长度
```

---

## 实战示例

### 示例 1: 可配置的管理员账号

**lzc-deploy-params.yml**:
```yaml
params:
  - id: admin_username
    type: string
    name: "管理员用户名"
    description: "用于登录后台的用户名"
    default_value: "admin"
    optional: false

  - id: admin_password
    type: string
    name: "管理员密码"
    description: "至少 8 位，包含字母和数字"
    optional: false

  - id: admin_email
    type: string
    name: "管理员邮箱"
    description: "接收通知的邮箱地址"
    default_value: "admin@example.com"
    optional: true
```

**lzc-manifest.yml**:
```yaml
lzc-sdk-version: '0.1'
package: com.example.cms
version: 1.0.0
name: My CMS

application:
  subdomain: cms
  routes:
    - /=http://app:80

  environment:
    - ADMIN_USERNAME={{ .U.admin_username }}
    - ADMIN_PASSWORD={{ .U.admin_password }}
    - ADMIN_EMAIL={{ .U.admin_email | default "admin@example.com" }}

services:
  app:
    image: my-cms:latest
```

### 示例 2: 动态端口配置

**lzc-deploy-params.yml**:
```yaml
params:
  - id: target
    type: string
    name: "目标 IP"
    description: "要转发的目标 IP 地址"

  - id: listen.port
    type: string
    name: "监听端口"
    description: "转发器监听的端口（不能是 80, 81）"
    default_value: "33"
    optional: true
```

**lzc-manifest.yml**:
```yaml
package: org.snyh.netmap
version: 0.0.1
name: Network Mapper

application:
  subdomain: netmap

  upstreams:
    - location: /
      backend: http://127.0.0.1:{{ index .U "listen.port" }}
      backend_launch_command: /lzcapp/pkg/content/netmap -target={{ .U.target }} -port={{ index .U "listen.port" }}
```

**注意**: 参数 ID 包含点号时，必须使用 `index .U "param.id"` 语法。

### 示例 3: 外部数据库配置

**lzc-deploy-params.yml**:
```yaml
params:
  - id: use_external_db
    type: bool
    name: "使用外部数据库"
    description: "是否使用外部数据库而非内置数据库"
    default_value: "false"
    optional: true

  - id: db_host
    type: string
    name: "数据库地址"
    description: "外部数据库的主机地址"
    optional: true

  - id: db_port
    type: string
    name: "数据库端口"
    default_value: "5432"
    optional: true

  - id: db_name
    type: string
    name: "数据库名称"
    optional: true

  - id: db_user
    type: string
    name: "数据库用户"
    optional: true

  - id: db_password
    type: string
    name: "数据库密码"
    optional: true
```

**lzc-manifest.yml**:
```yaml
application:
  environment:
    {{ if eq .U.use_external_db "true" }}
    - DB_HOST={{ .U.db_host }}
    - DB_PORT={{ .U.db_port }}
    - DB_NAME={{ .U.db_name }}
    - DB_USER={{ .U.db_user }}
    - DB_PASSWORD={{ .U.db_password }}
    {{ else }}
    - DB_HOST=postgres
    - DB_PORT=5432
    - DB_NAME=myapp
    - DB_USER=myapp
    - DB_PASSWORD={{ stable_secret "db_password" }}
    {{ end }}

services:
  {{ if ne .U.use_external_db "true" }}
  postgres:
    image: postgres:15
    environment:
      - POSTGRES_PASSWORD={{ stable_secret "db_password" }}
    binds:
      - /lzcapp/var/postgres:/var/lib/postgresql/data
  {{ end }}
```

### 示例 4: 多实例与单实例不同配置

**lzc-manifest.yml**:
```yaml
services:
  app:
    binds:
      {{ if .S.IsMultiInstance }}
      # 多实例：数据存储在应用内部
      - /lzcapp/var/data:/app/data
      {{ else }}
      # 单实例：数据存储在用户文稿目录
      - /lzcapp/run/mnt/home/{{ .S.DeployUID }}/appdata:/app/data
      {{ end }}
```

### 示例 5: 完整的参数化应用

**lzc-deploy-params.yml**:
```yaml
params:
  # 基础配置
  - id: app_name
    type: string
    name: "应用名称"
    description: "显示在页面顶部的应用名称"
    default_value: "My App"
    optional: true

  # 管理员配置
  - id: admin_user
    type: lzc_uid
    name: "管理员"
    description: "选择一个用户作为应用管理员"
    optional: false

  # 功能开关
  - id: enable_api
    type: bool
    name: "启用 API"
    description: "是否启用外部 API 访问"
    default_value: "true"
    optional: true

  # 高级配置
  - id: max_upload_size
    type: string
    name: "最大上传大小"
    description: "单个文件最大上传大小（MB）"
    default_value: "100"
    optional: true

# 国际化
locales:
  en:
    params:
      app_name:
        name: "Application Name"
        description: "Name displayed at the top of the page"
      admin_user:
        name: "Administrator"
        description: "Select a user as application administrator"
```

**lzc-manifest.yml**:
```yaml
lzc-sdk-version: '0.1'
package: com.example.myapp
version: 1.0.0
name: {{ .U.app_name | default "My App" }}

application:
  subdomain: myapp

  routes:
    - /=file:///lzcapp/pkg/content/dist
    {{ if eq .U.enable_api "true" }}
    - /api/=http://127.0.0.1:3000/api/
    {{ end }}

  environment:
    - APP_NAME={{ .U.app_name }}
    - ADMIN_UID={{ .U.admin_user }}
    - MAX_UPLOAD_SIZE={{ .U.max_upload_size }}M
    - API_ENABLED={{ .U.enable_api }}
```

---

## 调试技巧

### 1. 查看所有可用变量

在 manifest 中添加调试字段:

```yaml
# lzc-manifest.yml
xx-debug: {{ . }}
```

安装后查看渲染结果:
```bash
lzc-cli docker exec -it <container> cat /lzcapp/run/manifest.yml
```

### 2. 查看最终 manifest

方式 1: 在路由中暴露
```yaml
application:
  routes:
    - /debug-manifest=file:///lzcapp/run/manifest.yml
```

访问: `https://myapp.xxx.heiyu.space/debug-manifest`

方式 2: 进入容器查看
```bash
lzc-cli project devshell
cat /lzcapp/run/manifest.yml
```

### 3. 测试模板语法

使用在线 Go template 工具测试语法:
- https://gotemplate.io/

### 4. 调试条件语句

```yaml
# 输出变量值
xx-debug-value: {{ .U.use_external_db }}

# 测试条件
xx-debug-condition: {{ if eq .U.use_external_db "true" }}External DB{{ else }}Internal DB{{ end }}
```

---

## 最佳实践

### 1. 参数命名

**使用有意义的 ID**:
```yaml
# ✅ 清晰
- id: admin_username
- id: database_host

# ❌ 不清晰
- id: param1
- id: config_a
```

### 2. 提供默认值

```yaml
params:
  - id: port
    type: string
    default_value: "3000"  # 提供合理的默认值
    optional: true
```

### 3. 添加详细说明

```yaml
params:
  - id: api_key
    name: "API 密钥"
    description: "从 https://example.com/settings 获取的 API 密钥，用于访问外部服务"
```

### 4. 参数分组

虽然配置文件不支持分组，但可以通过命名约定组织:

```yaml
params:
  # 基础配置
  - id: app_name
  - id: app_description

  # 管理员配置
  - id: admin_username
  - id: admin_password
  - id: admin_email

  # 数据库配置
  - id: db_host
  - id: db_port
  - id: db_name
```

### 5. 可选参数默认值

```yaml
environment:
  - PORT={{ .U.port | default "3000" }}
  - HOST={{ .U.host | default "0.0.0.0" }}
```

### 6. 参数验证

在应用启动脚本中验证参数:

```bash
#!/bin/sh

# 验证必填参数
if [ -z "$ADMIN_USERNAME" ]; then
    echo "Error: ADMIN_USERNAME is required"
    exit 1
fi

# 验证格式
if ! echo "$ADMIN_EMAIL" | grep -E '^[^@]+@[^@]+\.[^@]+$'; then
    echo "Error: Invalid email format"
    exit 1
fi
```

---

## 常见问题

### 1. 参数未生效

**问题**: 在 manifest 中引用参数但值为空

**排查**:
1. 确认 lzc-deploy-params.yml 已打包到 lpk
2. 检查参数 ID 是否正确
3. 查看渲染后的 manifest: `cat /lzcapp/run/manifest.yml`

### 2. 模板语法错误

**问题**: 应用安装失败，提示模板错误

**常见错误**:

```yaml
# ❌ 错误：点号参数未用 index
- PORT={{ .U.listen.port }}

# ✅ 正确
- PORT={{ index .U "listen.port" }}
```

### 3. 条件判断不生效

**问题**: if 条件总是执行或总是不执行

**原因**: bool 类型参数实际是字符串

**解决**:
```yaml
# ✅ 正确：与字符串比较
{{ if eq .U.enable_feature "true" }}

# ❌ 错误：直接使用
{{ if .U.enable_feature }}
```

### 4. 多实例参数隔离

**问题**: 多实例应用如何隔离参数

**说明**: 多实例应用下，每个用户的部署参数是独立的，由各用户自行填写。

---

## 完整示例项目

参考官方示例: https://gitee.com/lazycatcloud/netmap

---

## 相关文档

- [Manifest 完整规范](./manifest-spec.md)
- [Manifest 渲染机制](https://developer.lazycat.cloud/advanced-manifest-render.html)
- [Go text/template 文档](https://pkg.go.dev/text/template)
- [Sprig 函数库](https://masterminds.github.io/sprig/)
