# 应用商店发布指南

## 概述

本文档详细介绍如何将应用发布到懒猫微服应用商店，包括开发者注册、上架准备、审核要求和常见问题。

## 目录

- [开发者注册](#开发者注册)
- [上架前准备清单](#上架前准备清单)
- [多语言配置要求](#多语言配置要求)
- [镜像推送流程](#镜像推送流程)
- [提交审核步骤](#提交审核步骤)
- [审核标准](#审核标准)
- [常见被拒原因](#常见被拒原因)
- [更新已上架应用](#更新已上架应用)

---

## 开发者注册

### 步骤 1: 注册社区账号

访问 [懒猫微服登录页](https://lazycat.cloud/login?redirect=https://developer.lazycat.cloud/) 注册账号。

### 步骤 2: 申请开发者权限

1. 访问 [开发者中心](https://developer.lazycat.cloud/manage)
2. 根据界面引导提交开发者申请
3. 等待审核（建议联系客服加快审核）

### 步骤 3: 联系方式

- 客服群: 在官网查看
- [联系我们](https://lazycat.cloud/about?navtype=AfterSalesService)

---

## 上架前准备清单

在提交应用前，请确保完成以下所有项目：

### ✅ 必备资料

- [ ] 应用图标（PNG 格式，512x512 或 1024x1024）
- [ ] 应用名称（简洁易懂）
- [ ] 应用描述（清晰说明功能）
- [ ] 应用截图（至少 1 张，展示主要功能）
- [ ] 版本号（遵循语义化版本）
- [ ] 多语言配置（至少中文 + 英文）

### ✅ 技术要求

- [ ] 所有镜像已推送到官方仓库
- [ ] manifest 中的镜像地址使用官方仓库格式
- [ ] 应用可以正常安装
- [ ] 应用可以正常启动和加载
- [ ] 健康检查配置正确
- [ ] 数据持久化配置正确

### ✅ 功能测试

- [ ] 应用安装成功
- [ ] 首次启动时间 < 5 分钟
- [ ] 主要功能正常运行
- [ ] 无严重崩溃或闪退
- [ ] 数据在重启后不丢失
- [ ] 环境变量生效
- [ ] 路由配置正确

### ✅ 特殊场景（如适用）

- [ ] 硬件搭配应用已在真实硬件上测试
- [ ] 更新提示不影响正常使用
- [ ] 应用场景对用户有实际价值

---

## 多语言配置要求

### 为什么需要多语言

懒猫微服面向全球用户，商店应用**必须支持至少两种语言**（中文 + 英文）。

### 配置方法

在 `lzc-manifest.yml` 中添加 `locales` 配置：

```yaml
lzc-sdk-version: '0.1'
package: cloud.lazycat.app.myapp
version: 1.0.0
name: My Application
description: A great application
usage: Please configure admin password on first run

# 多语言配置
locales:
  zh:
    name: "我的应用"
    description: "一个很棒的应用"
    usage: "首次运行请配置管理员密码"

  zh_CN:
    name: "我的应用"
    description: "一个很棒的应用"
    usage: "首次运行请配置管理员密码"

  en:
    name: "My Application"
    description: "A great application"
    usage: "Please configure admin password on first run"

  ja:
    name: "私のアプリケーション"
    description: "素晴らしいアプリケーション"
    usage: "初回実行時に管理者パスワードを設定してください"

application:
  subdomain: myapp
```

### 支持的语言代码

遵循 [BCP 47 标准](https://en.wikipedia.org/wiki/IETF_language_tag)：

| 语言 | 代码 |
|------|------|
| 中文（通用） | `zh` |
| 简体中文 | `zh_CN` |
| 繁体中文（台湾） | `zh_TW` |
| 繁体中文（香港） | `zh_HK` |
| 英文 | `en` |
| 英文（美国） | `en_US` |
| 英文（英国） | `en_GB` |
| 日文 | `ja` |
| 韩文 | `ko` |
| 法文 | `fr` |
| 德文 | `de` |
| 西班牙文 | `es` |

### 最低要求

```yaml
locales:
  zh_CN:
    name: "中文名称"
    description: "中文描述"

  en:
    name: "English Name"
    description: "English Description"
```

### 完整示例

```yaml
lzc-sdk-version: '0.1'
package: cloud.lazycat.app.netatalk
version: 0.0.1
name: Apple 时间机器备份
description: Netatalk 服务可用于 Apple 时间机器备份
author: Netatalk

locales:
  zh:
    name: "Apple 时间机器备份"
    description: "Netatalk 服务可用于 Apple 时间机器备份"

  zh_CN:
    name: "Apple 时间机器备份"
    description: "Netatalk 服务可用于 Apple 时间机器备份"

  en:
    name: "Time Machine Server"
    description: "Netatalk service can be used for Apple Time Machine backup"

  ja:
    name: "タイムマシンサーバー"
    description: "Netatalk サービスは Apple Time Machine のバックアップに使用できます"

application:
  subdomain: netatalk3
```

---

## 镜像推送流程

### 为什么要推送到官方仓库

Docker Hub 在国内网络质量不稳定，官方仓库提供：
- 稳定的国内访问速度
- 镜像版本锁定（使用 IMAGE_ID 作为 tag）
- 自动垃圾回收

### 推送命令

```bash
lzc-cli appstore copy-image <公网可访问的镜像名称>
```

### 推送示例

```bash
# 推送官方镜像
$ lzc-cli appstore copy-image alpine:3.18
Waiting ... ( copy alpine:3.18 to lazycat official registry)
lazycat-registry: registry.lazycat.cloud/snyh1010/library/alpine:d3b83042301e01a4

# 推送自定义镜像
$ lzc-cli appstore copy-image myapp:1.0.0
lazycat-registry: registry.lazycat.cloud/yourname/myapp:abc123def456
```

### 更新 manifest

推送成功后，使用返回的镜像地址更新 manifest：

**推送前**:
```yaml
services:
  app:
    image: myapp:1.0.0  # 本地镜像
```

**推送后**:
```yaml
services:
  app:
    image: registry.lazycat.cloud/yourname/myapp:abc123def456  # 官方仓库镜像
```

### 使用限制

1. **版本锁定**: tag 会替换为 IMAGE_ID，每次 copy-image 都会重新 pull
2. **公网可访问**: 必须是公网可访问的镜像（本地镜像无法推送）
3. **自动清理**: 未被商店应用引用的镜像会被定期清理
4. **访问限速**: 官方仓库仅供微服内部使用，外部访问会被限速

### 常见镜像推送

```bash
# 数据库
lzc-cli appstore copy-image postgres:15
lzc-cli appstore copy-image mysql:8
lzc-cli appstore copy-image redis:7-alpine

# Web 服务器
lzc-cli appstore copy-image nginx:alpine
lzc-cli appstore copy-image httpd:alpine

# 应用
lzc-cli appstore copy-image wordpress:6.0
lzc-cli appstore copy-image nextcloud:latest
```

---

## 提交审核步骤

### 方式: 使用 lzc-cli 提交

**要求**: lzc-cli >= 1.2.54

#### 步骤 1: 构建应用包

```bash
lzc-cli project build -o myapp.lpk
```

#### 步骤 2: 提交审核

```bash
lzc-cli appstore publish ./myapp.lpk
```

#### 输出示例

```
Uploading myapp.lpk...
Upload successful!
Application submitted for review.
Review ID: #12345
You can check the review status in the developer center.
```

#### 步骤 3: 等待审核

1. 访问 [开发者中心](https://developer.lazycat.cloud/manage)
2. 查看审核状态
3. 如有问题，审核人员会提供反馈

---

## 审核标准

### 1. 应用资料完备性 ✅

**要求**:
- 应用 logo（PNG 格式）
- 应用名称（清晰易懂）
- 应用描述（准确说明功能）
- 应用截图（展示主要功能）
- 多语言配置（至少中英文）

**检查清单**:
```yaml
# lzc-manifest.yml
name: My App  # ✅ 有名称
description: A powerful tool  # ✅ 有描述

locales:
  zh_CN:  # ✅ 中文
    name: "我的应用"
  en:     # ✅ 英文
    name: "My App"
```

```yaml
# lzc-build.yml
icon: ./lzc-icon.png  # ✅ 有图标
```

### 2. 可安装与可加载性 ✅

**要求**:
- 应用能正常安装
- 安装后能正常加载
- 加载后有响应

**常见问题**:
- 镜像拉取失败 → 确保已推送到官方仓库
- 健康检查失败 → 调整 start_period 或检查服务启动
- 依赖无法访问 → 检查网络配置

**测试方法**:
```bash
# 本地测试
lzc-cli app install myapp.lpk

# 查看日志
lzc-cli docker logs -f <container-name>

# 检查健康状态
lzc-cli docker ps
```

### 3. 应用质量稳定性 ✅

**要求**:
- 无严重崩溃
- 无频繁闪退
- 主要功能可用

**检查清单**:
- [ ] 应用可以正常打开
- [ ] 主要功能正常运行
- [ ] 无明显错误提示
- [ ] 多次操作不崩溃

### 4. 速度指标 ✅

**要求**:
- 启动速度 < 5 分钟
- 响应时间合理

**优化建议**:
```yaml
# 增加健康检查启动等待时间
health_check:
  start_period: 120s  # 给大型应用足够时间

# 使用更小的镜像
services:
  app:
    image: nginx:alpine  # alpine 版本更小
```

### 5. 特殊场景适配性 ✅

#### 硬件搭配类应用

**要求**:
- 必须在真实硬件环境测试
- 提供硬件型号信息
- 说明测试结果

**示例**: USB 设备应用

```yaml
application:
  usb_accel: true  # 挂载 USB 设备

# 在说明中注明支持的设备型号
description: 支持 CH340/CP2102 USB 转串口设备
```

#### 更新提示合理性

**要求**:
- 更新提示不能严重影响使用
- 如无法完成应用内更新，建议去掉提示

**不推荐**:
```
[更新弹窗]
新版本 2.0 已发布！
[立即更新] [取消]
每次打开都弹出，无法关闭
```

**推荐**:
```
[顶部通知栏]
新版本可用
[查看详情] [忽略]
可以关闭，不影响使用
```

### 6. 应用场景有效性 ✅

**要求**:
- 应用对用户有实际价值
- 不允许上架开发库、中间件

**允许上架**:
- ✅ 实用工具（文件管理、编辑器）
- ✅ 内容管理（博客、CMS）
- ✅ 协作工具（Wiki、项目管理）
- ✅ 娱乐应用（游戏、媒体）

**不允许上架**:
- ❌ 开发库（如 Node.js、Python）
- ❌ 中间件（如 Redis、RabbitMQ）（除非作为完整应用的一部分）
- ❌ 纯命令行工具

**工具类应用要求**:
需要和懒猫网盘的文件类型关联：

```yaml
application:
  file_handler:
    mime:
      - application/pdf
      - image/jpeg
    actions:
      open: /?file=%u
```

### 7. 应用数据持久化 ✅

**要求**:
- 重要数据必须持久化
- 重启后数据不丢失
- 升级后数据保留

**检查清单**:
```yaml
services:
  app:
    binds:
      # ✅ 数据库文件持久化
      - /lzcapp/var/mysql:/var/lib/mysql

      # ✅ 用户上传文件持久化
      - /lzcapp/var/uploads:/app/uploads

      # ✅ 配置文件持久化
      - /lzcapp/var/config:/app/config
```

**测试方法**:
1. 安装应用
2. 创建一些测试数据
3. 重启应用
4. 验证数据是否还在

**升级注意事项**:
- 不要轻易改变 `multi_instance` 配置（会导致存储路径变更）
- 如需改变实例模式，必须提供数据迁移方案

---

## 常见被拒原因

### 1. 缺少多语言配置 ❌

**问题**: 只有中文，没有英文

**解决方案**:
```yaml
locales:
  zh_CN:
    name: "我的应用"
    description: "应用描述"
  en:  # 必须添加
    name: "My App"
    description: "App description"
```

### 2. 镜像未推送到官方仓库 ❌

**问题**: manifest 中使用 Docker Hub 或本地镜像

**错误示例**:
```yaml
services:
  app:
    image: myapp:latest  # ❌ 本地镜像
    image: docker.io/myapp:1.0  # ❌ Docker Hub
```

**解决方案**:
```bash
# 推送镜像
lzc-cli appstore copy-image myapp:1.0

# 使用官方仓库地址
image: registry.lazycat.cloud/yourname/myapp:abc123
```

### 3. 应用无法安装或启动 ❌

**常见原因**:
- 镜像拉取失败
- 健康检查配置不当
- 依赖服务未就绪

**解决方案**:
```yaml
# 增加启动等待时间
health_check:
  start_period: 120s

# 配置服务依赖
services:
  app:
    depends_on:
      - mysql

  mysql:
    healthcheck:
      test: ["CMD", "mysqladmin", "ping"]
      interval: 10s
```

### 4. 缺少应用图标 ❌

**解决方案**:
```yaml
# lzc-build.yml
icon: ./lzc-icon.png  # PNG 格式，512x512 或 1024x1024
```

### 5. 数据持久化问题 ❌

**问题**: 重启后数据丢失

**解决方案**:
```yaml
services:
  app:
    binds:
      - /lzcapp/var/data:/app/data  # 确保重要数据绑定到 /lzcapp/var
```

### 6. 应用场景不明确 ❌

**问题**: 应用描述不清楚，审核人员不知道用途

**解决方案**:
```yaml
name: My Tool
description: 一个强大的工具  # ❌ 太模糊

# 改为
name: Markdown Editor
description: 在线 Markdown 编辑器，支持实时预览和导出 PDF  # ✅ 清晰
```

### 7. 启动时间过长 ❌

**问题**: 应用启动超过 5 分钟

**优化方案**:
- 使用更小的基础镜像（Alpine）
- 优化依赖安装（使用缓存）
- 调整健康检查配置

---

## 更新已上架应用

### 更新流程

1. **修改版本号**:
```yaml
# lzc-manifest.yml
version: 1.0.1  # 从 1.0.0 更新到 1.0.1
```

2. **重新构建**:
```bash
lzc-cli project build -o myapp-v1.0.1.lpk
```

3. **提交更新**:
```bash
lzc-cli appstore publish ./myapp-v1.0.1.lpk
```

### 更新注意事项

**版本号规则**:
- 重大更新: 增加主版本号（1.0.0 → 2.0.0）
- 新增功能: 增加次版本号（1.0.0 → 1.1.0）
- 修复 Bug: 增加修订号（1.0.0 → 1.0.1）

**数据兼容性**:
- 确保新版本能读取旧版本的数据
- 如有数据迁移，提供自动迁移脚本
- 在 `usage` 字段中说明更新注意事项

**测试更新**:
```bash
# 1. 安装旧版本
lzc-cli app install myapp-v1.0.0.lpk

# 2. 创建测试数据

# 3. 卸载旧版本
lzc-cli app uninstall com.example.myapp

# 4. 安装新版本
lzc-cli app install myapp-v1.0.1.lpk

# 5. 验证数据是否保留
```

---

## 审核周期

- 首次提交: 1-3 个工作日
- 更新提交: 1-2 个工作日
- 紧急修复: 联系客服加急处理

---

## 联系支持

### 获取帮助

- [开发者中心](https://developer.lazycat.cloud)
- [应用商店](https://appstore.lazycat.cloud)
- [社区论坛](https://lazycat.cloud/playground)
- [联系我们](https://lazycat.cloud/about?navtype=AfterSalesService)

### 常见问题快速链接

- [如何注册开发者](https://developer.lazycat.cloud/publish-app.html)
- [镜像推送说明](https://developer.lazycat.cloud/publish-app.html#推送镜像到官方仓库)
- [审核指南](https://developer.lazycat.cloud/store-submission-guide.html)

---

## 检查清单（发布前）

打印此清单，逐项确认：

### 基础配置
- [ ] Package ID 全球唯一
- [ ] 版本号遵循语义化版本
- [ ] 应用名称清晰易懂
- [ ] 应用描述准确完整
- [ ] 提供应用图标（PNG）
- [ ] 提供应用截图

### 多语言
- [ ] 配置中文（zh_CN）
- [ ] 配置英文（en）
- [ ] name 字段已翻译
- [ ] description 字段已翻译

### 镜像
- [ ] 所有镜像已推送到官方仓库
- [ ] manifest 中使用官方仓库地址
- [ ] 镜像 tag 使用 hash 版本

### 功能测试
- [ ] 本地安装成功
- [ ] 应用可以正常启动
- [ ] 首次启动 < 5 分钟
- [ ] 主要功能正常
- [ ] 无严重错误或崩溃

### 数据持久化
- [ ] 重要数据绑定到 /lzcapp/var
- [ ] 重启后数据不丢失
- [ ] 健康检查配置正确

### 高级功能（如适用）
- [ ] 硬件功能已测试
- [ ] 文件类型关联配置
- [ ] 多实例配置正确
- [ ] 部署参数配置正确

### 提交
- [ ] 运行 `lzc-cli project build`
- [ ] 运行 `lzc-cli appstore publish`
- [ ] 在开发者中心查看状态

---

## 相关文档

- [Manifest 完整规范](./manifest-spec.md)
- [应用配置示例](./examples.md)
- [Docker 迁移指南](./docker-migration.md)
- [构建配置规范](./build-spec.md)
