#!/bin/bash

# 懒猫微服部署助手 Skill 卸载脚本
# 使用方法: ./uninstall.sh

set -e

SKILL_NAME="lzc-deploy"
TARGET_DIR="$HOME/.claude/skills/user/$SKILL_NAME"

echo "========================================"
echo "  懒猫微服部署助手 Skill 卸载"
echo "========================================"
echo ""
echo "技能名称: $SKILL_NAME"
echo "目标目录: $TARGET_DIR"
echo ""

# 检查是否已安装
if [ ! -e "$TARGET_DIR" ]; then
    echo "未检测到已安装的 $SKILL_NAME skill"
    exit 0
fi

# 确认卸载
read -p "确定要卸载吗？(y/N): " -n 1 -r
echo ""
if [[ ! $REPLY =~ ^[Yy]$ ]]; then
    echo "取消卸载"
    exit 0
fi

# 删除链接或目录
rm -rf "$TARGET_DIR"

# 验证卸载
if [ ! -e "$TARGET_DIR" ]; then
    echo ""
    echo "✅ 卸载成功！"
else
    echo ""
    echo "❌ 卸载失败"
    echo "请手动删除: $TARGET_DIR"
    exit 1
fi
