# 中日共用漢字處理

處理 macOS 字典返回中文結果而非日文結果的情況。

## 目錄

1. [問題說明](#問題說明)
2. [識別中文結果](#識別中文結果)
3. [處理策略](#處理策略)
4. [常見中日共用漢字](#常見中日共用漢字)

---

## 問題說明

許多漢字詞彙在中文和日文中都存在（如「勉強」「大丈夫」「人参」），macOS 字典可能優先返回中文結果。

---

## 識別中文結果

當 `--raw` 輸出包含以下特徵時，為**中文字典**結果：

| 特徵 | 範例 |
|------|------|
| 注音符號 | ㄅㄆㄇ |
| 拼音標記 | miǎn qiǎng |
| 倉頡碼 | 弓山大尸 |
| 繁體中文解釋風格 | 「勉強」：勉為其難 |

---

## 處理策略

### 步驟 1：判斷用戶意圖

- 本專案是日文學習系統，**預設查詢日文**
- 用戶明確說「中文」或「國語」時，提供中文結果

### 步驟 2：查詢並檢查結果

1. 用 `--raw` 查詢，檢查返回的是日文還是中文
2. 如果是中文結果且用戶想查日文：

**策略 A：用假名重新查詢**

```bash
# 原查詢返回中文
uv run scripts/lookup-dictionary.py 勉強 --raw
# → 返回中文注音結果

# 改用假名
uv run scripts/lookup-dictionary.py べんきょう --raw
# → 可能返回日文結果
```

**策略 B：AI 知識補充**

如果假名查詢也無法獲得日文結果：

```
⚠️ 字典返回中文結果，以下為 AI 提供的日文解釋：

【勉強】べんきょう
詞性：名詞・サ變動詞
日文：学問や技術を学ぶこと
英文：study; learning
中文：學習、讀書
```

---

## 常見中日共用漢字

| 漢字 | 日文讀音 | 日文意思 | 中文意思 | 差異 |
|------|----------|----------|----------|------|
| 勉強 | べんきょう | 學習 | 勉強、不情願 | 意思不同 |
| 大丈夫 | だいじょうぶ | 沒問題 | 男子漢 | 意思不同 |
| 人参 | にんじん | 胡蘿蔔 | 人參 | 指不同事物 |
| 手紙 | てがみ | 信件 | 衛生紙 | 指不同事物 |
| 娘 | むすめ | 女兒 | 媽媽 | 意思相反 |
| 先生 | せんせい | 老師、醫生 | 先生（稱呼） | 用法不同 |
| 汽車 | きしゃ | 火車 | 汽車 | 指不同事物 |
| 老婆 | ろうば | 老太婆 | 妻子 | 意思不同 |
| 愛人 | あいじん | 情婦/情夫 | 配偶 | 語感差異 |
| 新聞 | しんぶん | 報紙 | 新聞 | 指不同事物 |

---

## 輸出格式

遇到中日共用漢字時，**必須**加入中日差異區塊：

```
【勉強】べんきょう

| 項目 | 內容 |
|------|------|
| 詞性 | 名詞・サ變動詞 |
| 日文 | 学問や技術を学ぶこと |
| 英文 | study; learning |
| 中文 | 學習、讀書 |

**⚠️ 中日差異**：
| 語言 | 讀音 | 意思 |
|------|------|------|
| 日文 | べんきょう | 學習、讀書 |
| 中文 | miǎn qiǎng | 勉強、不情願 |

例句：
- 日本語を勉強しています。（我正在學日文。）
```
