# 回應格式規範

本文件定義字典查詢的統一輸出格式，確保回應的一致性。

## 目錄

1. [格式總覽](#格式總覽)
2. [必須區塊](#必須區塊)
3. [可選區塊](#可選區塊)
4. [日文詞彙範例](#日文詞彙範例)
5. [英文詞彙範例](#英文詞彙範例)
6. [中文詞彙範例](#中文詞彙範例)

---

## 格式總覽

```
【{詞彙}】{讀音}

| 項目 | 內容 |
|------|------|
| 詞性 | {詞性} |
| 日文 | {日文定義} |
| 英文 | {英文定義} |
| 中文 | {中文定義} |

{可選區塊...}

例句：
- {日文例句}（{中文翻譯}）
```

---

## 必須區塊

所有詞彙查詢都**必須包含**：

| 區塊 | 說明 |
|------|------|
| 標題行 | `【詞彙】讀音` 格式 |
| 基本資訊表 | 詞性、日/英/中三語解釋 |
| 例句 | 至少 1 句，附中文翻譯 |

---

## 可選區塊

根據詞彙類型自動判斷是否需要：

### 1. 活用形（動詞、形容詞）

```
**活用形**：
| 形式 | 變化 |
|------|------|
| 辭書形 | 食べる |
| ます形 | 食べます |
| ない形 | 食べない |
| て形 | 食べて |
| た形 | 食べた |
```

### 2. 敬語形式（敬語詞彙）

```
**敬語形式**：
| 類型 | 形式 | 使用對象 |
|------|------|----------|
| 普通形 | 食べる | 一般場合 |
| 尊敬語 | 召し上がる | 對方/尊長的動作 |
| 謙讓語 | いただく | 自己的動作 |
| 丁寧語 | 食べます | 禮貌表達 |
```

### 3. 使用場景（敬語、正式用語）

```
**使用場景**：
- 餐廳接待客人
- 向上司報告
- 商務會議
```

### 4. 多義說明（多義詞）

```
**多義說明**：
| 語境 | 意思 | 例子 |
|------|------|------|
| 物理高度 | 高的 | 高い山 |
| 價格 | 貴的 | 高い時計 |
```

### 5. 中日差異（中日共用漢字）

詳見 [cjk-handling.md](cjk-handling.md)

```
**中日差異**：
| 語言 | 讀音 | 意思 |
|------|------|------|
| 日文 | べんきょう | 學習 |
| 中文 | miǎn qiǎng | 勉強 |
```

### 6. 注意事項（易錯用法）

```
**注意事項**：
- ❌ 私は召し上がります（不能對自己用尊敬語）
- ✅ 私はいただきます（自己的動作用謙讓語）
```

---

## 日文詞彙範例

### 簡單名詞

```
【本】ほん

| 項目 | 內容 |
|------|------|
| 詞性 | 名詞 |
| 日文 | 文字や絵を印刷した紙を綴じたもの |
| 英文 | book |
| 中文 | 書、書本 |

例句：
- 本を読みます。（我讀書。）
```

### 動詞（含活用）

```
【食べる】たべる

| 項目 | 內容 |
|------|------|
| 詞性 | 一段動詞（下一段） |
| 日文 | 食物を口に入れ、かんで飲み込む |
| 英文 | eat; have a meal |
| 中文 | 吃 |

**活用形**：
| 形式 | 變化 |
|------|------|
| 辭書形 | 食べる |
| ます形 | 食べます |
| ない形 | 食べない |
| て形 | 食べて |
| た形 | 食べた |

例句：
- 朝ごはんを食べます。（我吃早餐。）
```

### 敬語詞彙

```
【召し上がる】めしあがる

| 項目 | 內容 |
|------|------|
| 詞性 | 五段動詞（尊敬語） |
| 日文 | 「食べる」「飲む」の尊敬語 |
| 英文 | to eat; to drink (honorific) |
| 中文 | 吃、喝（尊敬語） |

**敬語形式**：
| 類型 | 形式 | 使用對象 |
|------|------|----------|
| 普通形 | 食べる | 一般場合 |
| 尊敬語 | 召し上がる | 對方/尊長 |
| 謙讓語 | いただく | 自己 |

**使用場景**：
- 餐廳接待：「どうぞ召し上がってください」
- 詢問上司：「召し上がりましたか」

**注意事項**：
- ❌ 私は召し上がります
- ✅ 私はいただきます

例句：
- どうぞ召し上がってください。（請慢用。）
```

### 多義形容詞

```
【高い】たかい

| 項目 | 內容 |
|------|------|
| 詞性 | い形容詞 |
| 日文 | 位置や程度が標準より上にあること |
| 英文 | high; tall; expensive |
| 中文 | 高的；貴的 |

**多義說明**：
| 語境 | 意思 | 例子 |
|------|------|------|
| 物理高度 | 高的 | 高い山 |
| 價格 | 貴的 | 高い時計 |
| 程度 | 高級的 | 品質が高い |
| 音調 | 高音的 | 高い声 |

例句：
- 富士山は高い山です。（富士山是一座高山。）
- この時計は高いですね。（這隻手錶很貴呢。）
```

---

## 英文詞彙範例

### 英翻日

```
【national debt】

| 項目 | 內容 |
|------|------|
| 詞性 | noun |
| 日文翻譯 | 国家負債、国債（こくさい） |

例句：
- The national debt has increased.（国債が増加した。）
```

### 英翻中

```
【computer】

| 項目 | 內容 |
|------|------|
| 詞性 | noun (countable) |
| 中文翻譯 | 電腦、計算機 |
| 同義詞 | PC, laptop, desktop |

例句：
- I use a computer every day.（我每天使用電腦。）
```

---

## 中文詞彙範例

```
【經濟】ㄐㄧㄥ ㄐㄧˋ

| 項目 | 內容 |
|------|------|
| 注音 | ㄐㄧㄥ ㄐㄧˋ |
| 拼音 | jīng jì |
| 詞性 | 名詞 |

**解釋**：
① 關於財貨的生產、分配、消費等事項
② 節約，以較少耗費獲得較大成果

例句：
- 經濟發展帶來許多變化。
```
