const PptxGenJS = require('pptxgenjs');

// 프레젠테이션 생성
const pptx = new PptxGenJS();

// 메타데이터 설정
pptx.author = 'Fit Checker';
pptx.title = '적합성 분석 리포트';
pptx.subject = '플랜바이테크놀로지스 x 지원자';

// 레이아웃 설정 (16:9)
pptx.defineLayout({ name: 'CUSTOM', width: 13.33, height: 7.5 });
pptx.layout = 'CUSTOM';

// 색상 팔레트
const colors = {
  primary: '2563EB',
  success: '10B981',
  warning: 'F59E0B',
  danger: 'EF4444',
  neutral: '6B7280',
  bgPrimary: 'FFFFFF',
  bgSecondary: 'F9FAFB',
  bgDark: '1E1E2E',
  textPrimary: '111827',
  textSecondary: '6B7280',
  border: 'E5E7EB'
};

// ========== 슬라이드 1: 타이틀 & 매치율 ==========
const slide1 = pptx.addSlide();
slide1.background = { color: colors.bgDark };

// 타이틀
slide1.addText('플랜바이테크놀로지스 x 지원자', {
  x: 0.5,
  y: 0.5,
  w: 12.33,
  h: 0.8,
  fontSize: 36,
  fontFace: 'Pretendard',
  bold: true,
  color: '60A5FA',
  align: 'center'
});

// 서브타이틀
slide1.addText('Front-End Engineer 적합성 분석 리포트', {
  x: 0.5,
  y: 1.3,
  w: 12.33,
  h: 0.5,
  fontSize: 20,
  fontFace: 'Pretendard',
  color: '94A3B8',
  align: 'center'
});

// 날짜
slide1.addText('2026년 1월 9일', {
  x: 0.5,
  y: 1.8,
  w: 12.33,
  h: 0.4,
  fontSize: 14,
  fontFace: 'Pretendard',
  color: '64748B',
  align: 'center'
});

// 매치율 도넛 차트
slide1.addChart(pptx.ChartType.doughnut, [
  {
    name: 'Match',
    labels: ['매치', '나머지'],
    values: [72, 28]
  }
], {
  x: 4.67,
  y: 2.3,
  w: 4,
  h: 3.5,
  chartColors: [colors.success, '374151'],
  showLegend: false,
  showTitle: false,
  holeSize: 70
});

// 매치율 텍스트 (차트 중앙)
slide1.addText('72%', {
  x: 5.67,
  y: 3.5,
  w: 2,
  h: 0.8,
  fontSize: 48,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.success,
  align: 'center'
});

slide1.addText('Match Rate', {
  x: 5.67,
  y: 4.2,
  w: 2,
  h: 0.4,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: '94A3B8',
  align: 'center'
});

// 매치율 근거 박스
slide1.addShape(pptx.ShapeType.roundRect, {
  x: 2,
  y: 5.8,
  w: 9.33,
  h: 1.5,
  fill: { color: '2D2D44' },
  line: { color: '3D3D5C', pt: 1 }
});

slide1.addText('매치율 근거', {
  x: 2.2,
  y: 5.9,
  w: 9,
  h: 0.35,
  fontSize: 14,
  fontFace: 'Pretendard',
  bold: true,
  color: 'E2E8F0'
});

slide1.addText(
  '1. 기술 스택 완벽 일치 - React, Next.js, TypeScript, AI 도구 활용이 필수 요건과 정확히 부합\n' +
  '2. 경력 요건 불일치 - 2년 이상 요구 vs 신입, 가장 큰 리스크 요인\n' +
  '3. 선호 조건 대부분 충족 - AI SaaS 도메인, B2B, 출퇴근 시간(약 18분) 모두 만족',
  {
    x: 2.2,
    y: 6.25,
    w: 8.9,
    h: 1,
    fontSize: 11,
    fontFace: 'Pretendard',
    color: 'CBD5E1',
    lineSpacing: 18
  }
);

// ========== 슬라이드 2: 잘 맞는 점 ==========
const slide2 = pptx.addSlide();
slide2.background = { color: colors.bgPrimary };

slide2.addText('잘 맞는 점', {
  x: 0.5,
  y: 0.3,
  w: 12,
  h: 0.7,
  fontSize: 28,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.success
});

// 테이블 데이터
const strengthsData = [
  [
    { text: '구분', options: { bold: true, fill: colors.primary, color: 'FFFFFF', align: 'center' } },
    { text: '회사 요구사항', options: { bold: true, fill: colors.primary, color: 'FFFFFF', align: 'center' } },
    { text: '지원자 보유 역량', options: { bold: true, fill: colors.primary, color: 'FFFFFF', align: 'center' } },
    { text: '적합도', options: { bold: true, fill: colors.primary, color: 'FFFFFF', align: 'center' } }
  ],
  [
    { text: 'React/Next.js', options: { bold: true } },
    { text: 'React/Next.js 기반 프로젝트 2년 이상' },
    { text: '3개 프로젝트 모두 Next.js + React 사용' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: 'TypeScript', options: { bold: true } },
    { text: 'TypeScript 기반 개발 경험' },
    { text: '전 프로젝트 TypeScript 기반 개발' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: 'AI 도구 활용', options: { bold: true } },
    { text: 'Claude Code, Cursor 등 AI 도구 실무 활용 (필수)' },
    { text: 'Cursor, Claude Code, Gemini 능숙' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: '상태관리/최적화', options: { bold: true } },
    { text: '상태 관리, 렌더링 최적화 이해' },
    { text: 'React Query, Zustand / TTI 93% 단축' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: '디자인 시스템', options: { bold: true } },
    { text: '디자인 시스템 고도화 (우대)' },
    { text: 'shadcn/ui, 공통 컴포넌트 15개 설계' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: '테스트', options: { bold: true } },
    { text: 'Jest, Playwright 등 (우대)' },
    { text: 'Playwright, Vitest 활용 경험' },
    { text: '완벽 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: '도메인', options: { bold: true } },
    { text: 'B2B AI SaaS (건축 디자인)' },
    { text: 'AI SaaS/Solution 선호' },
    { text: '선호 일치', options: { color: colors.success, bold: true } }
  ],
  [
    { text: '출퇴근', options: { bold: true } },
    { text: '강남구 역삼동' },
    { text: '서울대입구역 → 역삼역 약 18분' },
    { text: '40분 이하', options: { color: colors.success, bold: true } }
  ]
];

slide2.addTable(strengthsData, {
  x: 0.5,
  y: 1.1,
  w: 12.33,
  fontFace: 'Pretendard',
  fontSize: 11,
  border: { type: 'solid', pt: 0.5, color: colors.border },
  align: 'left',
  valign: 'middle',
  rowH: 0.6
});

// ========== 슬라이드 3: 맞지 않는 점 ==========
const slide3 = pptx.addSlide();
slide3.background = { color: colors.bgPrimary };

slide3.addText('맞지 않는 점', {
  x: 0.5,
  y: 0.3,
  w: 12,
  h: 0.7,
  fontSize: 28,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.danger
});

// 카드 1: 경력 요건 (Critical)
slide3.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 1.2,
  w: 6,
  h: 2.8,
  fill: { color: 'FEF2F2' },
  line: { color: colors.danger, pt: 2 }
});

slide3.addText('필수 요건', {
  x: 0.7,
  y: 1.35,
  w: 1.5,
  h: 0.35,
  fontSize: 10,
  fontFace: 'Pretendard',
  bold: true,
  color: '991B1B',
  fill: { color: 'FEE2E2' },
  align: 'center',
  valign: 'middle'
});

slide3.addText('경력 요건 불충족', {
  x: 0.7,
  y: 1.9,
  w: 5.5,
  h: 0.5,
  fontSize: 18,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide3.addText('요구사항: 2년 이상\n지원자: 신입 (0년)', {
  x: 0.7,
  y: 2.5,
  w: 5.5,
  h: 0.8,
  fontSize: 14,
  fontFace: 'Pretendard',
  color: colors.textPrimary,
  lineSpacing: 22
});

slide3.addText('가장 큰 리스크 요인 - 프로젝트 성과로 역량 증명 필요', {
  x: 0.7,
  y: 3.4,
  w: 5.5,
  h: 0.4,
  fontSize: 11,
  fontFace: 'Pretendard',
  color: colors.textSecondary,
  italic: true
});

// 카드 2: 회사 규모 (선호 조건)
slide3.addShape(pptx.ShapeType.roundRect, {
  x: 6.83,
  y: 1.2,
  w: 6,
  h: 2.8,
  fill: { color: 'FFFBEB' },
  line: { color: colors.warning, pt: 2 }
});

slide3.addText('선호 조건', {
  x: 7.03,
  y: 1.35,
  w: 1.5,
  h: 0.35,
  fontSize: 10,
  fontFace: 'Pretendard',
  bold: true,
  color: '92400E',
  fill: { color: 'FEF3C7' },
  align: 'center',
  valign: 'middle'
});

slide3.addText('회사 규모 불일치', {
  x: 7.03,
  y: 1.9,
  w: 5.5,
  h: 0.5,
  fontSize: 18,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide3.addText('지원자 선호: Series A+\n회사 현황: Seed (12명)', {
  x: 7.03,
  y: 2.5,
  w: 5.5,
  h: 0.8,
  fontSize: 14,
  fontFace: 'Pretendard',
  color: colors.textPrimary,
  lineSpacing: 22
});

slide3.addText('선호 조건은 필수가 아닙니다. 빠른 성장 중인 기술력 검증된 스타트업', {
  x: 7.03,
  y: 3.4,
  w: 5.5,
  h: 0.4,
  fontSize: 11,
  fontFace: 'Pretendard',
  color: colors.textSecondary,
  italic: true
});

// 카드 3: 스타트업 경험 (우대)
slide3.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 4.2,
  w: 6,
  h: 2.2,
  fill: { color: colors.bgSecondary },
  line: { color: colors.border, pt: 1 }
});

slide3.addText('우대 사항', {
  x: 0.7,
  y: 4.35,
  w: 1.5,
  h: 0.35,
  fontSize: 10,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textSecondary,
  fill: { color: colors.border },
  align: 'center',
  valign: 'middle'
});

slide3.addText('스타트업 초기 멤버 경험', {
  x: 0.7,
  y: 4.9,
  w: 5.5,
  h: 0.5,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide3.addText('우대: 있으면 좋음 | 지원자: 경험 없음\n기획~배포 전체 라이프사이클 경험으로 대체 가능', {
  x: 0.7,
  y: 5.4,
  w: 5.5,
  h: 0.8,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.textSecondary,
  lineSpacing: 20
});

// 카드 4: 영어 소통 (확인 필요)
slide3.addShape(pptx.ShapeType.roundRect, {
  x: 6.83,
  y: 4.2,
  w: 6,
  h: 2.2,
  fill: { color: colors.bgSecondary },
  line: { color: colors.border, pt: 1 }
});

slide3.addText('확인 필요', {
  x: 7.03,
  y: 4.35,
  w: 1.5,
  h: 0.35,
  fontSize: 10,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textSecondary,
  fill: { color: colors.border },
  align: 'center',
  valign: 'middle'
});

slide3.addText('영어 소통 역량', {
  x: 7.03,
  y: 4.9,
  w: 5.5,
  h: 0.5,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide3.addText('우대: 영어 소통 가능자 | 지원자: 확인 필요\n글로벌 고객사(CBRE) 존재. 우대 사항으로 필수 아님', {
  x: 7.03,
  y: 5.4,
  w: 5.5,
  h: 0.8,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.textSecondary,
  lineSpacing: 20
});

// ========== 슬라이드 4: 보완 포인트 ==========
const slide4 = pptx.addSlide();
slide4.background = { color: colors.bgPrimary };

slide4.addText('보완 포인트', {
  x: 0.5,
  y: 0.3,
  w: 12,
  h: 0.7,
  fontSize: 28,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.primary
});

// 항목 1: 경력 부족 (높음)
slide4.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 1.1,
  w: 12.33,
  h: 1.9,
  fill: { color: colors.bgSecondary },
  line: { color: colors.border, pt: 1 }
});

slide4.addText('높음', {
  x: 0.7,
  y: 1.25,
  w: 0.9,
  h: 0.35,
  fontSize: 11,
  fontFace: 'Pretendard',
  bold: true,
  color: '991B1B',
  fill: { color: 'FEE2E2' },
  align: 'center',
  valign: 'middle'
});

slide4.addText('경력 부족 극복 전략', {
  x: 1.8,
  y: 1.2,
  w: 10,
  h: 0.45,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide4.addText('근거: 채용 공고에서 "React/Next.js 기반 프로젝트 경험 2년 이상" 명시', {
  x: 0.7,
  y: 1.7,
  w: 11.9,
  h: 0.4,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.textSecondary
});

slide4.addText('제안: 정량적 성과 강조 - "TTI 93% 단축(8.8s→0.7s)", "TTI 60% 단축(5s→2s)" 등 구체적 수치로 역량 증명', {
  x: 0.7,
  y: 2.15,
  w: 11.9,
  h: 0.7,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.primary
});

// 항목 2: AI Agent 워크플로우 (중간)
slide4.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 3.2,
  w: 12.33,
  h: 1.9,
  fill: { color: colors.bgSecondary },
  line: { color: colors.border, pt: 1 }
});

slide4.addText('중간', {
  x: 0.7,
  y: 3.35,
  w: 0.9,
  h: 0.35,
  fontSize: 11,
  fontFace: 'Pretendard',
  bold: true,
  color: '92400E',
  fill: { color: 'FEF3C7' },
  align: 'center',
  valign: 'middle'
});

slide4.addText('AI Agent 워크플로우 경험 구체화', {
  x: 1.8,
  y: 3.3,
  w: 10,
  h: 0.45,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide4.addText('근거: 우대사항 "AI agent 기반 워크플로우 팀 구축 및 개선 경험"', {
  x: 0.7,
  y: 3.8,
  w: 11.9,
  h: 0.4,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.textSecondary
});

slide4.addText('제안: Claude Code로 복잡한 로직 구현, 테스트 코드 자동 생성한 구체적 사례 준비', {
  x: 0.7,
  y: 4.25,
  w: 11.9,
  h: 0.7,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.primary
});

// 항목 3: 영어 커뮤니케이션 (낮음)
slide4.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 5.3,
  w: 12.33,
  h: 1.9,
  fill: { color: colors.bgSecondary },
  line: { color: colors.border, pt: 1 }
});

slide4.addText('낮음', {
  x: 0.7,
  y: 5.45,
  w: 0.9,
  h: 0.35,
  fontSize: 11,
  fontFace: 'Pretendard',
  bold: true,
  color: '065F46',
  fill: { color: 'D1FAE5' },
  align: 'center',
  valign: 'middle'
});

slide4.addText('영어 커뮤니케이션 확인', {
  x: 1.8,
  y: 5.4,
  w: 10,
  h: 0.45,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.textPrimary
});

slide4.addText('근거: 회사가 한국-미국 이중 법인 운영, 글로벌 고객사(CBRE, Stability AI) 보유', {
  x: 0.7,
  y: 5.9,
  w: 11.9,
  h: 0.4,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.textSecondary
});

slide4.addText('제안: 영어 역량 있다면 언급, 부족시 기술 문서 영어 읽기 경험, 영어 커뮤니티 활동 어필', {
  x: 0.7,
  y: 6.35,
  w: 11.9,
  h: 0.7,
  fontSize: 12,
  fontFace: 'Pretendard',
  color: colors.primary
});

// ========== 슬라이드 5: 종합 요약 ==========
const slide5 = pptx.addSlide();
slide5.background = { color: colors.bgDark };

slide5.addText('종합 요약', {
  x: 0.5,
  y: 0.3,
  w: 12,
  h: 0.7,
  fontSize: 28,
  fontFace: 'Pretendard',
  bold: true,
  color: 'FFFFFF'
});

// 카드 1: 핵심 강점
slide5.addShape(pptx.ShapeType.roundRect, {
  x: 0.5,
  y: 1.2,
  w: 4,
  h: 5.5,
  fill: { color: '2D2D44' },
  line: { color: '3D3D5C', pt: 1 }
});

slide5.addText('핵심 강점', {
  x: 0.7,
  y: 1.4,
  w: 3.6,
  h: 0.5,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.success
});

const strengths = [
  '기술 스택 완벽 일치\n(Next.js, React, TypeScript)',
  'AI 도구 활용 능숙\n필수 요건 충족',
  '성능 최적화 성과\n(TTI 93%, 60% 단축)',
  '디자인 시스템 구축 경험',
  '기획~배포 전체\n라이프사이클 주도 경험'
];

strengths.forEach((text, i) => {
  slide5.addText('→ ' + text, {
    x: 0.7,
    y: 2.0 + (i * 0.95),
    w: 3.6,
    h: 0.85,
    fontSize: 12,
    fontFace: 'Pretendard',
    color: 'CBD5E1',
    lineSpacing: 16
  });
});

// 카드 2: 주의 사항
slide5.addShape(pptx.ShapeType.roundRect, {
  x: 4.67,
  y: 1.2,
  w: 4,
  h: 5.5,
  fill: { color: '2D2D44' },
  line: { color: '3D3D5C', pt: 1 }
});

slide5.addText('주의 사항', {
  x: 4.87,
  y: 1.4,
  w: 3.6,
  h: 0.5,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: colors.warning
});

const warnings = [
  '경력 요건 불충족\n(2년 요구 vs 신입)',
  '초기 스타트업(12명)\n체계적 프로세스 부재 가능',
  'First-time 창업팀\n경험 있는 리더십 부재 가능',
  '최근 1년 퇴사율\n확인 필요 (3/12명)'
];

warnings.forEach((text, i) => {
  slide5.addText('→ ' + text, {
    x: 4.87,
    y: 2.0 + (i * 1.1),
    w: 3.6,
    h: 1,
    fontSize: 12,
    fontFace: 'Pretendard',
    color: 'CBD5E1',
    lineSpacing: 16
  });
});

// 카드 3: 권장 액션
slide5.addShape(pptx.ShapeType.roundRect, {
  x: 8.83,
  y: 1.2,
  w: 4,
  h: 5.5,
  fill: { color: '2D2D44' },
  line: { color: '3D3D5C', pt: 1 }
});

slide5.addText('권장 액션', {
  x: 9.03,
  y: 1.4,
  w: 3.6,
  h: 0.5,
  fontSize: 16,
  fontFace: 'Pretendard',
  bold: true,
  color: '60A5FA'
});

const actions = [
  '자기소개서에 프로젝트\n성과 정량화하여 작성',
  'AI 도구 활용 사례\n구체적으로 준비',
  '"왜 경력 미충족에도\n적합한지" 설명 준비',
  '회사 개발 문화,\n근무 형태 직접 질문 권장'
];

actions.forEach((text, i) => {
  slide5.addText('→ ' + text, {
    x: 9.03,
    y: 2.0 + (i * 1.1),
    w: 3.6,
    h: 1,
    fontSize: 12,
    fontFace: 'Pretendard',
    color: 'CBD5E1',
    lineSpacing: 16
  });
});

// 푸터
slide5.addText('Generated by Fit Checker · 2026.01.09', {
  x: 0.5,
  y: 7.0,
  w: 12.33,
  h: 0.3,
  fontSize: 10,
  fontFace: 'Pretendard',
  color: '64748B',
  align: 'center'
});

// 파일 저장
pptx.writeFile({ fileName: 'output/fit-result-planby-2026-01-09.pptx' })
  .then(fileName => {
    console.log(`PPTX 파일 생성 완료: ${fileName}`);
  })
  .catch(err => {
    console.error('PPTX 생성 오류:', err);
  });
