# 行銷檢查清單 Marketing Checklists

> SEO、A/B 測試、廣告投放等完整檢查清單

## SEO 優化檢查清單

### On-Page SEO

#### 標題標籤 (Title Tag)
- [ ] 包含主要關鍵字
- [ ] 長度 50-60 字元
- [ ] 吸引人點擊
- [ ] 品牌名稱在後方

#### Meta Description
- [ ] 包含關鍵字
- [ ] 長度 150-160 字元
- [ ] 包含行動呼籲
- [ ] 獨特且引人入勝

#### 內容優化
- [ ] H1 只有一個，包含關鍵字
- [ ] H2-H6 結構清晰
- [ ] 關鍵字密度 1-2%
- [ ] 內部連結 3-5 個
- [ ] 外部連結到權威來源
- [ ] 圖片有 alt 標籤
- [ ] 內容長度 > 1500 字（深度文章）

#### 技術面
- [ ] 網頁載入 < 3 秒
- [ ] 行動裝置友善
- [ ] HTTPS 安全連線
- [ ] 結構化資料 (Schema)
- [ ] 無破損連結
- [ ] XML Sitemap 已提交
- [ ] Robots.txt 正確設定

### Off-Page SEO

- [ ] 高品質反向連結策略
- [ ] Guest Posting 計劃
- [ ] 社群分享
- [ ] 品牌提及監控
- [ ] 本地 SEO（如適用）

---

## A/B 測試檢查清單

### 測試前

- [ ] 定義明確假設（如果 X，則 Y）
- [ ] 選擇單一變數測試
- [ ] 預先計算所需樣本數
- [ ] 設定測試期間（至少 2 週）
- [ ] 確認追蹤代碼正確
- [ ] 設定顯著性水準（通常 p < 0.05）

### 測試中

- [ ] 不提前結束測試
- [ ] 監控數據異常
- [ ] 確保流量平均分配
- [ ] 記錄任何干擾因素

### 測試後

- [ ] 顯著性 p < 0.05
- [ ] 效果大小具商業意義（>2%）
- [ ] 考慮是否需要重複測試驗證
- [ ] 記錄結果與學習
- [ ] 實施勝出版本

### 樣本數計算公式

```
所需樣本數 = (Zα + Zβ)² × 2 × p(1-p) / d²

Zα = 1.96（95% 信心水準）
Zβ = 0.84（80% 統計效力）
p = 基準轉換率
d = 最小可檢測差異
```

**快速參考**：
- 基準轉換率 5%，想檢測 20% 相對提升 → 約需 20,000 樣本/組
- 基準轉換率 10%，想檢測 20% 相對提升 → 約需 8,000 樣本/組

---

## 廣告投放檢查清單

### Facebook/Meta 廣告

#### 帳戶設定
- [ ] Pixel 已安裝並驗證
- [ ] 轉換事件已設定
- [ ] 自訂受眾已建立
- [ ] 類似受眾已建立

#### Campaign 設定
- [ ] 選擇正確的行銷目標
- [ ] 預算設定合理
- [ ] 排程設定正確

#### Ad Set 設定
- [ ] 受眾定位精準
- [ ] 版位選擇適當
- [ ] 出價策略正確
- [ ] 每個 Ad Set 有 3-6 個 Ad 變體

#### Ad 創意
- [ ] 圖片/影片品質佳
- [ ] 文案吸引人
- [ ] CTA 明確
- [ ] 符合平台規範

### Google Ads

#### 帳戶設定
- [ ] 轉換追蹤已設定
- [ ] Google Analytics 已連結
- [ ] 再行銷名單已建立

#### 搜尋廣告
- [ ] 關鍵字分組合理
- [ ] 負面關鍵字已加入
- [ ] 廣告文案包含關鍵字
- [ ] 廣告額外資訊已設定
- [ ] 落地頁與廣告相關

#### 出價策略
- [ ] 新 Campaign 先用手動 CPC
- [ ] 有足夠數據後轉自動出價
- [ ] 設定 CPA/ROAS 目標

---

## Email 行銷檢查清單

### 發送前

- [ ] 主旨行 < 50 字元
- [ ] 預覽文字已設定
- [ ] 發送者名稱正確
- [ ] 收件人名單已篩選
- [ ] 個人化變數正確
- [ ] 連結都可點擊
- [ ] 圖片有 alt 文字
- [ ] 取消訂閱連結存在
- [ ] 手機版顯示正確
- [ ] 測試信已發送

### 發送後

- [ ] 開信率正常（>20%）
- [ ] 點擊率正常（>2%）
- [ ] 退訂率 < 0.5%
- [ ] 硬彈回 < 1%
- [ ] 無垃圾郵件投訴

### 開信率優化

**主旨行技巧**：
- 製造好奇：「你錯過了這個...」
- 數字具體：「3 個方法提升轉換率 50%」
- 個人化：「[姓名]，專屬優惠給你」
- 急迫感：「限時 24 小時」

**避免**：
- 全大寫
- 過多驚嘆號
- 垃圾信觸發詞（免費、賺錢、中獎）

---

## 社群媒體檢查清單

### 貼文發布前

- [ ] 圖片/影片品質佳
- [ ] 文案無錯字
- [ ] Hashtag 選擇適當
- [ ] 標註相關帳號
- [ ] 連結正確
- [ ] 發布時間最佳

### 每日任務

- [ ] 回覆留言和私訊
- [ ] 監控品牌提及
- [ ] 互動競品追蹤者
- [ ] 分享相關內容

### 每週任務

- [ ] 檢視數據表現
- [ ] 調整內容策略
- [ ] 規劃下週內容
- [ ] 更新內容日曆

### 每月任務

- [ ] 分析月度數據
- [ ] 競品分析更新
- [ ] 調整策略方向
- [ ] 實驗新內容類型

---

## 網站轉換優化檢查清單

### 首頁

- [ ] 價值主張清晰（3 秒內理解）
- [ ] 主要 CTA 明顯
- [ ] 載入速度 < 3 秒
- [ ] 行動裝置友善
- [ ] 社會認同可見

### 落地頁

- [ ] 標題與廣告一致
- [ ] 單一明確 CTA
- [ ] 無導航干擾
- [ ] 信任元素（見證、保證）
- [ ] 表單欄位最少化

### 購物流程

- [ ] 購物車清晰可見
- [ ] 結帳步驟簡化
- [ ] 多種付款方式
- [ ] 安全標章可見
- [ ] 免運門檻清楚

---

## 行銷週報指標清單

### 流量指標
- [ ] 總流量 vs 上週
- [ ] 流量來源分布
- [ ] 新 vs 回訪用戶
- [ ] 跳出率
- [ ] 平均工作階段時間

### 轉換指標
- [ ] 註冊轉換率
- [ ] 免費→付費轉換率
- [ ] 購物車放棄率
- [ ] 結帳完成率

### 成本指標
- [ ] CAC (各渠道)
- [ ] CPC / CPM
- [ ] ROAS
- [ ] LTV/CAC 比率

### 互動指標
- [ ] Email 開信率/點擊率
- [ ] 社群互動率
- [ ] 客服詢問量
- [ ] NPS 分數

---

## KOL 合作檢查清單

### 評估階段

- [ ] 粉絲真實性檢查（假粉檢測工具）
- [ ] 互動品質分析（留言是否真實）
- [ ] 過往合作案例審視
- [ ] 受眾重疊度評估
- [ ] 品牌安全性檢查（過往爭議）

### 合作前

- [ ] 合作目標明確
- [ ] 預算確認
- [ ] 合約內容清楚
- [ ] 內容審核流程
- [ ] 追蹤碼/連結準備

### 合作中

- [ ] 內容品質把關
- [ ] 發布時間確認
- [ ] 即時數據監控

### 合作後

- [ ] 成效數據分析
- [ ] ROI 計算
- [ ] 經驗記錄
- [ ] 決定是否長期合作
