# 行銷範例與框架 Marketing Examples & Frameworks

> 進階行銷策略、心理學應用與自動化流程

## Growth Hacking 框架

### Growth Hacking 循環

```
Ideate → Prioritize → Test → Analyze → Systematize
   ↑                                        │
   └────────────────────────────────────────┘
```

### ICE 優先級評分

**公式**：Impact × Confidence × Ease = Score (1-10 each)

| 實驗 | Impact | Confidence | Ease | Score |
|------|--------|------------|------|-------|
| 修改 CTA 按鈕 | 7 | 8 | 9 | 504 |
| 新增影片教學 | 8 | 6 | 4 | 192 |
| 重新設計首頁 | 9 | 5 | 2 | 90 |

### 評分指南

**Impact (影響力)**：
- 10：可能帶來 50%+ 成長
- 7-9：帶來 20-50% 成長
- 4-6：帶來 5-20% 成長
- 1-3：帶來 <5% 成長

**Confidence (信心)**：
- 10：有數據支持
- 7-9：有類似案例
- 4-6：有理論基礎
- 1-3：純粹猜測

**Ease (容易度)**：
- 10：1 天內完成
- 7-9：1 週內完成
- 4-6：1 月內完成
- 1-3：需要跨團隊長期配合

---

## 用戶心理學應用

### Cialdini 六大說服原則

| 原則 | 心理機制 | 行銷應用 | 實際範例 |
|------|----------|----------|----------|
| **互惠** | 先給予會產生回報義務 | 免費價值 | 免費試用、電子書、工具 |
| **稀缺** | 越少越珍貴 | 限量限時 | 「僅剩 3 個名額」「限時 48 小時」 |
| **權威** | 專家更可信 | 專家背書 | 專家推薦、認證標章、數據引用 |
| **一致性** | 人想維持行為一致 | 先小後大 | 免費試用 → 小額付費 → 訂閱 |
| **喜好** | 喜歡的人更有影響力 | 情感連結 | 品牌故事、代言人、社群互動 |
| **社會認同** | 跟隨多數人選擇 | 從眾心理 | 客戶見證、使用人數、評價 |

### 行為經濟學偏誤應用

#### 錨定效應
```
原價 $199 → 特價 $99

錨點（$199）讓特價顯得更划算
應用：
- 先展示高價方案
- 顯示原價與折扣價
- 比較競品高價
```

#### 損失厭惡
```
❌「獲得 20% 折扣」
✅「錯過就沒有這個價格」

人對損失的感受是獲得的 2 倍
應用：
- 「不要錯過」> 「獲得」
- 倒數計時器
- 限量提醒
```

#### 選擇悖論
```
太多選項 → 選擇困難 → 放棄

最佳實踐：
- 提供 3 個選項
- 推薦中間選項
- 清晰的比較表格
```

#### 框架效應
```
❌「有 10% 的機率失敗」
✅「有 90% 的成功率」

同樣資訊，不同框架產生不同感受
應用：
- 正面框架
- 強調獲得而非損失
- 使用具體數字
```

---

## 轉換率優化（CRO）詳解

### 高轉換落地頁結構

```
┌────────────────────────────────────────────┐
│  1. 首屏（Above the Fold）                 │
│     • 清晰價值主張（10 秒內理解）          │
│     • 主要 CTA 按鈕                        │
│     • 社會認同（客戶 Logo）                │
├────────────────────────────────────────────┤
│  2. 痛點描述                               │
│     • 3 個核心問題                         │
│     • 引起共鳴的描述                       │
├────────────────────────────────────────────┤
│  3. 解決方案                               │
│     • 產品/服務介紹                        │
│     • 3-5 個核心功能                       │
│     • 使用情境展示                         │
├────────────────────────────────────────────┤
│  4. 社會認同                               │
│     • 客戶見證（含照片更可信）             │
│     • 數據證明（「10,000+ 用戶」）         │
│     • 媒體報導                             │
├────────────────────────────────────────────┤
│  5. 常見問題（FAQ）                        │
│     • 解決購買障礙                         │
│     • 5-7 個常見問題                       │
├────────────────────────────────────────────┤
│  6. 最終 CTA                               │
│     • 重複價值主張                         │
│     • 明確行動按鈕                         │
│     • 消除風險（退款保證）                 │
└────────────────────────────────────────────┘
```

### 表單優化指南

```
欄位數 vs 轉換率：
3 欄位：25%
5 欄位：18%
7 欄位：14%
10 欄位：8%

每增加一個欄位，轉換率下降約 7%
```

**最佳實踐**：
- 只問必要資訊
- 分步驟（多頁表單）
- 使用進度條
- 顯示預計完成時間
- 自動填入（地址、Email）

### A/B 測試優先順序

**高影響（先測試）**：
1. 主標題/價值主張
2. CTA 按鈕（文案、顏色、位置）
3. 首屏圖片/影片
4. 定價顯示方式
5. 表單欄位數量

**低影響（後測試）**：
- 按鈕圓角
- 字體大小微調
- 圖片濾鏡
- 背景顏色微調

---

## 行銷自動化流程

### 新用戶 Onboarding 序列

```
[註冊]
    │
    ├─ 立即：歡迎信（介紹+下一步）
    │
    ├─ D+1：教學信 #1（核心功能）
    │
    ├─ D+3：教學信 #2（進階技巧）
    │
    ├─ D+7：成功案例分享
    │
    └─ D+14：反饋調查
            │
            ├─ 已轉換 → 感謝信 + 進階內容
            │
            └─ 未轉換 → 特別優惠
                    │
                    ├─ 已轉換 → 結束
                    │
                    └─ 未轉換 → 冷客戶序列
```

### 購物車放棄挽回序列

```
[放棄購物車]
    │
    ├─ 1 小時後：提醒信（展示購物車內容）
    │   開信率：45%，轉換率：10%
    │
    ├─ 24 小時後：社會認同（產品評價）
    │   開信率：30%，轉換率：5%
    │
    └─ 72 小時後：限時優惠（10% 折扣）
        開信率：25%，轉換率：8%

總挽回率預估：15-20%
```

### 再行銷序列

```
[沉睡用戶：30 天未活躍]
    │
    ├─ D+0：「我們想念你」+ 新功能介紹
    │
    ├─ D+7：精選內容推薦
    │
    ├─ D+14：回歸優惠
    │
    └─ D+30：最後機會 / 帳號停用提醒
            │
            └─ 仍未回歸 → 移至冷名單
```

---

## 品牌定位範例

### 品牌定位四象限

```
          高價
            │
  奢華品牌  │  專業品牌
  (Luxury)  │  (Premium)
            │
────────────┼────────────
            │
  經濟品牌  │  價值品牌
  (Economy) │  (Value)
            │
          低價

    感性 ←──────→ 理性
```

**象限說明**：
- **奢華品牌**：高價+感性（LV、Gucci）
- **專業品牌**：高價+理性（Apple、Tesla）
- **價值品牌**：低價+理性（IKEA、Uniqlo）
- **經濟品牌**：低價+感性（可口可樂、麥當勞）

---

## 社群互動公式

### 互動率計算

```
互動率 = (按讚 + 留言 + 分享 + 儲存) / 觸及人數 × 100%
```

### 平台基準值

| 平台 | 好 | 優秀 |
|------|-----|------|
| Facebook | 1-3% | 3-6% |
| Instagram | 3-6% | 6%+ |
| LinkedIn | 2-4% | 4%+ |
| TikTok | 5-8% | 8%+ |

### 提升互動技巧

1. **提問結尾**：「你怎麼看？」
2. **投票/選擇題**：讓參與更容易
3. **使用表情符號**：增加 25% 互動
4. **即時回覆**：前 1 小時內回覆每則留言
5. **標註相關帳號**：增加曝光

---

## 北極星指標選擇

### 依商業模式選擇

| 商業模式 | 推薦北極星指標 |
|----------|----------------|
| SaaS | MAU 或 NRR |
| 電商 | 購買用戶數 或 GMV |
| 媒體 | DAU 或 閱讀時間 |
| 市集 | GMV 或 交易數 |
| 社群 | DAU 或 互動數 |

### 好的北極星指標特徵

- 反映用戶價值
- 可被團隊影響
- 領先指標（不是滯後）
- 全公司可理解
