---
name: marketing-campaign
description: "Social media marketing and campaign planning toolkit. Create comprehensive marketing strategies, content calendars, influencer outreach plans, and platform-specific campaigns for software products and tech startups."
allowed-tools: [Read, Write, Edit, Bash, WebFetch, WebSearch]
---

# Marketing Campaign Planning

## Overview

Marketing campaign planning is a systematic process for creating and executing social media strategies, content calendars, and influencer partnerships. This skill helps plan product launches, build brand awareness, and create engaging content across multiple platforms. Backed by real research and best practices from 2025 marketing frameworks.

## When to Use This Skill

This skill should be used when:
- Planning a software product launch campaign
- Creating social media strategy for a tech startup
- Developing content calendars and posting schedules
- Planning influencer partnerships and outreach
- Creating platform-specific content strategies
- Developing marketing budgets and KPI frameworks
- Building brand awareness campaigns

## Visual Enhancement with Project Diagrams

**When documenting marketing campaigns, always include visualizations.**

Use the **project-diagrams** skill to generate:
- Campaign timeline diagrams
- Content calendar visualizations
- Funnel and conversion flow diagrams
- Platform strategy comparison charts
- Influencer tier pyramids
- Budget allocation pie charts

```bash
python .claude/skills/project-diagrams/scripts/generate_schematic.py "diagram description" -o diagrams/output.png
```

Use the **generate-image** skill for:
- Social media post mockups
- Brand visual concepts
- Campaign creative examples

---

## Campaign Planning Framework

### Campaign Components

| Component | Purpose | Key Deliverables |
|-----------|---------|------------------|
| **Strategy Foundation** | Define goals and audience | Campaign brief, personas, positioning |
| **Content Calendar** | Plan and schedule content | 30/60/90 day content plan |
| **Platform Playbooks** | Platform-specific tactics | LinkedIn, X, Instagram, TikTok guides |
| **Influencer Strategy** | Partnership planning | Outreach list, collaboration framework |
| **Creative Assets** | Visual content creation | Post templates, graphics, videos |
| **Metrics & Tracking** | Measure success | KPI dashboard, reporting templates |

---

## Phase 1: Strategy Foundation

### Campaign Brief Template

```markdown
# Campaign Brief: [Campaign Name]

## Campaign Overview
- **Campaign Name**:
- **Product/Service**:
- **Campaign Duration**: [Start Date] - [End Date]
- **Budget**: $[Total Budget]

## Goals & Objectives
### Primary Goal
[One clear, measurable goal]

### SMART Objectives
1. **Specific**: [What exactly?]
2. **Measurable**: [Target metric: X% increase / X new followers]
3. **Achievable**: [Why is this realistic?]
4. **Relevant**: [How does this support business goals?]
5. **Time-bound**: [By when?]

## Target Audience

### Primary Persona
- **Name**: [Persona name]
- **Role/Title**: [Job title or demographic]
- **Pain Points**: [3-5 key challenges]
- **Goals**: [What they want to achieve]
- **Platforms**: [Where they spend time online]
- **Content Preferences**: [What content resonates]

### Secondary Persona
[Repeat structure]

## Key Messages
1. **Primary Message**: [Core value proposition]
2. **Supporting Message 1**: [Feature/benefit]
3. **Supporting Message 2**: [Differentiator]
4. **Call to Action**: [What you want them to do]

## Competitive Positioning
[Use competitive-analysis skill for detailed research]
- **Key Competitors**:
- **Our Differentiation**:
- **Market Gap We Fill**:
```

### Audience Research Process

**Use research-lookup to understand your audience:**

1. **Platform demographics**
   - Where does your target audience spend time?
   - What content formats perform best per platform?

2. **Competitor audience analysis**
   - Who follows your competitors?
   - What content gets engagement?

3. **Industry trends**
   - What topics are trending in your space?
   - What hashtags are relevant?

---

## Phase 2: Content Calendar

### Content Calendar Structure

| Week | Monday | Tuesday | Wednesday | Thursday | Friday | Weekend |
|------|--------|---------|-----------|----------|--------|---------|
| Theme | Educational | Engagement | Value | Social Proof | CTA | Community |
| LinkedIn | Article/Carousel | Poll/Question | Tips Thread | Case Study | Product Feature | - |
| X/Twitter | Thread | Engagement | Quick Tips | Testimonial | Announcement | Curated |
| Instagram | Carousel | Story Poll | Reel | Customer Story | Product Shot | Behind Scenes |

### Content Pillars (60-30-10 Rule)

| Pillar | Percentage | Content Types |
|--------|------------|---------------|
| **Value Content** | 60% | Educational, how-to, tips, insights, tutorials |
| **Engagement Content** | 30% | Polls, questions, memes, trends, community |
| **Promotional Content** | 10% | Product features, CTAs, launches, offers |

### Product Launch Timeline

**Pre-Launch (4-6 weeks before)**
- Week 1-2: Teaser content, building anticipation
- Week 3-4: Behind-the-scenes, sneak peeks
- Week 5-6: Countdown, influencer seeding

**Launch Week**
- Day -1: Final teaser, "coming tomorrow"
- Day 0: Launch announcement across all platforms
- Day 1-3: Feature highlights, tutorials
- Day 4-7: User testimonials, FAQs

**Post-Launch (ongoing)**
- Week 1-2: Customer stories, results
- Week 3-4: Tips and tricks content
- Ongoing: Community building, updates

---

## Phase 3: Platform Playbooks

### LinkedIn Strategy

**Best For**: B2B, professional audience, thought leadership

**Content Types**:
| Type | Frequency | Best Practices |
|------|-----------|----------------|
| **Text Posts** | Daily | Hook in first line, 1300-1500 chars, 3-5 hashtags |
| **Carousels** | 2-3x/week | 8-12 slides, educational, strong CTA on last slide |
| **Articles** | Weekly | 1500-2000 words, SEO-optimized |
| **Video** | 1-2x/week | 30-90 seconds, captions required |
| **Polls** | Weekly | 2-4 options, engagement driver |

**Posting Times**: Tuesday-Thursday, 7-8 AM or 12 PM (audience timezone)

**LinkedIn Post Template**:
```
[Hook - Problem or Question] ← First line is crucial

[3-5 short paragraphs with insights]

• Bullet point 1
• Bullet point 2
• Bullet point 3

[CTA - Comment, Follow, or Visit]

#hashtag1 #hashtag2 #hashtag3
```

### X/Twitter Strategy

**Best For**: Real-time engagement, tech community, announcements

**Content Types**:
| Type | Frequency | Best Practices |
|------|-----------|----------------|
| **Threads** | 2-3x/week | 5-15 tweets, numbered, hook in tweet 1 |
| **Single Tweets** | 3-5x/day | 240-280 chars, one clear idea |
| **Replies** | Ongoing | Engage with industry conversations |
| **Spaces** | Weekly | Live audio for community building |

**Thread Template**:
```
1/ [Hook - Bold claim or question]

2/ [Context - Why this matters]

3/ [Point 1]

4/ [Point 2]

5/ [Point 3]

6/ [Summary + CTA]

Follow @handle for more [topic]
```

### Instagram Strategy

**Best For**: Visual brands, younger audience, lifestyle content

**Content Types**:
| Type | Frequency | Best Practices |
|------|-----------|----------------|
| **Reels** | 4-7x/week | 15-30 seconds, trending audio, text overlays |
| **Carousels** | 3-4x/week | 5-10 slides, swipe-worthy, save-worthy |
| **Stories** | Daily | Polls, quizzes, behind-scenes |
| **Feed Posts** | 3-5x/week | High-quality visuals, cohesive grid |

**Posting Times**: Tuesday, Wednesday, Friday, 11 AM or 7-9 PM

### TikTok Strategy

**Best For**: Gen Z, viral potential, authentic content

**Content Types**:
| Type | Best Practices |
|------|----------------|
| **Educational** | Quick tips, tutorials, hacks |
| **Trending** | Participate in trends with brand spin |
| **Behind-the-Scenes** | Day in the life, team content |
| **Product Demos** | Show don't tell, problem → solution |

**Best Practices**:
- First 1-2 seconds must hook
- Use trending sounds
- Text overlays for silent viewing
- Post 1-3x daily for growth

---

## Phase 4: Influencer Strategy

### Influencer Tier Framework

| Tier | Followers | Use Case | Cost Range | Engagement |
|------|-----------|----------|------------|------------|
| **Nano** | 1K-10K | Authentic testimonials | $50-500 | 5-10% |
| **Micro** | 10K-100K | Niche authority | $500-5K | 3-8% |
| **Mid-Tier** | 100K-500K | Broader reach | $5K-20K | 2-5% |
| **Macro** | 500K-1M | Awareness campaigns | $20K-100K | 1-3% |
| **Mega** | 1M+ | Mass awareness | $100K+ | 0.5-2% |

### Influencer Selection Criteria

**Research each potential influencer:**

| Criteria | Weight | How to Evaluate |
|----------|--------|-----------------|
| **Audience Fit** | 30% | Demographics match your target persona |
| **Engagement Rate** | 25% | Comments/likes ratio, authentic engagement |
| **Content Quality** | 20% | Production value, brand alignment |
| **Authenticity** | 15% | Genuine voice, not over-sponsored |
| **Past Performance** | 10% | Results from similar campaigns |

### Outreach Template

```markdown
Subject: Partnership Opportunity - [Your Brand] x [Creator Name]

Hi [Name],

I've been following your content on [platform] and loved your recent post about [specific post]. Your perspective on [topic] really resonates with our mission at [Brand].

We're launching [product/campaign] and think your audience would genuinely benefit from it. Here's what we're thinking:

**The Opportunity:**
- [Brief description of collaboration]
- [What they'd create/share]
- [Timeline]

**What We Offer:**
- [Compensation/product]
- [Creative freedom level]
- [Additional perks]

Would you be open to a quick call this week to explore this?

Best,
[Your name]
[Your role]
```

### Collaboration Types

| Type | Description | Best For |
|------|-------------|----------|
| **Sponsored Post** | Paid content featuring product | Quick awareness |
| **Product Review** | Authentic review/unboxing | Trust building |
| **Affiliate** | Commission-based partnership | Ongoing sales |
| **Brand Ambassador** | Long-term partnership | Sustained presence |
| **Co-Creation** | Joint product/content | Deep collaboration |
| **Takeover** | Creator manages brand account | Fresh perspective |

---

## Phase 5: Budget Framework

### Budget Allocation (60-30-10)

| Category | % | Use |
|----------|---|-----|
| **Paid Promotion** | 60% | Ads, boosted posts, sponsored content |
| **Content & Creators** | 30% | Influencers, content creation, design |
| **Tools & Analytics** | 10% | Scheduling tools, analytics, AI tools |

### Sample Budget Breakdown

**$10,000 Monthly Budget:**
```
Paid Advertising:        $6,000 (60%)
├── LinkedIn Ads:        $2,000
├── Meta Ads:            $2,500
├── Twitter/X Ads:       $1,000
└── TikTok Ads:          $500

Content & Creators:      $3,000 (30%)
├── Influencer Posts:    $2,000
├── Graphic Design:      $500
└── Video Production:    $500

Tools & Analytics:       $1,000 (10%)
├── Scheduling Tool:     $300
├── Analytics Platform:  $400
└── AI Content Tools:    $300
```

---

## Phase 6: Metrics & KPIs

### Key Metrics by Goal

| Goal | Primary Metrics | Secondary Metrics |
|------|-----------------|-------------------|
| **Awareness** | Reach, Impressions | Follower growth, Brand mentions |
| **Engagement** | Engagement rate, Comments | Saves, Shares, DMs |
| **Traffic** | Link clicks, CTR | Landing page visits, Bounce rate |
| **Leads** | Sign-ups, Downloads | Email captures, Demo requests |
| **Sales** | Conversions, Revenue | ROAS, CAC, LTV |

### Platform Benchmarks (2025)

| Platform | Good Engagement Rate | Great Engagement Rate |
|----------|---------------------|----------------------|
| LinkedIn | 2-4% | 5%+ |
| Instagram | 1-3% | 4%+ |
| X/Twitter | 0.5-1% | 2%+ |
| TikTok | 3-6% | 10%+ |

### Reporting Template

```markdown
# Weekly Marketing Report: [Date Range]

## Summary
- **Total Reach**: [X]
- **Total Engagement**: [X]
- **Top Performing Post**: [Link]
- **Follower Growth**: +[X]

## Platform Performance

### LinkedIn
| Metric | This Week | Last Week | Change |
|--------|-----------|-----------|--------|
| Impressions | | | |
| Engagement Rate | | | |
| Followers | | | |

### [Repeat for each platform]

## Top Content
1. [Post title/link] - [Engagement]
2. [Post title/link] - [Engagement]
3. [Post title/link] - [Engagement]

## Insights & Learnings
- [What worked]
- [What didn't work]
- [Adjustments for next week]

## Next Week Focus
- [Priority 1]
- [Priority 2]
- [Priority 3]
```

---

## Output Structure

When creating marketing campaign deliverables, organize outputs:

```
planning_outputs/[project]/
├── marketing/
│   ├── campaign_brief.md           # Strategy foundation
│   ├── content_calendar.md         # 30/60/90 day plan
│   ├── platform_strategies/
│   │   ├── linkedin_playbook.md
│   │   ├── twitter_playbook.md
│   │   ├── instagram_playbook.md
│   │   └── tiktok_playbook.md
│   ├── influencer_strategy.md      # Influencer framework
│   ├── influencer_list.csv         # Target influencers
│   ├── budget_breakdown.md         # Budget allocation
│   ├── kpi_dashboard.md            # Metrics tracking
│   └── content_templates/
│       ├── post_templates.md
│       └── outreach_templates.md
└── diagrams/
    ├── campaign_timeline.png
    ├── content_calendar_visual.png
    └── funnel_diagram.png
```

---

## Integration with Other Skills

This skill works best when combined with:

| Skill | Integration |
|-------|-------------|
| **competitive-analysis** | Research competitor marketing strategies |
| **market-research-reports** | Comprehensive market and audience research |
| **project-diagrams** | Visualize campaign timelines and funnels |
| **generate-image** | Create social media post mockups and visuals |
| **research-lookup** | Research trends, platform algorithms, best practices |

---

## Quick Start Checklist

When planning a marketing campaign, ensure:

- [ ] Campaign brief completed with SMART goals
- [ ] Target personas defined with platform preferences
- [ ] Competitive marketing analysis done
- [ ] Content calendar created (minimum 30 days)
- [ ] Platform playbooks customized for your brand
- [ ] Influencer list compiled with outreach templates
- [ ] Budget allocated across channels
- [ ] KPIs defined with tracking system
- [ ] Visual assets planned (diagrams, mockups)
- [ ] Launch timeline finalized

---

## Resources

- [Hootsuite Social Media Strategy Template](https://www.hootsuite.com/resources/social-media-strategy-template)
- [ClickUp Tech Startup Social Media Plan](https://clickup.com/templates/social-media-plan/tech-startup)
- [Sprout Social 30-Day Plan](https://sproutsocial.com/insights/social-media-plan/)
- [Zapier Social Media Strategy Guide 2025](https://zapier.com/blog/social-media-strategy/)
