---
name: marketing-strategy-pmm
description: Product marketing, positioning, GTM strategy, and competitive intelligence. Includes ICP definition, April Dunford positioning methodology, launch playbooks, competitive battlecards, and international market entry guides. Use when developing positioning, planning product launches, creating messaging, analyzing competitors, entering new markets, enabling sales, or when user mentions product marketing, positioning, GTM, go-to-market, competitive analysis, market entry, or sales enablement.
license: MIT
metadata:
  version: 1.0.0
  author: Alireza Rezvani
  category: marketing
  domain: product-marketing
  updated: 2025-10-20
  frameworks: April-Dunford-positioning, ICP-definition, messaging-hierarchy
  target-market: B2B-SaaS, international-expansion, Series-A+
---

# Marketing Strategy & Product Marketing

Expert Product Marketing playbook for Series A+ startups expanding internationally with hybrid PLG/Sales-Led motion.

## Keywords
product marketing, positioning, GTM, go-to-market strategy, competitive analysis, competitive intelligence, battlecards, ICP, ideal customer profile, messaging, value proposition, product launch, market entry, international expansion, sales enablement, win loss analysis, PMM, product marketing manager, market positioning, competitive landscape, sales training

## Role Coverage

This skill serves:
- **Product Marketing Manager (PMM)** - Positioning, messaging, competitive intel, launches
- **Head of Marketing** - Strategy, budget, org design, pipeline targets
- **Head of Growth** - Experimentation, activation, retention, growth loops
- **CMO/VP Marketing** - Executive strategy, board reporting, team leadership

## Core KPIs by Role

**PMM**: Product adoption rate, win rate vs. competitors, sales velocity, launch impact metrics, competitive win rate, deal size growth

**Head of Marketing**: Marketing-sourced pipeline $, CAC/LTV ratio, ROMI (3:1+ target), brand awareness lift, market share growth

**Head of Growth**: Activation rate, WAU/MAU, conversion rates across funnel, payback period, viral coefficient (PLG)

**CMO**: Revenue growth %, pipeline coverage (3-4x), team productivity, budget efficiency, NPS/brand health

## Tech Stack Integration

**HubSpot** - CRM, deal tracking, competitive loss analysis, sales enablement content
**Google Analytics** - Product usage, activation funnels, feature adoption
**Gong/Chorus** - Sales call analysis, competitive intelligence, objection tracking
**Productboard** - Feature requests, customer feedback, roadmap prioritization
**Notion/Confluence** - Internal wiki, positioning docs, competitive battlecards

---

## 1. Strategic Foundation

### 1.1 Company Strategy Framework (Series A Context)

**Current State Analysis**:
```
Stage: Series A
Funding: $5-15M raised
Team Size: 20-50 people
Revenue: $1-5M ARR
Market Position: Challenger/Niche leader
Growth Rate Target: 3-5x YoY

Key Challenges:
- Prove product-market fit at scale
- Expand from early adopters → mainstream
- Enter new markets (EU/US/Canada)
- Compete against incumbents
- Build repeatable sales motion
```

**Strategic Priorities** (in order):
1. **Nail positioning** - Clear, differentiated value prop
2. **Scale acquisition** - Repeatable, efficient channels
3. **Prove retention** - Product stickiness, expansion revenue
4. **Expand markets** - Geographic + vertical expansion
5. **Build brand** - Awareness, trust, category leadership

### 1.2 ICP (Ideal Customer Profile) Definition

**B2B SaaS ICP Framework**:

**Firmographics**:
- Company size: 50-5000 employees (Series A sweet spot)
- Industry: SaaS, Tech, Professional Services
- Geography: US, Canada, UK, Germany, France (prioritize by TAM)
- Revenue: $5M-$500M annual
- Funding stage: Seed to Growth (avoid pre-product)

**Technographics**:
- Tech stack: Modern (cloud-first, API-driven)
- Maturity: Growing fast, willing to adopt new tools
- Existing tools: [List competitors + complementary products]
- Integration needs: Must integrate with [Salesforce, Slack, etc.]

**Psychographics**:
- Pain level: 7-10/10 (acute pain, not nice-to-have)
- Buyer motivation: Efficiency, cost savings, revenue growth
- Decision process: 2-6 month sales cycle
- Risk tolerance: Early majority (not bleeding edge)

**Buyer Personas** (3-5 personas max):

**Primary: Economic Buyer** (signs contract)
- Title: VP, Director, Head of [Department]
- Goals: ROI, team productivity, cost reduction
- Fears: Implementation failure, team resistance, budget waste
- Messaging: Business outcomes, ROI, case studies

**Secondary: Technical Buyer** (evaluates product)
- Title: Senior Engineer, Architect, Tech Lead
- Goals: Solves technical problem, easy integration
- Fears: Technical debt, vendor lock-in, poor support
- Messaging: Technical capabilities, architecture, security

**User/Champion** (advocates internally)
- Title: Manager, Team Lead, Power User
- Goals: Makes their job easier, team loves it
- Fears: Learning curve, change management
- Messaging: UX, ease of use, quick wins

**ICP Validation Checklist**:
- [ ] 5+ paying customers match this profile
- [ ] Fastest sales cycles (< median time to close)
- [ ] Highest LTV (> median customer value)
- [ ] Lowest churn (< 5% annual)
- [ ] Strong product engagement (daily/weekly usage)
- [ ] Referenceable (NPS 9-10, willing to do case studies)

**HubSpot ICP Tracking**:
- Create "ICP Fit" property: A (perfect), B (good), C (okay), D (poor)
- Score based on firmographics, engagement, product usage
- Report: Win rate by ICP score, pipeline by ICP score
- Action: Focus acquisition on ICP A/B, nurture C, disqualify D

### 1.3 Market Segmentation Strategy

**Segmentation Dimensions**:

**By Company Size** (recommend starting with one):
- **SMB** (10-200 employees) - Self-serve PLG, low touch, $100-$2k ACV
- **Mid-Market** (200-2000 employees) - Hybrid, inside sales, $2k-$50k ACV
- **Enterprise** (2000+ employees) - Sales-led, field sales, $50k+ ACV

**By Vertical** (choose 2-3 focus verticals):
- Horizontal: Broad appeal (e.g., project management for any industry)
- Vertical: Industry-specific (e.g., healthcare CRM, fintech compliance)
- Approach: Start horizontal, add verticals as you scale

**By Use Case** (messaging varies):
- Use Case A: [e.g., Team collaboration]
- Use Case B: [e.g., Client management]
- Use Case C: [e.g., Project tracking]
- Each use case = different landing page, messaging, case studies

**By Geography** (Series A focus):
- **US/Canada**: Largest TAM, fastest sales cycles, highest willingness to pay
- **UK**: English-speaking, gateway to EU, similar buying behavior to US
- **Germany**: Largest EU economy, high data privacy standards (GDPR leader)
- **France**: Second largest EU market, localization critical
- **Nordics**: High tech adoption, English proficiency, smaller markets

**Segmentation Priority Matrix**:
```
Segment: US Mid-Market SaaS Companies (200-2000 employees)
Priority: 1 (Highest)
Rationale:
  - Largest TAM ($5B)
  - Fastest sales cycle (60 days avg)
  - Highest win rate (35%)
  - Strong product fit (use cases align)
  - Existing customer base (50% of customers)
Budget Allocation: 50% of marketing spend
```

---

## 2. Positioning & Messaging

### 2.1 Positioning Framework (April Dunford Method)

**Step 1: List Your True Competitive Alternatives**

Not just direct competitors - what would customers do if your product didn't exist?

```
Alternatives:
1. Competitor A (direct)
2. Competitor B (direct)
3. Spreadsheets + email (status quo)
4. Build in-house (DIY)
5. Do nothing (ignore problem)
```

**Step 2: Isolate Your Unique Attributes**

What do you have that alternatives don't?

```
Unique Attributes:
1. [Feature X that no one else has]
2. [Integration Y that's exclusive]
3. [Approach Z that's differentiated]
4. [Performance metric better than all]
```

**Step 3: Map Attributes to Value**

What value do these attributes provide to customers?

```
Attribute: [Real-time collaboration]
→ Value: Teams can work together simultaneously
→ Outcome: 50% faster project completion

Attribute: [AI-powered automation]
→ Value: Eliminates manual data entry
→ Outcome: Save 10 hours/week per user
```

**Step 4: Define Your Best-Fit Customers**

Who cares most about this value?

```
Best-Fit: Mid-market SaaS companies (200-1000 employees)
Why: They have distributed teams, need real-time collaboration
Evidence: Fastest sales cycles, lowest churn, highest NPS
```

**Step 5: Nail Your Market Category**

What market do you dominate?

```
Options:
- Head-to-head: Compete in existing category (e.g., "CRM")
- Big fish, small pond: Own a niche (e.g., "CRM for agencies")
- Create new: Define new category (risky, expensive)

Decision: [Choose based on competitive strength and budget]
```

**Step 6: Layer on Trends**

What trends make this the right time to buy?

```
Trends:
- Remote work explosion (2020-2025)
- AI/ML adoption in enterprise (2024-2025)
- Data privacy regulations (GDPR, CCPA)
```

### 2.2 Messaging Architecture

**Value Proposition (One-Liner)**:

Template: `[Product] helps [Target Customer] [Achieve Goal] by [Unique Approach]`

Example: "Acme helps mid-market SaaS teams ship 2x faster by automating project workflows with AI"

**Messaging Hierarchy**:

```
LEVEL 1: Value Proposition (one-liner)
[Your one-liner here]

LEVEL 2: Key Benefits (3-5 bullet points)
- Benefit 1: [Speed] → Ship products 2x faster
- Benefit 2: [Quality] → Reduce bugs by 50%
- Benefit 3: [Collaboration] → Align teams in real-time
- Benefit 4: [Cost] → Save $100k/year on tools

LEVEL 3: Features (supporting evidence)
- Feature → Benefit → Outcome
- AI automation → Eliminates manual work → Save 10 hrs/week
- Real-time sync → No version conflicts → 50% fewer errors
- Integrations → Connect existing tools → 80% faster onboarding

LEVEL 4: Proof Points
- Customer logos: [Microsoft, Shopify, Stripe]
- Stats: Used by 10,000+ teams, 4.8/5 G2 rating
- Case studies: How [Customer] achieved [Outcome]
```

**Messaging by Persona**:

**Economic Buyer** (VP/Director):
- Primary concern: ROI, business outcomes
- Tone: Professional, data-driven, results-focused
- Key message: "Increase revenue by 25% while reducing costs by $200k/year"
- Proof: ROI calculator, case studies with $ impact

**Technical Buyer** (Engineer/Architect):
- Primary concern: Technical fit, security, scalability
- Tone: Technical, detailed, objective
- Key message: "Enterprise-grade architecture with 99.99% uptime and SOC 2 compliance"
- Proof: Technical docs, security whitepaper, architecture diagram

**End User** (Manager/Individual Contributor):
- Primary concern: Ease of use, daily workflow
- Tone: Friendly, empathetic, practical
- Key message: "Spend less time on busywork, more time on what matters"
- Proof: Product demo, free trial, customer testimonials

### 2.3 Messaging Testing & Iteration

**Message Testing Framework**:

1. **Qualitative** (customer interviews):
   - Ask 10-15 target customers:
   - "How would you describe [Product] to a colleague?"
   - "What's the main benefit you get from [Product]?"
   - "Why did you choose us over [Competitor]?"

2. **Quantitative** (A/B testing):
   - Test messaging variations on:
   - Landing page headlines
   - Ad copy (LinkedIn, Google)
   - Email subject lines
   - Measure: CTR, conversion rate, demo requests

3. **Sales Feedback** (win/loss analysis):
   - Ask sales team monthly:
   - "Which message resonates most with prospects?"
   - "What objections are we hearing?"
   - "How do we compare to [Competitor] in customer's eyes?"

**Iteration Cycle**:
- Test new messaging: 2-4 weeks
- Analyze results: 1 week
- Update messaging docs: 1 week
- Train sales team: 1 week
- Repeat quarterly

---

## 3. Competitive Intelligence

### 3.1 Competitive Analysis Framework

**Tier 1: Direct Competitors** (head-to-head, same category)
- [Competitor A]: Market leader, $100M+ ARR
- [Competitor B]: Fast-growing challenger, Series B
- [Competitor C]: Open-source alternative

**Tier 2: Indirect Competitors** (adjacent solutions)
- [Alt Solution D]: Different approach, overlapping use case
- [Alt Solution E]: Broader platform, includes your feature

**Tier 3: Status Quo** (what customers do today)
- Spreadsheets + email
- Build in-house
- Do nothing

**Competitive Intelligence Sources**:
1. **Product trials**: Sign up for competitor products, use actively
2. **Website monitoring**: Track changes to pricing, messaging, features
3. **Customer interviews**: Ask "What alternatives did you consider?"
4. **Sales call recordings** (Gong/Chorus): Listen for competitor mentions
5. **Review sites** (G2, Capterra): Read competitor reviews (pros/cons)
6. **Job postings**: Competitor hiring = roadmap insights
7. **Financial filings** (if public): Revenue, growth, strategy
8. **Social media**: Follow competitor execs, product teams
9. **Partner channels**: Talk to shared implementation partners
10. **Industry reports**: Gartner, Forrester, IDC

### 3.2 Competitive Battlecards

**Battlecard Template** (create one per competitor):

```
COMPETITOR: [Competitor A]

OVERVIEW:
- Founded: 2015
- Funding: Series C, $75M raised
- HQ: San Francisco
- Size: 200 employees
- Customers: 5,000+ companies
- Pricing: $50-$500/user/month

POSITIONING:
- They say: "All-in-one platform for modern teams"
- Reality: Broad but shallow, not deep in any use case

KEY STRENGTHS (What They Do Well):
1. Strong brand recognition (category leader)
2. Large feature set (breadth over depth)
3. Extensive integrations (2,000+ apps)

KEY WEAKNESSES (Where They Fall Short):
1. Complex UI (steep learning curve)
2. Expensive (2x our price at scale)
3. Poor support (low NPS in reviews)
4. Legacy architecture (slow performance)

OUR ADVANTAGES:
1. 10x easier to use (time-to-value in minutes vs. days)
2. 50% lower cost at 100+ users
3. Superior performance (2x faster load times)
4. White-glove onboarding (dedicated CSM)

WHEN TO WIN:
- Customer values ease of use over features
- Budget-conscious (not enterprise)
- Need fast time-to-value (<1 week)
- Poor experience with competitor (switching)

WHEN TO LOSE:
- Enterprise (>5000 employees) with complex requirements
- Need feature X that we don't have yet
- Deep integration with competitor's ecosystem
- Already invested heavily in competitor (sunk cost)

TALK TRACKS:

Objection: "We're already using [Competitor A]"
Response: "That's great - many of our customers came from [Competitor A]. What prompted you to explore alternatives? [Listen for pain points] Typically teams switch to us because [ease of use / cost / performance]. Would it be helpful to see a side-by-side comparison?"

Objection: "[Competitor A] has more features"
Response: "You're right - they've been around longer and have a broader feature set. Here's what we found: most teams only use 20% of those features. Our customers love that we focus on doing [core use case] exceptionally well rather than trying to do everything. What features are most critical for your team?"

PROOF POINTS:
- Case study: "[Customer] switched from [Competitor A], reduced costs by 60%"
- Review comparison: "[4.8 vs. 4.2 G2 rating in 'Ease of Use']"
- Win rate: "35% win rate in competitive deals"

COMPETITIVE LANDSCAPE:
[Link to competitive positioning map]
[Link to feature comparison matrix]
```

**Battlecard Distribution**:
- Store in: Notion, Confluence, or sales enablement platform
- Update frequency: Monthly (or when competitor launches major feature)
- Access: Sales, CS, Product, Marketing teams
- Training: Monthly competitive update calls with sales

### 3.3 Win/Loss Analysis

**Win/Loss Interview Process**:

**Goals**:
- Understand why you won/lost
- Validate positioning and messaging
- Identify product gaps
- Track competitive trends

**Process**:
1. **Identify deals** (closed won or lost in last 30 days)
2. **Request interview** (email or HubSpot workflow)
3. **Conduct interview** (30-45 min, record with permission)
4. **Analyze data** (themes, patterns, trends)
5. **Share insights** (monthly report to product, sales, marketing)

**Interview Questions** (pick 8-10):

**For Wins**:
- What problem were you trying to solve?
- What alternatives did you evaluate?
- Why did you choose us over [Competitor]?
- What almost made you choose someone else?
- What could we improve?

**For Losses**:
- What problem were you trying to solve?
- Who did you choose instead? Why?
- What did we do well in the sales process?
- What could we have done differently?
- Would you consider us in the future? When?

**Data Tracking** (in HubSpot or spreadsheet):

| Deal | Outcome | Reason | Competitor | Price Factor | Product Gap | Messaging Issue |
|------|---------|--------|------------|--------------|-------------|-----------------|
| Acme Corp | Won | Best product fit | Competitor A | No | No | No |
| Beta Inc | Lost | Price | Competitor B | Yes | No | No |
| Gamma LLC | Lost | Missing feature X | Built in-house | No | Yes | No |

**Monthly Insights Report**:
```
Win/Loss Summary (March 2025):
- Total deals analyzed: 20 (12 wins, 8 losses)
- Win rate: 60%
- Top win reasons:
  1. Ease of use (8 mentions)
  2. Better support (6 mentions)
  3. Price (4 mentions)
- Top loss reasons:
  1. Missing feature X (4 mentions)
  2. Price (3 mentions)
  3. Competitor relationship (2 mentions)

Action Items:
- Product: Prioritize feature X (lost 4 deals)
- Sales: Update battlecard for Competitor A (won 5 competitive deals)
- Marketing: Create case study on "ease of use" theme
```

---

## 4. Go-To-Market (GTM) Strategy

### 4.1 GTM Motion Types

**PLG (Product-Led Growth)**:
- Entry: Free trial or freemium
- Buyer: End user → Manager → VP
- Sales: Low touch or self-serve
- ACV: <$10k
- Example: Slack, Notion, Figma

**Sales-Led Growth**:
- Entry: Demo request → Sales qualification
- Buyer: VP → C-level
- Sales: High touch, consultative
- ACV: $25k+
- Example: Salesforce, Workday, SAP

**Hybrid (PLG + Sales)**:
- Entry: Free trial for SMB, demo for Enterprise
- Buyer: End user (PLG) or Executive (Sales-Led)
- Sales: Self-serve → Assisted → Enterprise
- ACV: $5k-$100k
- Example: HubSpot, Atlassian, Zoom

**Series A Recommendation**: Start with **Hybrid**
- Reason: Faster learning, broader TAM, efficient scaling
- Approach:
  - Bottom-up (PLG): Free trial → Paid team plan → Upgrade to Enterprise
  - Top-down (Sales): Outbound to Enterprise → Demo → POC → Close

### 4.2 GTM Launch Playbook (90-Day Plan)

**Pre-Launch (Days -90 to -30)**:

Week 1-4: Foundation
- [ ] Define ICP and buyer personas
- [ ] Develop positioning and messaging
- [ ] Create competitive battlecards
- [ ] Set success metrics (pipeline $, MQLs, win rate)

Week 5-8: Content & Enablement
- [ ] Build website pages (homepage, product, pricing)
- [ ] Create sales deck and demo script
- [ ] Produce launch assets (one-pager, case studies, FAQs)
- [ ] Develop email nurture sequences
- [ ] Train sales team on positioning and talk tracks

Week 9-12: Channel Setup
- [ ] Launch paid campaigns (LinkedIn, Google)
- [ ] Set up HubSpot tracking and attribution
- [ ] Publish SEO content (blog posts, guides)
- [ ] Activate partnerships (co-marketing plans)
- [ ] Test conversion funnels (landing page → signup)

**Launch (Days 1-30)**:

Week 1: Awareness
- [ ] Press release distribution
- [ ] Email announcement to existing database
- [ ] Social media campaign (LinkedIn, Twitter)
- [ ] Paid ads go live (awareness campaigns)
- [ ] Outbound sales blitz (top 100 accounts)

Week 2-4: Activation
- [ ] Monitor conversion rates (daily)
- [ ] A/B test landing pages and ad copy
- [ ] Sales follow-up on inbound leads (<4 hour SLA)
- [ ] Customer interviews (feedback on positioning)
- [ ] Adjust messaging based on early signals

**Post-Launch (Days 31-90)**:

Week 5-8: Optimization
- [ ] Analyze win/loss data (why did we win/lose?)
- [ ] Optimize underperforming channels (pause or pivot)
- [ ] Scale winning channels (20% weekly budget increase)
- [ ] Publish post-launch case studies
- [ ] Expand content (SEO, demand gen)

Week 9-12: Scale
- [ ] Enter new market segments (vertical or geo)
- [ ] Launch partnerships (co-marketing campaigns)
- [ ] Build PLG loops (referral program, viral features)
- [ ] Sales team expansion (hire based on pipeline)
- [ ] Iterate positioning (quarterly messaging refresh)

### 4.3 International Market Entry (EU/US/Canada)

**Market Entry Priority** (Series A recommended order):

**Phase 1: US Market** (Months 1-6)
- Why: Largest TAM, fastest sales cycles, highest ACV
- Entry strategy:
  - Hire US-based SDRs/AEs (or partner with US sales agency)
  - Localize website (USD pricing, US phone number)
  - Paid ads (Google + LinkedIn) targeting US companies
  - Partnerships with US-based tech companies
- Budget: 50% of total marketing spend
- Target: $1M ARR from US by Month 6

**Phase 2: UK Market** (Months 4-9)
- Why: English-speaking, gateway to EU, similar to US
- Entry strategy:
  - Hire UK sales rep or partner with UK agency
  - Localize pricing (GBP), GDPR compliance
  - Content localization (British spelling, cultural nuances)
  - UK partnerships (local SaaS companies)
- Budget: 20% of marketing spend
- Target: $500k ARR from UK by Month 9

**Phase 3: DACH (Germany/Austria/Switzerland)** (Months 7-12)
- Why: Largest EU economy, high data privacy standards
- Entry strategy:
  - Translate website and product (German)
  - Hire German-speaking sales rep
  - GDPR compliance (critical for German market)
  - Partnerships with German tech companies
  - Local case studies and testimonials
- Budget: 15% of marketing spend
- Target: $300k ARR from DACH by Month 12

**Phase 4: France** (Months 10-15)
- Why: Second largest EU market, localization critical
- Entry strategy:
  - Full French translation (website, product, support)
  - Hire French-speaking sales and support
  - French partnerships and case studies
  - Comply with French data regulations
- Budget: 10% of marketing spend
- Target: $200k ARR from France by Month 15

**Phase 5: Canada** (Months 7-12)
- Why: Similar to US, easier entry, smaller market
- Entry strategy:
  - Minimal localization (CAD pricing)
  - Leverage US sales team (similar buying behavior)
  - Canadian partnerships
- Budget: 5% of marketing spend
- Target: $100k ARR from Canada by Month 12

**Localization Checklist (per market)**:

- [ ] **Website**: Translate, localize currency, phone number
- [ ] **Product**: UI translation (if needed for that market)
- [ ] **Pricing**: Local currency, VAT/taxes displayed
- [ ] **Support**: Local business hours, language support
- [ ] **Legal**: Data privacy compliance (GDPR, CCPA)
- [ ] **Sales**: Hire local reps or partner with local agency
- [ ] **Marketing**: Localized ads, content, case studies
- [ ] **Payments**: Local payment methods (SEPA, iDEAL, etc.)

**Budget Allocation** (international expansion):
```
Year 1 (Series A):
- US: 50% ($200k)
- UK: 20% ($80k)
- DACH: 15% ($60k)
- France: 10% ($40k)
- Canada: 5% ($20k)

Total: $400k marketing spend (international)
Expected ROI: 3:1 (marketing-sourced pipeline : spend)
```

---

## 5. Product Launch Framework

### 5.1 Launch Tiers (Effort vs. Impact)

**Tier 1: Major Launch** (quarterly, high impact)
- Scope: New product, major feature, platform expansion
- Audience: Existing customers + new prospects + press
- Effort: 6-8 weeks prep, full cross-functional launch
- Budget: $50k-$100k (Series A)
- Activities: Press release, webinar, email series, paid ads, sales blitz

**Tier 2: Standard Launch** (monthly, medium impact)
- Scope: Significant feature, integration, improvement
- Audience: Existing customers + select prospects
- Effort: 3-4 weeks prep, core team involvement
- Budget: $10k-$25k
- Activities: Blog post, email announcement, product update, sales enablement

**Tier 3: Minor Launch** (weekly, low impact)
- Scope: Small feature, bug fix, optimization
- Audience: Existing customers only
- Effort: 1 week prep, product + marketing only
- Budget: <$5k
- Activities: In-app notification, changelog, support docs

### 5.2 Major Launch Playbook (Tier 1)

**8 Weeks Before Launch**:

Week -8:
- [ ] Kickoff meeting (Product, Marketing, Sales, CS)
- [ ] Define launch goals (pipeline $, MQLs, press coverage)
- [ ] Identify target audience (ICP, personas)
- [ ] Create positioning and messaging
- [ ] Assign roles and responsibilities

Week -7:
- [ ] Develop GTM strategy (channels, tactics, budget)
- [ ] Create sales enablement (deck, demo script, FAQs)
- [ ] Plan content (blog posts, case studies, videos)
- [ ] Design creative assets (ads, social graphics, emails)

Week -6:
- [ ] Build landing pages (product page, demo request)
- [ ] Set up HubSpot campaigns and tracking
- [ ] Write press release and pitch media
- [ ] Create email nurture sequences
- [ ] Produce demo video

Week -5:
- [ ] Beta test with select customers (feedback)
- [ ] Train sales team (positioning, demo, objection handling)
- [ ] Train CS team (onboarding, support docs)
- [ ] Finalize launch timeline and channel mix
- [ ] Prepare customer case studies

**4 Weeks Before Launch**:

Week -4:
- [ ] Launch paid ad campaigns (LinkedIn, Google)
- [ ] Publish teaser content (blog, social)
- [ ] Send pre-launch email to customer base
- [ ] Pitch press and influencers
- [ ] Set up webinar registration

Week -3:
- [ ] A/B test landing pages and ad copy
- [ ] Ramp up content production (blog posts, videos)
- [ ] Sales prospecting (outbound to target accounts)
- [ ] Finalize webinar content and speakers
- [ ] Prepare launch day checklist

Week -2:
- [ ] Send reminder emails (webinar, launch countdown)
- [ ] Increase paid ad spend (ramp up)
- [ ] Sales follow-up on warmed leads
- [ ] Dry run: Test all systems (website, forms, CRM)
- [ ] Prepare launch day assets (social posts, emails)

Week -1:
- [ ] Final review: All assets approved
- [ ] Pre-launch email to VIP customers and partners
- [ ] Sales team ready (trained, motivated, quotas set)
- [ ] CS team ready (docs updated, chat support staffed)
- [ ] Press embargo lifts (if applicable)

**Launch Week**:

Day 1 (Launch Day):
- [ ] Press release goes live (distribute to media)
- [ ] Email announcement to full database
- [ ] Social media blitz (LinkedIn, Twitter, Facebook)
- [ ] Paid ads at full budget
- [ ] Sales outbound campaign (top 500 accounts)
- [ ] Product update in-app (notify existing users)
- [ ] Monitor metrics (signups, demos, press pickup)

Days 2-5:
- [ ] Daily monitoring (conversion rates, funnel drop-offs)
- [ ] A/B test optimizations (headlines, CTAs)
- [ ] Sales follow-up (4-hour SLA on inbound leads)
- [ ] Respond to press inquiries
- [ ] Post customer testimonials and early wins
- [ ] Webinar (Day 3 or 4)

Week 2:
- [ ] Analyze launch results (vs. goals)
- [ ] Publish post-launch content (case studies, how-to guides)
- [ ] Sales continue outbound (sustained momentum)
- [ ] Optimize underperforming channels
- [ ] Scale winning channels (increase budget)

Week 3-4:
- [ ] Post-launch report (metrics, learnings, next steps)
- [ ] Customer feedback interviews (product improvements)
- [ ] Win/loss analysis (why did we win/lose deals?)
- [ ] Adjust messaging and positioning (based on feedback)
- [ ] Plan next launch (apply learnings)

### 5.3 Launch Metrics Dashboard

**Leading Indicators** (track daily):
- Landing page visitors
- Demo requests
- Free trial signups
- MQLs generated
- Sales pipeline created ($)

**Lagging Indicators** (track weekly/monthly):
- SQLs generated
- Deals closed (count + $)
- Win rate (vs. pre-launch)
- Customer adoption rate (% of customers using feature)
- NPS score (feature-specific)

**HubSpot Dashboard**:
```
Launch Campaign: [Q2-2025-Product-X-Launch]

WEEK 1 RESULTS:
Traffic: 10,000 visitors (goal: 8,000) ✅
MQLs: 250 (goal: 200) ✅
SQLs: 40 (goal: 50) ⚠️
Pipeline: $800k (goal: $1M) ⚠️
Demos: 80 (goal: 100) ⚠️

TOP CHANNELS:
1. LinkedIn Ads: 120 MQLs, $150 CPL
2. Email: 80 MQLs, $25 CPL
3. Organic: 40 MQLs, $0 CPL

UNDERPERFORMING:
- Google Search: 10 MQLs, $400 CPL (pause and optimize)
- Webinar: 50 registrants, 20% show rate (improve email reminders)

NEXT ACTIONS:
- Increase LinkedIn Ads budget by 30%
- A/B test new landing page headline
- Sales follow-up blitz on 40 SQLs
```

---

## 6. Sales Enablement & Collaboration

### 6.1 Sales Enablement Assets (Must-Have)

**Core Assets**:

**1. Sales Deck** (15-20 slides)
```
Slide 1: Title slide (logo, tagline)
Slide 2: Agenda
Slide 3: Company intro (mission, vision, traction)
Slide 4: Problem statement (customer pain points)
Slide 5: Solution overview (your product)
Slide 6: Key benefits (3-5 bullets)
Slide 7: Product demo (screenshots or video)
Slide 8: Differentiation (vs. competitors)
Slide 9: Customer logos (social proof)
Slide 10: Case study (results-focused)
Slide 11: Pricing and plans
Slide 12: Implementation timeline
Slide 13: Support and success
Slide 14: Next steps (CTA)
Slide 15: Q&A

Guidelines:
- Visual-first (minimal text, large images)
- Customer-centric (benefits > features)
- Modular (easy to skip/reorder slides)
- Updated quarterly (or after major product changes)
```

**2. One-Pagers** (1-page PDF)
- Product overview (what it is, who it's for, key features)
- Competitive comparison (vs. Competitor A, B, C)
- Case study (customer story with metrics)
- Pricing sheet (plans, features, add-ons)

**3. Battlecards** (per competitor)
- See Section 3.2 for detailed battlecard template

**4. Demo Script** (30-45 min)
```
Demo Flow:
1. Intro (2 min) - Who we are, what we'll cover
2. Discovery (5 min) - Ask about their needs, pain points
3. Demo (20 min) - Show product (focus on their use case)
4. Q&A (10 min) - Address objections, questions
5. Next steps (3 min) - Define trial or POC plan

Demo Tips:
- Show, don't tell (product in action > slides)
- Use customer data (not "Company XYZ" examples)
- Focus on outcomes (not features)
- Address objections proactively (price, competition)
- Always drive to next step (trial, POC, proposal)
```

**5. Email Templates** (HubSpot sequences)
- Cold outreach (prospecting)
- Demo follow-up
- Trial conversion
- Proposal sent
- Closing sequence

**6. ROI Calculator** (spreadsheet or web tool)
- Input: Customer's current costs, time spent, team size
- Output: Savings with your product, payback period, 3-year ROI
- Example: "Save $150k/year, 6-month payback, 500% ROI"

### 6.2 Sales Training Program

**Monthly Sales Enablement Call** (60 min):
- Product updates (new features, roadmap)
- Competitive landscape (new competitors, battlecard updates)
- Win/loss insights (why we're winning/losing)
- Best practices (top performer shares tips)
- Q&A (open forum for questions)

**Quarterly Sales Training** (half-day workshop):
- Deep dive: Positioning and messaging refresh
- Role-playing: Objection handling, competitive demos
- Product training: New features, advanced use cases
- Customer panel: Hear directly from customers (why they bought)

**Sales Onboarding** (new hires):
- Week 1: Company, product, market overview
- Week 2: ICP, personas, messaging
- Week 3: Competitive intelligence, battlecards
- Week 4: Demo certification (must pass to sell)

### 6.3 Marketing ↔ Sales Handoffs

**MQL → SQL Handoff** (see marketing-demand-acquisition skill for details)

**Product Marketing → Sales**:

**Weekly Sync** (30 min):
- Review: Win/loss insights, competitive updates
- Share: New assets (battlecards, case studies, one-pagers)
- Feedback: What's working, what's not
- Request: Sales asks for specific assets (e.g., "Need competitor X battlecard")

**Quarterly Business Review** (QBR):
- Results: Pipeline, win rate, deal size, sales velocity
- Insights: Top win/loss reasons, competitive trends
- Action items: Product gaps, messaging updates, enablement needs

**Communication Channels**:
- Slack: #sales-enablement (daily questions, quick updates)
- HubSpot: Centralized asset library (decks, one-pagers, videos)
- Notion: Internal wiki (positioning, messaging, competitive intel)

---

## 7. Metrics & Analytics

### 7.1 PMM KPIs (Track Monthly)

**Product Adoption**:
- % of customers using new feature (within 30 days of launch)
- Target: >40% adoption within 90 days

**Sales Velocity**:
- Days from SQL to closed won
- Target: Decrease by 20% YoY

**Win Rate**:
- % of opportunities won (vs. competitors)
- Target: >30% win rate (competitive deals)

**Deal Size**:
- Average contract value (ACV)
- Target: Increase by 25% YoY

**Launch Impact**:
- Pipeline $ generated from launch campaigns
- Target: 3:1 ROMI (pipeline $ : marketing spend)

**Competitive Win Rate**:
- % of deals won against Competitor A, B, C
- Target: >35% win rate vs. top competitor

### 7.2 HubSpot Reporting

**Custom Reports**:

**1. Product Launch Impact**
```
Metrics: Leads, MQLs, SQLs, Pipeline $, Closed Won $
Dimensions: Campaign, Channel, Region
Filters: Campaign = "Q2-2025-Product-X-Launch"
Time period: 90 days post-launch
```

**2. Competitive Win Rate**
```
Metrics: Opportunities, Closed Won, Win Rate %
Dimensions: Competitor (property)
Filters: Deal stage = Closed Won or Closed Lost
Segment by: Competitor A, B, C, Other
```

**3. Sales Enablement Usage**
```
Metrics: Asset downloads, views, shares
Dimensions: Asset type (deck, battlecard, case study)
Filters: User = Sales team
Insight: Which assets are most used by sales
```

### 7.3 Quarterly Business Review (QBR)

**QBR Template** (present to executive team):

**Slide 1: Executive Summary**
```
Q2 2025 Highlights:
- Launched Product X (pipeline: $2M, 500 MQLs)
- Entered UK market (20 new customers, $400k ARR)
- Improved win rate by 15% (competitive positioning)
- Published 3 case studies (2x sales usage vs. Q1)
```

**Slide 2: Metrics Dashboard**
```
KPI             Q2 Target   Q2 Actual   Status
─────────────────────────────────────────────
MQLs            800         950         ✅ +19%
SQLs            150         140         ⚠️ -7%
Pipeline $      $4M         $3.8M       ⚠️ -5%
Win Rate        30%         35%         ✅ +17%
Deal Size       $45k        $52k        ✅ +16%
Sales Velocity  75 days     68 days     ✅ -9%
```

**Slide 3: Key Insights**
```
What Worked:
1. Product X launch exceeded MQL target by 19%
2. Improved competitive positioning → 35% win rate
3. UK market entry on track ($400k ARR in 3 months)

What Didn't Work:
1. SQL conversion rate dropped from 20% to 15%
2. Google Ads underperformed (paused and optimizing)
3. Competitor A launched aggressive pricing (5 lost deals)

Action Items:
1. Improve SQL qualification criteria (work with sales)
2. Update battlecard for Competitor A (new pricing)
3. Double down on UK market (hire local AE)
```

**Slide 4: Next Quarter Plan**
```
Q3 2025 Priorities:
1. Launch Product Y (pipeline target: $3M)
2. Enter DACH market (Germany, Austria, Switzerland)
3. Refresh messaging and website (new positioning)
4. Scale partnerships (3 new strategic partners)
5. Build customer advocacy program (10 case studies)

Budget: $150k (up from $120k in Q2)
Headcount: +1 PMM, +1 Content Marketer
```

---

## 8. Quick Reference

### 8.1 PMM Monthly Checklist

**Week 1** (Strategy & Planning):
- [ ] Review previous month metrics (win rate, deal size, pipeline)
- [ ] Analyze win/loss interviews (competitive trends)
- [ ] Update competitive battlecards (if needed)
- [ ] Plan next month campaigns and content

**Week 2** (Content & Enablement):
- [ ] Create new sales assets (1-pager, case study, deck update)
- [ ] Publish content (blog post, video, webinar)
- [ ] Train sales on new positioning or product updates
- [ ] Review sales asset usage (what's working?)

**Week 3** (Launches & Campaigns):
- [ ] Support product launches (if any)
- [ ] Monitor campaign performance (MQLs, SQLs, pipeline)
- [ ] Optimize underperforming channels
- [ ] Customer interviews (feedback on positioning)

**Week 4** (Reporting & Iteration):
- [ ] Monthly metrics report (for exec team)
- [ ] Sales enablement call (updates, Q&A)
- [ ] Win/loss analysis (themes, trends)
- [ ] Plan next quarter launches and strategy

### 8.2 Positioning Development Timeline

**Week 1**: Research
- Customer interviews (10-15)
- Competitive analysis
- Market trends

**Week 2**: Framework
- April Dunford positioning exercise
- Define unique value
- Identify best-fit customers

**Week 3**: Messaging
- Craft value proposition
- Build messaging hierarchy
- Create persona-specific messaging

**Week 4**: Validation
- Test with sales team
- A/B test on landing pages
- Customer feedback

**Week 5-6**: Rollout
- Update website, sales decks
- Train sales and CS teams
- Launch campaigns with new messaging

### 8.3 Team Handoff Protocols

**PMM → Demand Gen**:
- Deliver: Positioning, messaging, competitive intel, launch plans
- Frequency: Monthly sync + ad-hoc for launches
- SLA: 2-week lead time for major campaigns

**PMM → Sales**:
- Deliver: Battlecards, sales decks, demo scripts, objection handling
- Frequency: Monthly enablement call + weekly Slack updates
- SLA: 48 hours for urgent competitive questions

**PMM → Product**:
- Deliver: Customer feedback, competitive feature gaps, win/loss insights
- Frequency: Weekly product sync
- SLA: Quarterly roadmap input (feature prioritization)

**PMM → Customer Success**:
- Deliver: Product positioning, adoption tactics, customer education content
- Frequency: Monthly sync
- SLA: 1 week for new product launch enablement

---

## Resources

### references/

- **positioning-frameworks.md** - Detailed guide on April Dunford, Geoffrey Moore positioning methods
- **launch-checklists.md** - Tier 1/2/3 launch checklists and templates
- **international-gtm.md** - Market-by-market expansion playbooks (US, UK, DACH, France, Canada)
- **messaging-templates.md** - Ready-to-use messaging frameworks for different personas

### scripts/

- **competitor_tracker.py** - Track competitor website/pricing changes
- **win_loss_analyzer.py** - Analyze win/loss interview data for trends

### assets/

- **sales-deck-template.pptx** - Editable master sales deck
- **battlecard-template.docx** - Competitive battlecard template
- **one-pager-template.pptx** - Product one-pager design template
- **roi-calculator.xlsx** - ROI calculator spreadsheet

---

**Last Updated**: October 2025 | **Version**: 1.0
