---
name: marp-slide-reviewer
description: ローカルサーバーで起動している Marp スライドを視覚的に検証し、レイアウト問題を自動修正するスキル。「スライドをレビュー」「Marp スライドの視覚的チェック」「スライドのレイアウトを確認」「プレゼン資料の見た目を検証」などのリクエストでトリガーします。テキストの切れ目、重なり、配置問題、コントラスト不足、はみ出し、余白不足などの視覚的問題を検出・修正します。
---

# Marp スライドレビュアー

このスキルは、Marp スライドの視覚的な品質を検証し、問題を自動修正します。

## 前提条件

- ユーザーがローカルサーバーでスライドを起動していること
- URL は `http://localhost:8080/slide.md` のような形式
- 各スライドは `{BASE_URL}#1`, `{BASE_URL}#2` でアクセス可能（1始まり）

## ワークフロー

### ステップ 1: URL の確認

URL が提供されていない場合、必ずユーザーに質問する：

> スライドの URL を教えてください（例: `http://localhost:8080/slide.md`）

**重要**: URL が不明な状態では処理を開始しないこと。

### ステップ 2: スライドの総数確認

1. 指定 URL にブラウザでアクセス
2. ページのスナップショットを取得
3. ページネーションまたはスライド番号からスライド総数を判断

### ステップ 3: 各スライドの視覚検証

各スライド（1〜N）に対して以下を実行：

1. `{BASE_URL}#{SLIDE_NUMBER}` にアクセス
2. スクリーンショットを撮影
3. 画像を分析し、視覚的問題を確認

#### 確認項目

| 問題 | 説明 |
|------|------|
| テキストの切れ目 | ヘッダーバー、図形、スライド端でテキストが切れている |
| テキストの重なり | テキストが他のテキストや図形と重なっている |
| 配置の問題 | コンテンツが境界や他要素に近すぎる |
| コントラスト不足 | テキストと背景のコントラストが不十分 |
| はみ出し | コンテンツがスライド領域からはみ出している |
| 余白の不足 | 要素間の余白が不十分で窮屈に見える |

### ステップ 4: 問題の修正

問題が見つかった場合：

1. 元の Markdown ファイルを読み込む
2. 問題スライドのセクションを特定（`---` で区切られた箇所）
3. 修正を適用

修正テクニックの詳細は [references/fix-techniques.md](references/fix-techniques.md) を参照。

### ステップ 5: 修正後の再検証

1. ブラウザをリロード（同じ URL に再アクセス）
2. 修正後のスライドをスクリーンショットで確認
3. 問題が解消されるまでステップ 3-5 を繰り返す

## 注意事項

- 修正は最小限に留め、元のデザイン意図を尊重する
- 大幅な変更が必要な場合はユーザーに確認を取る
- スライドの内容（テキスト）は変更せず、レイアウトのみを修正する
- 修正履歴をユーザーに報告する

## 出力形式

検証・修正完了時、以下の形式で報告：

```markdown
# スライドレビュー結果

## 検証サマリー

- 検証 URL: {URL}
- 総スライド数: {N} 枚
- 問題検出数: {M} 件
- 修正完了数: {X} 件

## 検出された問題と修正内容

### スライド {番号}

- **問題**: {問題の説明}
- **修正内容**: {修正の説明}

（問題があったスライドごとに記載）

## 最終確認

すべてのスライドの視覚的な問題が解消されました。
```

## 必要な能力

このスキルを実行するには、以下の能力が必要です：

| 能力 | 説明 |
|------|------|
| ウェブページナビゲーション | 指定 URL へのアクセス、ページ遷移 |
| スクリーンショット撮影 | 表示中のページの画像キャプチャ |
| 画像分析 | スクリーンショットの視覚的問題検出 |
| ファイル読み書き | Markdown ファイルの読み込みと編集 |

## Reference Implementation

### Playwright MCP を使用した実装

このスキルは [Playwright MCP](https://github.com/anthropics/anthropic-cookbook/tree/main/misc/mcp) を使用して実装できます。

| 能力 | Playwright MCP ツール |
|------|----------------------|
| ウェブページナビゲーション | `mcp_playwright_browser_navigate` |
| スナップショット取得 | `mcp_playwright_browser_snapshot` |
| スクリーンショット撮影 | `mcp_playwright_browser_take_screenshot` |

その他のブラウザ自動化ツール（Selenium、Puppeteer など）でも同様の実装が可能です。
