# 选题角度分析模板

> 本模板用于 Strategist 分析每个选题角度的可行性、传播潜力和平台适配度。

---

## 基本信息

**选题来源：** [Topic Scout 提供的选题]
**分析日期：** YYYY-MM-DD
**分析者：** Strategist

---

## 角度概述

### 角度名称
[给这个角度起一个简短、描述性的名称]

### 核心观点
[用一句话概括这个角度的核心观点]

### 目标受众
[这个角度最适合哪类受众？]

---

## 可行性分析

### 素材充足度
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**素材清单：**
- [ ] 数据/统计：[是否有充足的数据支撑？]
- [ ] 案例/例子：[是否有具体案例？]
- [ ] 截图/图片：[是否有配图素材？]
- [ ] 引用/来源：[是否有权威引用？]

**素材评估：**
- 已有素材：[列出]
- 需补充素材：[列出]
- 获取难度：高/中/低

**结论：**
✅ 素材充足，可直接创作
⚠️ 需补充部分素材
❌ 素材不足，不建议此角度

---

### 专业度要求
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**所需专业知识：**
- [领域 1]: 了解/熟悉/精通
- [领域 2]: 了解/熟悉/精通
- [领域 3]: 了解/熟悉/精通

**我的专业水平：**
- [匹配度评估]
- [是否需要额外研究？]

**结论：**
✅ 专业度匹配，可驾驭
⚠️ 需要额外研究
❌ 超出专业范围

---

### 独特性评估
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**市场现状：**
- 类似内容数量：多/中/少
- 竞品质量：高/中/低
- 内容同质化程度：高/中/低

**我的独特性：**
- 独特视角：[描述]
- 个人经历：[描述]
- 数据/案例：[描述]

**差异化策略：**
- [如何与现有内容区分？]
- [我能提供什么新价值？]

**结论：**
✅ 高度独特，有差异化
⚠️ 中等独特性，需强化
❌ 缺乏独特性，不建议

---

### 时效性评估
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**时间敏感度：**
- [ ] 热点相关（需 24-48 小时内发布）
- [ ] 趋势相关（需 1-2 周内发布）
- [ ] 常青内容（无时间限制）

**最佳发布时间窗口：**
- 开始时间：[日期]
- 结束时间：[日期]
- 理由：[为什么？]

**结论：**
✅ 时机合适
⚠️ 需抓紧时间
❌ 时机已过

---

## 传播潜力分析

### 用户痛点匹配度
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**核心痛点：**
- 痛点 1：[描述]
- 痛点 2：[描述]
- 痛点 3：[描述]

**受众规模：**
- 潜在受众：大/中/小
- 痛点强度：强/中/弱
- 解决紧迫性：高/中/低

**结论：**
✅ 强痛点，高共鸣
⚠️ 中等痛点
❌ 弱痛点，共鸣低

---

### 话题热度评估
**评分：** ⭐⭐⭐⭐⭐ (X/5)

**话题热度：**
- 搜索指数：[数据]
- 社交讨论度：高/中/低
- 媒体报道量：多/中/少

**趋势判断：**
- [ ] 上升期（正在变热）
- [ ] 高峰期（当前最热）
- [ ] 平稳期（持续关注）
- [ ] 下降期（热度消退）

**结论：**
✅ 热度高，有流量基础
⚠️ 热度中等
❌ 热度低，流量有限

---

### 传播动机分析

**用户为什么会分享这个内容？**

**功能性动机：**
- [ ] 有用（实用价值，收藏参考）
- [ ] 有趣（娱乐价值，会心一笑）
- [ ] 有料（信息价值，学到新知）

**社交性动机：**
- [ ] 表达态度（我支持/反对这个观点）
- [ ] 展示品味（我关注这类话题）
- [ ] 帮助他人（对朋友有用）
- [ ] 引发讨论（我想听听别人看法）

**情感性动机：**
- [ ] 共鸣（说出了我的心声）
- [ ] 认同（我也有类似经历）
- [ ] 震撼（颠覆了我的认知）

**传播潜力评估：**
- 传播动机数量：[X] 个
- 主要传播动机：[最强的 1-2 个]
- 预期传播效果：高/中/低

**结论：**
✅ 多重传播动机，传播潜力大
⚠️ 有传播动机，但不强
❌ 传播动机弱

---

## 平台适配度分析

### 微信公众号
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合微信？]
- [受众匹配度如何？]
- [内容形式是否合适？]

**潜在问题：**
- [可能遇到的问题]
- [如何规避？]

**预期表现：**
- 阅读量预期：[区间]
- 分享率预期：高/中/低
- 涨粉效果：好/中/差

**建议：**
✅ 强烈推荐在微信发布
⚠️ 可以发，但需调整 [具体调整]
❌ 不建议在微信发布

---

### 知乎
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合知乎？]
- [问题匹配度如何？]
- [专业性是否足够？]

**潜在问题：**
- [可能遇到的问题]
- [如何应对质疑？]

**预期表现：**
- 点赞数预期：[区间]
- 评论质量：高/中/低
- 持续流量：有/一般/无

**建议：**
✅ 强烈推荐在知乎发布
⚠️ 可以发，但需强化 [具体方面]
❌ 不建议在知乎发布

---

### 小红书
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合小红书？]
- [受众年龄/性别匹配度？]
- [话题契合度如何？]

**潜在问题：**
- [可能遇到的问题]
- [视觉呈现是否足够？]

**预期表现：**
- 浏览量预期：[区间]
- 收藏率预期：高/中/低
- 互动率预期：高/中/低

**建议：**
✅ 强烈推荐在小红书发布
⚠️ 可以发，但需优化 [视觉/语言]
❌ 不建议在小红书发布

---

### Reddit
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合 Reddit？]
- [哪个 subreddit 最合适？]
- [真实性是否足够？]

**潜在问题：**
- [可能遇到的问题]
- [如何避免被视为营销？]

**预期表现：**
- Upvotes 预期：[区间]
- 评论讨论度：高/中/低
- 社区反应：积极/中立/负面

**建议：**
✅ 强烈推荐在 Reddit 发布
⚠️ 可以发，但需注意 [具体事项]
❌ 不建议在 Reddit 发布

---

### Medium
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合 Medium？]
- [深度是否足够？]
- [叙事性如何？]

**潜在问题：**
- [可能遇到的问题]
- [文笔是否达标？]

**预期表现：**
- 阅读量预期：[区间]
- Claps 预期：[区间]
- 收藏/highlight：高/中/低

**建议：**
✅ 强烈推荐在 Medium 发布
⚠️ 可以发，但需提升 [具体方面]
❌ 不建议在 Medium 发布

---

### LinkedIn
**适配度：** ⭐⭐⭐⭐⭐ (X/5)

**适合理由：**
- [为什么适合 LinkedIn？]
- [职场价值是否明确？]
- [受众是否专业人士？]

**潜在问题：**
- [可能遇到的问题]
- [是否过于技术/消费？]

**预期表现：**
- 浏览量预期：[区间]
- 互动率预期：高/中/低
- 专业影响力：强/中/弱

**建议：**
✅ 强烈推荐在 LinkedIn 发布
⚠️ 可以发，但需调整 [具体角度]
❌ 不建议在 LinkedIn 发布

---

## 风险评估

### 内容风险
**风险等级：** 🔴高风险 / 🟡中风险 / 🟢低风险

**可能的风险点：**
- [ ] 政治敏感性
- [ ] 商业利益冲突
- [ ] 事实准确性存疑
- [ ] 可能引发争议
- [ ] 涉及隐私问题
- [ ] 版权/引用问题

**风险详情：**
- 风险 1：[描述 + 应对策略]
- 风险 2：[描述 + 应对策略]

**规避方案：**
- [如何降低风险？]
- [是否需要修改角度？]

---

### 品牌形象风险
**风险等级：** 🔴高风险 / 🟡中风险 / 🟢低风险

**品牌一致性检查：**
- [ ] 符合我的人设和价值观
- [ ] 不会损害专业形象
- [ ] 不会引起负面联想
- [ ] 长期看有益于品牌建设

**潜在影响：**
- 正面影响：[描述]
- 负面影响：[描述]
- 中性影响：[描述]

---

## 综合评估

### 总体评分
**综合得分：** XX/100

**评分明细：**
- 可行性 (25分)：XX
  - 素材充足度：XX
  - 专业度匹配：XX
  - 独特性：XX
  - 时效性：XX
  
- 传播潜力 (35分)：XX
  - 痛点匹配度：XX
  - 话题热度：XX
  - 传播动机：XX
  
- 平台适配度 (30分)：XX
  - 微信：XX
  - 知乎：XX
  - 小红书：XX
  - Reddit：XX
  - Medium：XX
  - LinkedIn：XX
  
- 风险可控性 (10分)：XX
  - 内容风险：XX
  - 品牌风险：XX

---

### 优势分析
**这个角度的核心优势：**
1. [优势 1]
2. [优势 2]
3. [优势 3]

---

### 劣势分析
**这个角度的主要劣势：**
1. [劣势 1]
2. [劣势 2]
3. [劣势 3]

---

### 机会分析
**可以抓住的机会：**
1. [机会 1]
2. [机会 2]
3. [机会 3]

---

### 威胁分析
**需要注意的威胁：**
1. [威胁 1]
2. [威胁 2]
3. [威胁 3]

---

## 最终建议

### 是否推荐采用此角度？
- [ ] ✅ **强烈推荐** - 优秀角度，应优先创作
- [ ] ⚠️ **可以采用** - 不错的角度，可以创作，但需注意 [具体事项]
- [ ] ❌ **不建议采用** - 存在明显问题，不建议创作

### 推荐理由
[详细说明为什么推荐或不推荐]

---

### 优先级评定
如果采用，建议优先级：
- [ ] 🔴 **高优先级** - 应立即创作
- [ ] 🟡 **中优先级** - 排期创作
- [ ] 🟢 **低优先级** - 有空再做

---

### 推荐平台组合
**最适合发布的平台（按优先级）：**
1. [平台 1] - 适配度 XX/5 - 预期效果：[简述]
2. [平台 2] - 适配度 XX/5 - 预期效果：[简述]
3. [平台 3] - 适配度 XX/5 - 预期效果：[简述]

**不推荐发布的平台：**
- [平台 X] - 原因：[简述]

---

### 创作建议

**写作要点：**
- 必须突出：[要点 1]
- 必须避免：[禁忌 1]
- 建议强化：[方向 1]

**素材补充建议：**
- 需要补充：[素材类型]
- 获取方式：[如何获取]

**风格建议：**
- 微信版：[风格建议]
- 知乎版：[风格建议]
- 小红书版：[风格建议]
- Reddit版：[风格建议]
- Medium版：[风格建议]
- LinkedIn版：[风格建议]

---

## 附录

### 参考素材清单
- 素材 1：[来源] - [描述]
- 素材 2：[来源] - [描述]
- 素材 3：[来源] - [描述]

### 竞品内容分析
- 竞品 1：[链接] - [优缺点分析]
- 竞品 2：[链接] - [优缺点分析]

### 关键词清单
- 主关键词：[列出]
- 长尾关键词：[列出]
- 相关话题标签：[列出]

---

**分析完成日期：** YYYY-MM-DD
**下一步：** 如果采用此角度，进入选题方案撰写阶段