# 写作简报模板 (Writing Brief Template)

> 本模板用于 Strategist 为每个平台的写手提供清晰、完整的写作指令。

---

## 简报信息

**选题：** [选题标题]
**角度：** [选题角度名称]
**目标平台：** [微信/知乎/小红书/Reddit/Medium/LinkedIn]
**写手：** [Writer 名称]
**创建日期：** YYYY-MM-DD
**截稿日期：** YYYY-MM-DD

---

## 核心观点

### 一句话概括
[用一句话说清楚这篇文章的核心观点]

### 核心论点
[展开论述核心观点，3-5 句话]

---

## 目标受众

### 主要受众
- **人群画像：** [年龄、职业、兴趣]
- **痛点需求：** [他们面临什么问题？]
- **阅读动机：** [为什么会读这篇文章？]
- **期望收获：** [读完想得到什么？]

### 次要受众
- [如果有次要受众，描述其特征]

---

## 内容方向

### 必须包含的要点
1. **要点 1：** [描述]
   - 为什么重要：[说明]
   - 如何展开：[建议]

2. **要点 2：** [描述]
   - 为什么重要：[说明]
   - 如何展开：[建议]

3. **要点 3：** [描述]
   - 为什么重要：[说明]
   - 如何展开：[建议]

### 可选的要点
- 要点 A：[如果篇幅允许可以加入]
- 要点 B：[如果合适可以提及]

### 必须避免的内容
- ❌ [不要写的内容 1]
- ❌ [不要写的内容 2]
- ❌ [不要写的内容 3]

---

## 素材库

### 核心素材
**素材位置：** `workflow/02-materials/[文件夹]/`

**重点素材清单：**

**1. 数据/统计：**
- 素材：[具体数据]
- 来源：[出处]
- 用途：[在哪里使用]
- 文件：`[文件路径]`

**2. 案例/例子：**
- 案例：[描述]
- 来源：[出处]
- 用途：[在哪里使用]
- 文件：`[文件路径]`

**3. 引用/观点：**
- 引用：[内容]
- 来源：[出处]
- 用途：[在哪里使用]
- 文件：`[文件路径]`

**4. 截图/图片：**
- 图片：[描述]
- 来源：[出处]
- 用途：[在哪里使用]
- 文件：`[文件路径]`

### 补充素材
- [其他可用素材]
- [备选素材]

### 素材使用注意事项
⚠️ **重要提醒：**
- [版权注意事项]
- [引用规范]
- [数据时效性]

---

## 平台特定要求

### [平台名称] 特定指南

**文章规格：**
- **字数要求：** [范围]
- **标题长度：** [字符数]
- **段落要求：** [每段多少行]
- **配图数量：** [张数]

**风格要求：**
- **语气：** [正式/轻松/专业/活泼]
- **人称：** [第一人称/第二人称/第三人称]
- **专业度：** [高/中/低]
- **口语化程度：** [高/中/低]

**结构建议：**
```
开头：[具体要求]
├─ [要点]
└─ [要点]

正文：[具体要求]
├─ 小节 1：[主题]
├─ 小节 2：[主题]
└─ 小节 3：[主题]

结尾：[具体要求]
├─ [要点]
└─ [要点]
```

**格式要求：**
- [ ] [格式要求 1]
- [ ] [格式要求 2]
- [ ] [格式要求 3]

---

## 标题方向

### 推荐标题角度

**方向 1：** [标题类型]
```
标题示例：
- "[示例 1]"
- "[示例 2]"
- "[示例 3]"

为什么适合：[说明]
```

**方向 2：** [标题类型]
```
标题示例：
- "[示例 1]"
- "[示例 2]"
- "[示例 3]"

为什么适合：[说明]
```

**方向 3：** [标题类型]
```
标题示例：
- "[示例 1]"
- "[示例 2]"
- "[示例 3]"

为什么适合：[说明]
```

### 标题禁忌
❌ 避免使用：
- [禁忌 1]
- [禁忌 2]
- [禁忌 3]

---

## 开头建议

### 推荐开头方式

**选项 1：场景切入**
```
[场景描述]
↓
[引出问题/矛盾]
↓
[过渡到主题]

示例：
"[具体示例]"
```

**选项 2：数据震撼**
```
[惊人数据/事实]
↓
[解释意义]
↓
[引出主题]

示例：
"[具体示例]"
```

**选项 3：提问引入**
```
[戳中痛点的问题]
↓
[共鸣/好奇]
↓
[引出主题]

示例：
"[具体示例]"
```

### 开头要求
✅ 必须做到：
- [要求 1]
- [要求 2]
- [要求 3]

❌ 必须避免：
- [禁忌 1]
- [禁忌 2]

---

## 结构指引

### 推荐大纲
```
【标题】[方向提示]

【开头】(XX-XX 字)
- 钩子
- 背景/问题
- 预告/过渡

【正文】

## 第一部分：[小标题建议]
(XX-XX 字)
- [要点 1]
- [要点 2]
- [示例/数据]

## 第二部分：[小标题建议]
(XX-XX 字)
- [要点 1]
- [要点 2]
- [示例/数据]

## 第三部分：[小标题建议]
(XX-XX 字)
- [要点 1]
- [要点 2]
- [示例/数据]

【结尾】(XX-XX 字)
- 总结/升华
- 行动建议/思考
- 互动引导
```

### 结构灵活度
- [ ] 严格按照大纲 - 必须遵守结构
- [ ] 参考大纲 - 可适度调整
- [ ] 自由发挥 - 只需包含核心要点

---

## 风格指引

### 语言风格

**✅ 推荐的表达方式：**
- [表达方式 1]
- [表达方式 2]
- [表达方式 3]

**❌ 避免的表达方式：**
- [表达方式 1]
- [表达方式 2]
- [表达方式 3]

### 举例说明

**好的示例：**
```
"[示例段落]"

为什么好：[分析]
```

**不好的示例：**
```
"[示例段落]"

为什么不好：[分析]
```

---

## 人设和价值观

### 必须体现的人设特征
- [人设特征 1]：[如何体现]
- [人设特征 2]：[如何体现]
- [人设特征 3]：[如何体现]

### 必须传递的价值观
- [价值观 1]：[如何传递]
- [价值观 2]：[如何传递]
- [价值观 3]：[如何体现]

### 参考文章
**请务必阅读以下参考文章，学习风格：**
- `persona/past-articles/[平台]-[标题].md`
- `persona/past-articles/[平台]-[标题].md`

**重点学习：**
- [学习要点 1]
- [学习要点 2]

---

## 配图建议

### 必须配图的位置
1. **封面图：** [要求/建议]
2. **正文配图 1：** [位置] - [内容要求]
3. **正文配图 2：** [位置] - [内容要求]
4. **正文配图 3：** [位置] - [内容要求]

### 配图风格
- 整体风格：[描述]
- 色调：[描述]
- 类型偏好：[截图/概念图/数据图]

### 配图来源
- [推荐来源 1]
- [推荐来源 2]
- 素材库：`workflow/02-materials/images/`

---

## 关键词和标签

### SEO 关键词
**主关键词：** [词1], [词2], [词3]
**长尾关键词：** [词组1], [词组2], [词组3]

### 话题标签（根据平台）
**微信：** 不需要
**知乎：** [话题1], [话题2], [话题3]
**小红书：** #[标签1] #[标签2] #[标签3] #[标签4] #[标签5]
**Reddit:** r/[subreddit]
**Medium:** [Tag1], [Tag2], [Tag3], [Tag4], [Tag5]
**LinkedIn:** #[Hashtag1] #[Hashtag2] #[Hashtag3]

---

## 质量标准

### 必须达到的标准
- [ ] 观点清晰，论证充分
- [ ] 素材运用恰当，有理有据
- [ ] 结构清晰，逻辑严密
- [ ] 符合平台调性
- [ ] 体现个人风格
- [ ] 无明显错误（错别字、逻辑漏洞）
- [ ] [平台特定标准]

### 加分项
- [ ] 有独特洞察
- [ ] 有新鲜案例/数据
- [ ] 有情感共鸣
- [ ] 视觉呈现出色
- [ ] [其他加分项]

---

## 特别注意事项

### ⚠️ 风险提醒
- [风险点 1]：[如何规避]
- [风险点 2]：[如何规避]
- [风险点 3]：[如何规避]

### 📌 重点强调
- [重点 1]
- [重点 2]
- [重点 3]

### 💡 创作提示
- [提示 1]
- [提示 2]
- [提示 3]

---

## 时间安排

### 创作时间表
- **开始时间：** [日期时间]
- **截稿时间：** [日期时间]
- **审稿时间：** [预留时间]

### 里程碑
- [ ] 大纲完成：[日期]
- [ ] 初稿完成：[日期]
- [ ] 自检完成：[日期]
- [ ] 提交审核：[日期]

---

## 交付要求

### 文件命名
`[平台]-[角度关键词]-[日期]-draft.md`

示例：`wechat-atlas-privacy-20241103-draft.md`

### 保存位置
`workflow/04-drafts/[平台]/[文件名]`

### 文件格式
```markdown
---
# Metadata
title: [最终标题]
platform: [平台]
angle: [角度]
word_count: [字数]
created: [日期时间]
writer: [Writer 名称]
status: Draft
---

# [标题]

[正文内容]

---

【创作说明】
- 创作思路：[简述]
- 素材使用：[列出使用的素材]
- 特殊处理：[如果有特殊处理说明]
- 自检情况：[自我评估]
```

---

## 成功标准

### 这篇文章成功的标志：
- [标准 1]：[具体指标]
- [标准 2]：[具体指标]
- [标准 3]：[具体指标]

### 预期效果：
- **阅读/浏览量：** [预期范围]
- **互动率：** [预期]
- **传播效果：** [预期]

---

## 支持和反馈

### 如有疑问
- 可以随时联系 Orchestrator
- 参考相关平台指南：`platforms/[平台]-guide.md`
- 参考过往优秀案例：`persona/past-articles/`

### 创作完成后
- 提交到指定位置
- 通知 Orchestrator
- 等待进入筛选和审校流程

---

**简报创建时间：** YYYY-MM-DD HH:MM
**简报创建者：** Strategist
**下一步：** 开始创作，截稿时间见上方