# 初稿检查清单 (Draft Checklist)

> 本清单供各平台 Writer 在完成初稿后进行自我检查，确保稿件质量。

---

## 使用说明

### 何时使用
- ✅ 初稿完成后，提交前
- ✅ 作为写作过程中的参考
- ❌ 不要在构思阶段过度纠结细节

### 如何使用
1. 逐项检查，在 [ ] 中打 ✓
2. 对于不确定的项，标注 ⚠️ 并说明
3. 如果有不适用的项，标注 N/A
4. 全部检查完成后，总体评估

---

## Part 1: 内容质量检查

### 核心观点
- [ ] 核心观点清晰明确
- [ ] 论点在开头部分就提出
- [ ] 全文围绕核心观点展开
- [ ] 结尾呼应核心观点

**自评：**
- 核心观点是：[一句话概括]
- 清晰度：⭐⭐⭐⭐⭐ (X/5)

---

### 论证质量
- [ ] 每个论点都有论据支撑
- [ ] 论据充分（数据、案例、引用）
- [ ] 论证逻辑严密，无明显漏洞
- [ ] 因果关系合理
- [ ] 无循环论证、以偏概全等逻辑谬误

**自评：**
- 论证强度：⭐⭐⭐⭐⭐ (X/5)
- 最弱的论证在：[位置]
- 改进方案：[如何改进]

---

### 素材运用
- [ ] 充分使用了 Brief 中提供的素材
- [ ] 数据准确，标注来源
- [ ] 案例真实、具体
- [ ] 引用准确，注明出处
- [ ] 图片/截图使用恰当

**素材清单：**
- 使用的数据：[列出]
- 使用的案例：[列出]
- 使用的引用：[列出]
- 未使用但可考虑的素材：[列出]

---

### 深度和独特性
- [ ] 有独特视角或新鲜洞察
- [ ] 不是人云亦云的内容
- [ ] 有个人经历或独特案例
- [ ] 提供了新信息或新角度

**自评：**
- 独特性：⭐⭐⭐⭐⭐ (X/5)
- 最大亮点：[描述]
- 差异化体现在：[描述]

---

### 实用价值
- [ ] 对读者有实际价值
- [ ] 提供了可操作的建议
- [ ] 解决了具体问题
- [ ] 读者能够直接应用

**自评：**
- 实用性：⭐⭐⭐⭐⭐ (X/5)
- 核心价值：[描述]
- 读者收获：[描述]

---

## Part 2: 结构和组织

### 整体结构
- [ ] 开头-正文-结尾结构完整
- [ ] 各部分比例合理
- [ ] 逻辑顺序清晰
- [ ] 无突兀的转折或跳跃

**结构自评：**
- 开头占比：[X]%（理想：10-15%）
- 正文占比：[X]%（理想：75-85%）
- 结尾占比：[X]%（理想：5-10%）
- 结构平衡度：⭐⭐⭐⭐⭐ (X/5)

---

### 开头质量
- [ ] 前 3 段/3 秒能抓住读者
- [ ] 明确了文章主题
- [ ] 制造了好奇或共鸣
- [ ] 没有冗长的铺垫

**开头类型：** [场景/数据/提问/其他]
**开头效果自评：** ⭐⭐⭐⭐⭐ (X/5)

---

### 小标题使用
- [ ] 小标题简洁明确
- [ ] 能概括本段核心内容
- [ ] 方便读者扫读
- [ ] 数量适中（不过多不过少）

**小标题清单：**
1. [小标题 1] - 是否满意：是/否
2. [小标题 2] - 是否满意：是/否
3. [小标题 3] - 是否满意：是/否

---

### 段落结构
- [ ] 每段有明确主题
- [ ] 段落长度适中（根据平台）
- [ ] 段落之间过渡自然
- [ ] 重要信息单独成段

**段落自查：**
- 平均段落长度：[X] 行
- 最长段落：[X] 行（位置：[X]）
- 是否需要拆分：是/否

---

### 结尾质量
- [ ] 有力收束，不拖沓
- [ ] 总结或升华了核心观点
- [ ] 留下思考或行动建议
- [ ] 有互动引导（如适用）

**结尾类型：** [总结/行动/思考/其他]
**结尾效果自评：** ⭐⭐⭐⭐⭐ (X/5)

---

## Part 3: 标题和开篇

### 标题检查
- [ ] 标题吸引人，能激发好奇
- [ ] 标题真实，与内容相符
- [ ] 标题长度合适（根据平台）
- [ ] 包含核心关键词
- [ ] 没有标题党

**标题：** [你的标题]

**标题自评：**
- 吸引力：⭐⭐⭐⭐⭐ (X/5)
- 准确性：⭐⭐⭐⭐⭐ (X/5)
- 备选标题：[如果有]

---

### 副标题/引言（如适用）
- [ ] 补充了标题的信息
- [ ] 长度合适
- [ ] 与标题配合完整

**副标题：** [如果有]

---

## Part 4: 平台适配检查

### [你的目标平台] 特定检查

#### 微信公众号
- [ ] 标题 15-25 字
- [ ] 段落 3-5 行（手机阅读）
- [ ] 有适当留白
- [ ] 小标题清晰
- [ ] 配图 3-8 张
- [ ] 语言轻松、口语化

#### 知乎
- [ ] 逻辑严密，论证充分
- [ ] 有数据支撑
- [ ] 开头有目录（如果长文）
- [ ] 专业但说人话
- [ ] 来源标注清楚

#### 小红书
- [ ] 标题有 emoji，15-20 字
- [ ] 段落超短（1-3 行）
- [ ] 大量留白
- [ ] 配图 6-9 张，精美
- [ ] 话题标签 3-5 个
- [ ] 语言活泼、分享感

#### Reddit
- [ ] 标题诚实、直接
- [ ] 内容真实，无营销味
- [ ] 承认局限性
- [ ] 详细、有证据
- [ ] 语言自然、谦逊
- [ ] 愿意接受质疑

#### Medium
- [ ] 标题+副标题完整
- [ ] 开头有钩子
- [ ] 叙事+洞察结合
- [ ] 散文质量高
- [ ] 1500-3000 字
- [ ] 结尾有共鸣

#### LinkedIn
- [ ] Hook 前 2 行足够强
- [ ] 专业价值明确
- [ ] 格式清晰（短段、箭头）
- [ ] 结尾有互动问题
- [ ] 3-5 个 hashtag
- [ ] 专业但不 corporate

---

## Part 5: 语言和风格

### 人设匹配度
- [ ] 符合 `my-voice.md` 中的风格
- [ ] 体现 `my-values.md` 中的价值观
- [ ] 看起来像"我"写的

**参考文章对照：**
- 参考了：`[文章路径]`
- 风格相似度：⭐⭐⭐⭐⭐ (X/5)

---

### AI 味检查（重要！）
- [ ] 无"在当今社会"之类的套话
- [ ] 无"首先...其次...最后"的机械结构
- [ ] 无过度工整的对仗
- [ ] 有个人视角（"我"、"我的"）
- [ ] 有真实感受和思考过程
- [ ] 不完美但真实

**AI 味自评：** 🟢无 / 🟡轻微 / 🔴明显

**如果有 AI 味，主要在：**
- [位置] - [具体问题]

---

### 语言质量
- [ ] 无错别字
- [ ] 无语病
- [ ] 无逻辑不通的句子
- [ ] 标点符号使用正确
- [ ] 句子长短有变化
- [ ] 有节奏感

**语言质量自评：** ⭐⭐⭐⭐⭐ (X/5)

---

### 口语化程度（根据平台）
- [ ] 符合目标平台的口语化要求
- [ ] 说人话，不装腔作势
- [ ] 专业但接地气（知乎/LinkedIn）
- [ ] 轻松活泼（小红书/微信）

**口语化自评：** ⭐⭐⭐⭐⭐ (X/5)

---

## Part 6: 细节检查

### 数字和数据
- [ ] 所有数字准确
- [ ] 单位统一
- [ ] 数据来源标注
- [ ] 时效性说明（如需要）

**数据清单：**
- [数据 1] - 来源：[X]
- [数据 2] - 来源：[X]

---

### 引用和来源
- [ ] 所有引用准确
- [ ] 来源标注清楚
- [ ] 无版权问题
- [ ] 引用格式规范

**引用清单：**
- [引用 1] - 来源：[X]
- [引用 2] - 来源：[X]

---

### 专有名词
- [ ] 产品名称拼写正确
- [ ] 公司名称准确
- [ ] 人名正确
- [ ] 技术术语准确

**专有名词清单：**
- [名词 1] - 确认：✓
- [名词 2] - 确认：✓

---

### 配图标注
- [ ] 配图位置已标注
- [ ] 配图需求已说明
- [ ] 配图来源已标注（如有）

**配图需求：**
1. [位置] - [需求描述]
2. [位置] - [需求描述]

---

## Part 7: 排版和格式

### Markdown 格式
- [ ] 标题层级正确（#, ##, ###）
- [ ] 列表格式正确
- [ ] 加粗、斜体使用恰当
- [ ] 链接格式正确（如有）
- [ ] 代码块格式正确（如有）

---

### 视觉呈现
- [ ] 留白充足
- [ ] 段落分明
- [ ] 重点突出
- [ ] 易于扫读
- [ ] 视觉舒适

---

## Part 8: 风险检查

### 内容风险
- [ ] 无政治敏感内容
- [ ] 无商业利益冲突
- [ ] 无虚假信息
- [ ] 无侵权内容
- [ ] 无可能引发争议的表述

**风险评估：** 🟢低风险 / 🟡中风险 / 🔴高风险

**如果有风险，说明：**
- [风险点] - [如何规避]

---

### 品牌形象
- [ ] 符合个人品牌定位
- [ ] 不损害专业形象
- [ ] 价值观一致
- [ ] 长期看有益

---

## Part 9: 字数和篇幅

### 字数检查
- **目标字数：** [根据 Brief]
- **实际字数：** [你的字数]
- **差异：** +/- [X] 字

**评估：**
- [ ] 字数合适
- [ ] 字数偏多，需压缩
- [ ] 字数偏少，需扩充

---

### 阅读时长（预估）
- **预估阅读时长：** [X] 分钟
- **平台最佳时长：** [根据平台]
- **是否合适：** 是/否

---

## Part 10: Brief 符合度

### Brief 要求检查
- [ ] 包含了所有必须的要点
- [ ] 避免了禁止的内容
- [ ] 使用了推荐的素材
- [ ] 符合风格要求
- [ ] 达到质量标准

**Brief 符合度：** ⭐⭐⭐⭐⭐ (X/5)

---

### 与 Brief 的偏离
**有意的偏离：**
- [偏离点 1] - 原因：[说明]
- [偏离点 2] - 原因：[说明]

**意外的偏离：**
- [偏离点] - 需要修正

---

## Part 11: 整体评估

### 自我评分

**内容质量：** ⭐⭐⭐⭐⭐ (X/5)
- 观点清晰度：X/5
- 论证充分度：X/5
- 独特性：X/5
- 实用性：X/5

**结构质量：** ⭐⭐⭐⭐⭐ (X/5)
- 整体结构：X/5
- 开头质量：X/5
- 结尾质量：X/5
- 逻辑流畅度：X/5

**平台适配：** ⭐⭐⭐⭐⭐ (X/5)
- 风格匹配：X/5
- 格式规范：X/5
- 长度适中：X/5

**语言质量：** ⭐⭐⭐⭐⭐ (X/5)
- 人设匹配：X/5
- 去 AI 味：X/5
- 语言流畅：X/5
- 无错误：X/5

**综合得分：** XX/100

---

### 优势分析
**这篇稿件的亮点：**
1. [亮点 1]
2. [亮点 2]
3. [亮点 3]

---

### 不足分析
**这篇稿件的不足：**
1. [不足 1] - 严重程度：高/中/低
2. [不足 2] - 严重程度：高/中/低
3. [不足 3] - 严重程度：高/中/低

---

### 改进计划
**必须改进的：**
- [ ] [改进点 1]
- [ ] [改进点 2]

**建议改进的：**
- [ ] [改进点 1]
- [ ] [改进点 2]

**可选改进的：**
- [ ] [改进点 1]
- [ ] [改进点 2]

---

## Part 12: 提交决策

### 是否准备提交？

- [ ] ✅ **可以提交** - 质量达标，可进入筛选流程
- [ ] ⚠️ **修改后提交** - 有明确的改进点，修改后再提交
- [ ] ❌ **需要重写** - 存在重大问题，建议重写

---

### 提交前最后确认

- [ ] 文件命名正确
- [ ] 保存在正确位置
- [ ] Metadata 填写完整
- [ ] 创作说明已添加
- [ ] 自检清单已完成

---

### 给审校团队的说明

**重点关注：**
- [请审校团队特别关注的地方]

**不确定的地方：**
- [标注不确定的内容，请审校团队把关]

**特殊处理说明：**
- [如果有特殊处理，说明原因]

---

## 检查完成

**检查完成时间：** YYYY-MM-DD HH:MM
**检查者：** [Writer 名称]
**下一步：** [提交/修改/重写]

---

**记住：这个检查清单是帮助你提高质量的工具，不是束缚你创作的枷锁。核心是：写出优质的、符合平台调性的、有个人风格的内容。**