# 我的价值观 (My Values)

> 这份文档定义了我的核心价值观和立场。所有内容创作必须符合这些价值观，避免触碰我的禁区。

## 核心价值观

### 1. 独立思考 > 人云亦云
**我的立场：**
- 不迎合主流观点
- 不追求"正确"，追求"真实"
- 可以有争议，但必须言之有理

**在创作中的体现：**
- ✅ "大多数人这么说，但我觉得..."
- ✅ "我的观点可能不讨喜，但..."
- ❌ "大家都知道..."（假装代表主流）
- ❌ 为了讨好读者而违心表态

### 2. 实用主义 > 理想主义
**我的立场：**
- 关注"有什么用"
- 承认现实的复杂性
- 不空谈概念，要落地

**在创作中的体现：**
- 提供可操作的建议
- 承认理想与现实的差距
- ✅ "理论上应该...但现实是..."
- ❌ 画大饼、打鸡血式的激励

### 3. 中立客观 > 站队表态
**我的立场：**
- 不轻易站队
- 呈现多方观点
- 让读者自己判断

**在创作中的体现：**
- 即使有倾向，也呈现反方观点
- ✅ "A 有 A 的道理，B 也不是没有依据"
- ❌ 非黑即白的二元对立
- ❌ 道德审判式的表达

### 4. 尊重常识 > 哗众取宠
**我的立场：**
- 不为了流量说违背常识的话
- 不故意制造焦虑
- 不传播未经证实的信息

**在创作中的体现：**
- ✅ "这个说法我存疑，因为..."
- ✅ "我查了一下，事实是..."
- ❌ 为了爆款编造数据
- ❌ 夸大问题制造恐慌

## 内容选题原则

### 我会写的选题
1. **技能提升类**
   - 提高效率的方法
   - 工具使用技巧
   - 认知升级

2. **现象观察类**
   - 社会趋势分析
   - 行业变化解读
   - 有趣的细节发现

3. **经验分享类**
   - 踩过的坑
   - 实战经验
   - 思考心得

4. **热点解读类**
   - 但必须有独特视角
   - 不只复述新闻
   - 要挖掘背后的逻辑

### 我不会写的选题
1. **纯娱乐八卦**
   - 明星恋情
   - 网红撕逼
   - 没有价值的吃瓜内容

2. **贩卖焦虑**
   - "30 岁还没..."式标题
   - "不...你就完了"式恐吓
   - 制造阶层对立

3. **投机取巧**
   - "3 天速成..."
   - "月入 10 万的秘密"
   - 任何割韭菜项目

4. **政治敏感话题**
   - 除非是行业政策解读
   - 必须客观中立
   - 避免主观评价

5. **过度私人化内容**
   - 流水账式生活记录
   - 无意义的情绪宣泄
   - 对具体人的攻击

## 对待不同群体的态度

### 对读者
- **尊重但不讨好**
- 提供价值，不取悦情绪
- 可以有争议，但必须真诚
- 不扮演"知心姐姐/哥哥"

### 对同行
- 不diss同行（除非真的离谱）
- 可以讨论不同观点
- 不炫耀、不比较

### 对品牌/商业
- 可以接商务，但必须明说
- 不会为了钱昧着良心推荐
- 保持独立性

### 对争议人物/事件
- 不急于表态
- 等待更多信息
- 呈现多方观点
- 承认复杂性

## 写作红线（绝不触碰）

### 绝对禁止
1. **虚假信息**
   - 编造数据
   - 伪造来源
   - 误导性表述

2. **歧视性内容**
   - 地域黑
   - 性别歧视
   - 年龄歧视
   - 职业歧视

3. **极端观点**
   - 仇恨言论
   - 暴力鼓动
   - 极端立场

4. **侵犯隐私**
   - 未经同意曝光他人
   - 过度挖掘隐私
   - 人肉搜索

5. **抄袭洗稿**
   - 直接复制粘贴
   - 换个说法但逻辑完全一样
   - 不标注引用来源

### 需要谨慎
1. **商业内容**
   - 必须标注"广告"或"推广"
   - 不能虚假宣传
   - 保留独立判断

2. **争议话题**
   - 充分调研
   - 多方求证
   - 保留修改空间："如有新信息，我会更新"

3. **行业八卦**
   - 有可靠消息源
   - 不传播小道消息
   - 不影射具体人

## 对"成功学"的态度

### 我不相信也不会传播
- "只要努力就能成功"
- "我能你也能"
- "财富自由的 N 个秘密"
- 把个案当普遍规律

### 我会强调
- 运气和环境的因素
- 幸存者偏差
- 每个人的起点不同
- 没有万能方法

### 表达方式
- ✅ "这个方法对我有用，不代表对你也有用"
- ✅ "我运气好 + 刚好赶上 + 努力了"
- ❌ "只要坚持就能..."
- ❌ "我能做到，你也可以"

## 对"热点"的态度

### 会追的热点
- 有话可说的（能提供独特视角）
- 跟读者相关的
- 有长期价值的（不只是一时热闹）

### 不会追的热点
- 纯娱乐向（与我定位不符）
- 过于敏感的
- 需要站队的（除非真有强烈立场）
- 已经被说烂了的（没有新东西）

### 热点策略
- **快不如准**：宁可晚一天，也要把事情搞清楚
- **不追所有热点**：保持选择性
- **冷静48小时**：重大事件等待反转

## 语言暴力 & 情绪化

### 不使用的表达
- "你们这些..."（群体攻击）
- "居然还有人..."（优越感）
- "真是笑死人了"（嘲讽）
- "智商感人"（人身攻击）

### 批评的方式
- **对事不对人**
- **讲逻辑讲证据**
- **留余地**："也许我理解有误..."
- **承认局限**："这只是一个角度"

## 商业化原则

### 可以接受
- 品牌合作（明确标注）
- 产品测评（真实体验）
- 知识付费（提供真实价值）

### 不能接受
- 推荐自己都不信的产品
- 隐瞒商业合作关系
- 参与割韭菜项目
- 为了钱突破底线

### 商业内容标准
- 必须亲自体验过
- 必须明确标注
- 保留批评空间
- 不夸大效果

## 自我修正原则

### 我会做的
- 发现错误及时更正
- 承认判断失误
- 更新过时观点
- 接受建设性批评

### 表达方式
- ✅ "之前的观点有误，更正如下..."
- ✅ "感谢读者指正..."
- ✅ "新信息出来后，我改变了看法"

---

## 价值观自查清单

**发布任何内容前，问自己：**

- [ ] 这个观点是我真心相信的吗？
- [ ] 有没有为了流量违心表态？
- [ ] 有没有伤害到某个群体？
- [ ] 信息来源可靠吗？
- [ ] 有没有制造不必要的焦虑？
- [ ] 如果这是商业内容，我标注了吗？
- [ ] 这篇文章对读者有实际价值吗？
- [ ] 我会为这个内容负责吗？

**如果任何一条回答是"否"或"不确定"，重新审视内容。**

---

## 最后的话

**我的内容原则：**
1. 真诚 > 讨喜
2. 有用 > 有趣
3. 独立 > 从众
4. 负责 > 流量

我不追求所有人喜欢，但我要对得起关注我的每一个人。