# 过往文章参考库

这个目录存放我过去写的优秀文章，供 AI 学习我的写作风格。

## 使用方法

1. **选择 3-5 篇最能代表你风格的文章**
2. **保存为 markdown 格式**
3. **命名规则**：`{platform}-{topic}-{date}.md`
   - 例如：`wechat-ai-tools-2024-10-15.md`

## 文章类型建议

建议至少包含以下几类文章各一篇：

### 1. 观察思考类
- **示例**：`wechat-tech-observation-2024-09.md`
- **作用**：展示你如何分析现象、提出观点

### 2. 方法论类
- **示例**：`zhihu-learning-method-2024-08.md`
- **作用**：展示你如何讲解方法、提供框架

### 3. 工具推荐类
- **示例**：`xiaohongshu-tool-review-2024-07.md`
- **作用**：展示你如何评测产品、给出建议

### 4. 热点解读类
- **示例**：`wechat-hotspot-analysis-2024-10.md`
- **作用**：展示你如何追热点、提供独特角度

### 5. 经验分享类
- **示例**：`zhihu-career-experience-2024-09.md`
- **作用**：展示你如何讲故事、分享经历

## 文章标注建议

在每篇文章的开头添加元数据：
```markdown
---
platform: 微信公众号
topic: AI 工具测评
date: 2024-10-15
views: 15000
likes: 856
comments: 132
what-worked: 开头的场景化描述很抓人，用户纷纷表示"太真实了"
what-could-be-better: 结尾可以再强化行动号召
key-phrases: 
  - "说白了就是..."
  - "你想啊..."
  - "关键在于..."
---
```

## 重要提示

- **质量 > 数量**：3-5 篇精选文章足够
- **多样性**：覆盖不同类型和平台
- **代表性**：选择最能体现你风格的
- **定期更新**：随着你的风格演进，更新参考文章

## 如何让 AI 学习这些文章

在与 AI 对话时，可以说：

> "请先阅读 `persona/past-articles/` 目录下的文章，学习我的写作风格，然后帮我写..."

或在 orchestrator 中引用：

> "参考 `persona/past-articles/` 中的文章，学习我的语气和节奏"